/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.spring.cache;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.spring.cache.CouchbaseCache;
import java.util.concurrent.TimeUnit;

public class CacheBuilder {
    private static final int DEFAULT_TTL = 0;
    private Bucket bucket;
    private int cacheExpiry = 0;

    protected CacheBuilder() {
    }

    public static CacheBuilder newInstance(Bucket bucket) {
        return new CacheBuilder().withBucket(bucket);
    }

    public CacheBuilder withBucket(Bucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("A non-null Bucket is required for all cache builders");
        }
        this.bucket = bucket;
        return this;
    }

    @Deprecated
    public CacheBuilder withExpirationInMillis(int expiration) {
        return this.withExpiration((int)TimeUnit.MILLISECONDS.toSeconds(expiration));
    }

    public CacheBuilder withExpiration(int expiration) {
        this.cacheExpiry = expiration;
        return this;
    }

    public CouchbaseCache build(String cacheName) {
        return new CouchbaseCache(cacheName, this.bucket, this.cacheExpiry);
    }
}

