/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sarif;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.PropertyBag;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"location", "module", "threadId", "parameters", "properties"})
public class StackFrame {
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="A location within a programming artifact.")
    private Location location;
    @JsonProperty(value="module")
    @JsonPropertyDescription(value="The name of the module that contains the code of this stack frame.")
    private String module;
    @JsonProperty(value="threadId")
    @JsonPropertyDescription(value="The thread identifier of the stack frame.")
    private Integer threadId;
    @JsonProperty(value="parameters")
    @JsonPropertyDescription(value="The parameters of the call that is executing.")
    private List<String> parameters = null;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="location")
    public Location getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(Location location) {
        this.location = location;
    }

    public StackFrame withLocation(Location location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="module")
    public String getModule() {
        return this.module;
    }

    @JsonProperty(value="module")
    public void setModule(String module) {
        this.module = module;
    }

    public StackFrame withModule(String module) {
        this.module = module;
        return this;
    }

    @JsonProperty(value="threadId")
    public Integer getThreadId() {
        return this.threadId;
    }

    @JsonProperty(value="threadId")
    public void setThreadId(Integer threadId) {
        this.threadId = threadId;
    }

    public StackFrame withThreadId(Integer threadId) {
        this.threadId = threadId;
        return this;
    }

    @JsonProperty(value="parameters")
    public List<String> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public StackFrame withParameters(List<String> parameters) {
        this.parameters = parameters;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public StackFrame withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackFrame.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("module");
        sb.append('=');
        sb.append(this.module == null ? "<null>" : this.module);
        sb.append(',');
        sb.append("threadId");
        sb.append('=');
        sb.append(this.threadId == null ? "<null>" : this.threadId);
        sb.append(',');
        sb.append("parameters");
        sb.append('=');
        sb.append(this.parameters == null ? "<null>" : this.parameters);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.threadId == null ? 0 : this.threadId.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        result = result * 31 + (this.module == null ? 0 : this.module.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StackFrame)) {
            return false;
        }
        StackFrame rhs = (StackFrame)other;
        return (this.threadId == rhs.threadId || this.threadId != null && this.threadId.equals(rhs.threadId)) && (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.parameters == rhs.parameters || this.parameters != null && this.parameters.equals(rhs.parameters)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties)) && (this.module == rhs.module || this.module != null && this.module.equals(rhs.module));
    }
}

