/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sarif;

import com.contrastsecurity.sarif.ArtifactContent;
import com.contrastsecurity.sarif.ArtifactLocation;
import com.contrastsecurity.sarif.Hashes;
import com.contrastsecurity.sarif.Message;
import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.Role;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"description", "location", "parentIndex", "offset", "length", "roles", "mimeType", "contents", "encoding", "sourceLanguage", "hashes", "lastModifiedTimeUtc", "properties"})
public class Artifact {
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message description;
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="Specifies the location of an artifact.")
    private ArtifactLocation location;
    @JsonProperty(value="parentIndex")
    @JsonPropertyDescription(value="Identifies the index of the immediate parent of the artifact, if this artifact is nested.")
    private Integer parentIndex = -1;
    @JsonProperty(value="offset")
    @JsonPropertyDescription(value="The offset in bytes of the artifact within its containing artifact.")
    private Integer offset;
    @JsonProperty(value="length")
    @JsonPropertyDescription(value="The length of the artifact in bytes.")
    private Integer length = -1;
    @JsonProperty(value="roles")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="The role or roles played by the artifact in the analysis.")
    private Set<Role> roles = null;
    @JsonProperty(value="mimeType")
    @JsonPropertyDescription(value="The MIME type (RFC 2045) of the artifact.")
    private String mimeType;
    @JsonProperty(value="contents")
    @JsonPropertyDescription(value="Represents the contents of an artifact.")
    private ArtifactContent contents;
    @JsonProperty(value="encoding")
    @JsonPropertyDescription(value="Specifies the encoding for an artifact object that refers to a text file.")
    private String encoding;
    @JsonProperty(value="sourceLanguage")
    @JsonPropertyDescription(value="Specifies the source language for any artifact object that refers to a text file that contains source code.")
    private String sourceLanguage;
    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="A dictionary, each of whose keys is the name of a hash function and each of whose values is the hashed value of the artifact produced by the specified hash function.")
    private Hashes hashes;
    @JsonProperty(value="lastModifiedTimeUtc")
    @JsonPropertyDescription(value="The Coordinated Universal Time (UTC) date and time at which the artifact was most recently modified. See \"Date/time properties\" in the SARIF spec for the required format.")
    private Date lastModifiedTimeUtc;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="description")
    public Message getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(Message description) {
        this.description = description;
    }

    public Artifact withDescription(Message description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="location")
    public ArtifactLocation getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(ArtifactLocation location) {
        this.location = location;
    }

    public Artifact withLocation(ArtifactLocation location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="parentIndex")
    public Integer getParentIndex() {
        return this.parentIndex;
    }

    @JsonProperty(value="parentIndex")
    public void setParentIndex(Integer parentIndex) {
        this.parentIndex = parentIndex;
    }

    public Artifact withParentIndex(Integer parentIndex) {
        this.parentIndex = parentIndex;
        return this;
    }

    @JsonProperty(value="offset")
    public Integer getOffset() {
        return this.offset;
    }

    @JsonProperty(value="offset")
    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Artifact withOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @JsonProperty(value="length")
    public Integer getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    public void setLength(Integer length) {
        this.length = length;
    }

    public Artifact withLength(Integer length) {
        this.length = length;
        return this;
    }

    @JsonProperty(value="roles")
    public Set<Role> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public Artifact withRoles(Set<Role> roles) {
        this.roles = roles;
        return this;
    }

    @JsonProperty(value="mimeType")
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="mimeType")
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Artifact withMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @JsonProperty(value="contents")
    public ArtifactContent getContents() {
        return this.contents;
    }

    @JsonProperty(value="contents")
    public void setContents(ArtifactContent contents) {
        this.contents = contents;
    }

    public Artifact withContents(ArtifactContent contents) {
        this.contents = contents;
        return this;
    }

    @JsonProperty(value="encoding")
    public String getEncoding() {
        return this.encoding;
    }

    @JsonProperty(value="encoding")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Artifact withEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @JsonProperty(value="sourceLanguage")
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    @JsonProperty(value="sourceLanguage")
    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public Artifact withSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
    }

    @JsonProperty(value="hashes")
    public Hashes getHashes() {
        return this.hashes;
    }

    @JsonProperty(value="hashes")
    public void setHashes(Hashes hashes) {
        this.hashes = hashes;
    }

    public Artifact withHashes(Hashes hashes) {
        this.hashes = hashes;
        return this;
    }

    @JsonProperty(value="lastModifiedTimeUtc")
    public Date getLastModifiedTimeUtc() {
        return this.lastModifiedTimeUtc;
    }

    @JsonProperty(value="lastModifiedTimeUtc")
    public void setLastModifiedTimeUtc(Date lastModifiedTimeUtc) {
        this.lastModifiedTimeUtc = lastModifiedTimeUtc;
    }

    public Artifact withLastModifiedTimeUtc(Date lastModifiedTimeUtc) {
        this.lastModifiedTimeUtc = lastModifiedTimeUtc;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Artifact withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Artifact.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("parentIndex");
        sb.append('=');
        sb.append(this.parentIndex == null ? "<null>" : this.parentIndex);
        sb.append(',');
        sb.append("offset");
        sb.append('=');
        sb.append(this.offset == null ? "<null>" : this.offset);
        sb.append(',');
        sb.append("length");
        sb.append('=');
        sb.append(this.length == null ? "<null>" : this.length);
        sb.append(',');
        sb.append("roles");
        sb.append('=');
        sb.append(this.roles == null ? "<null>" : this.roles);
        sb.append(',');
        sb.append("mimeType");
        sb.append('=');
        sb.append(this.mimeType == null ? "<null>" : this.mimeType);
        sb.append(',');
        sb.append("contents");
        sb.append('=');
        sb.append(this.contents == null ? "<null>" : this.contents);
        sb.append(',');
        sb.append("encoding");
        sb.append('=');
        sb.append(this.encoding == null ? "<null>" : this.encoding);
        sb.append(',');
        sb.append("sourceLanguage");
        sb.append('=');
        sb.append(this.sourceLanguage == null ? "<null>" : this.sourceLanguage);
        sb.append(',');
        sb.append("hashes");
        sb.append('=');
        sb.append(this.hashes == null ? "<null>" : this.hashes);
        sb.append(',');
        sb.append("lastModifiedTimeUtc");
        sb.append('=');
        sb.append(this.lastModifiedTimeUtc == null ? "<null>" : this.lastModifiedTimeUtc);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.parentIndex == null ? 0 : this.parentIndex.hashCode());
        result = result * 31 + (this.offset == null ? 0 : this.offset.hashCode());
        result = result * 31 + (this.roles == null ? 0 : this.roles.hashCode());
        result = result * 31 + (this.lastModifiedTimeUtc == null ? 0 : this.lastModifiedTimeUtc.hashCode());
        result = result * 31 + (this.length == null ? 0 : this.length.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = result * 31 + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = result * 31 + (this.contents == null ? 0 : this.contents.hashCode());
        result = result * 31 + (this.hashes == null ? 0 : this.hashes.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.sourceLanguage == null ? 0 : this.sourceLanguage.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Artifact)) {
            return false;
        }
        Artifact rhs = (Artifact)other;
        return (this.parentIndex == rhs.parentIndex || this.parentIndex != null && this.parentIndex.equals(rhs.parentIndex)) && (this.offset == rhs.offset || this.offset != null && this.offset.equals(rhs.offset)) && (this.roles == rhs.roles || this.roles != null && this.roles.equals(rhs.roles)) && (this.lastModifiedTimeUtc == rhs.lastModifiedTimeUtc || this.lastModifiedTimeUtc != null && this.lastModifiedTimeUtc.equals(rhs.lastModifiedTimeUtc)) && (this.length == rhs.length || this.length != null && this.length.equals(rhs.length)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.mimeType == rhs.mimeType || this.mimeType != null && this.mimeType.equals(rhs.mimeType)) && (this.encoding == rhs.encoding || this.encoding != null && this.encoding.equals(rhs.encoding)) && (this.contents == rhs.contents || this.contents != null && this.contents.equals(rhs.contents)) && (this.hashes == rhs.hashes || this.hashes != null && this.hashes.equals(rhs.hashes)) && (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.sourceLanguage == rhs.sourceLanguage || this.sourceLanguage != null && this.sourceLanguage.equals(rhs.sourceLanguage)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

