/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.selector;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class CombinedBy
extends By {
    private final @Nullable By androidSelector;
    private final @Nullable By iosSelector;

    private CombinedBy(@Nullable By androidSelector, @Nullable By iosSelector) {
        this.androidSelector = androidSelector;
        this.iosSelector = iosSelector;
    }

    public static CombinedBy android(By android) {
        return new CombinedBy(android, null);
    }

    public CombinedBy ios(By ios) {
        return new CombinedBy(this.androidSelector, ios);
    }

    public WebElement findElement(SearchContext context) {
        return this.chooseSelector(context).findElement(context);
    }

    public List<WebElement> findElements(SearchContext context) {
        return this.chooseSelector(context).findElements(context);
    }

    private By chooseSelector(SearchContext context) {
        if (AppiumDriverUnwrapper.isAndroid(context)) {
            return Objects.requireNonNull(this.androidSelector, "Android selector not given");
        }
        if (AppiumDriverUnwrapper.isIos(context)) {
            return Objects.requireNonNull(this.iosSelector, "iOS selector not given");
        }
        throw new UnsupportedOperationException("Unsupported webdriver: " + String.valueOf(WebDriverRunner.getWebDriver()));
    }

    public String toString() {
        if (this.androidSelector != null && this.iosSelector != null) {
            return String.format("[android:%s, ios:%s]", this.androidSelector, this.iosSelector);
        }
        if (this.androidSelector != null) {
            return this.androidSelector.toString();
        }
        if (this.iosSelector != null) {
            return this.iosSelector.toString();
        }
        return "CombinedBy: null";
    }
}

