/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.ClickMethod;
import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.appium.AppiumClickOptions;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import com.codeborne.selenide.commands.Click;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import io.appium.java_client.AppiumDriver;
import java.time.Duration;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;

public class AppiumClick
extends Click {
    private static final String FINGER_1 = "finger1";

    public void execute(WebElementSource locator, Object @Nullable [] args) {
        if (!AppiumDriverUnwrapper.isMobile(locator.driver())) {
            super.execute(locator, args);
            return;
        }
        ClickOptions options = this.options(args);
        WebElement webElement = this.findElement(locator, options.isForce());
        if (options instanceof AppiumClickOptions) {
            AppiumClickOptions appiumClickOptions = (AppiumClickOptions)options;
            this.click(locator.driver(), webElement, appiumClickOptions);
        } else {
            this.click(locator.driver(), webElement, options);
        }
    }

    protected void click(Driver driver, WebElement webElement, ClickOptions options) {
        if (AppiumDriverUnwrapper.isMobile(driver)) {
            if (options.timeout() != null) {
                throw new UnsupportedOperationException("Click timeout is not supported in mobile");
            }
            if (options.clickMethod() == ClickMethod.JS || driver.config().clickViaJs()) {
                throw new UnsupportedOperationException("Click using JavaScript is not supported in mobile");
            }
        }
        super.click(driver, webElement, options);
    }

    protected void click(Driver driver, WebElement webElement, AppiumClickOptions appiumClickOptions) {
        switch (appiumClickOptions.appiumClickMethod()) {
            case TAP_WITH_OFFSET: {
                this.performTapWithOffset(driver, webElement, appiumClickOptions.offsetX(), appiumClickOptions.offsetY());
                break;
            }
            case TAP: {
                this.performTapWithOffset(driver, webElement, 0, 0);
                break;
            }
            case DOUBLE_TAP: {
                this.performDoubleTap(driver, webElement);
                break;
            }
            case LONG_PRESS: {
                this.performLongPress(driver, webElement, appiumClickOptions);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown click option: " + String.valueOf((Object)appiumClickOptions.appiumClickMethod()));
            }
        }
    }

    private void performDoubleTap(Driver driver, WebElement webElement) {
        Point size = webElement.getLocation();
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, FINGER_1);
        Sequence doubleTapSequence = this.getSequenceToPerformTap(finger, size, 0, 0).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(40L))).addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(200L))).addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        this.perform(driver, doubleTapSequence);
    }

    private void performLongPress(Driver driver, WebElement webElement, AppiumClickOptions appiumClickOptions) {
        Point size = webElement.getLocation();
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, FINGER_1);
        Sequence doubleTapSequence = new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), size.getX(), size.getY())).addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)finger, appiumClickOptions.longPressHoldDuration())).addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        this.perform(driver, doubleTapSequence);
    }

    private void performTapWithOffset(Driver driver, WebElement webElement, int offsetX, int offsetY) {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, FINGER_1);
        Point size = this.getCenter(webElement);
        Sequence tapSequence = this.getSequenceToPerformTap(finger, size, offsetX, offsetY);
        this.perform(driver, tapSequence);
    }

    private void perform(Driver driver, Sequence sequence) {
        WebDriver webDriver = driver.getWebDriver();
        AppiumDriver appiumDriver = (AppiumDriver)WebdriverUnwrapper.cast((SearchContext)webDriver, AppiumDriver.class).orElseThrow(() -> new IllegalStateException("Not a mobile webdriver: " + String.valueOf(webDriver)));
        appiumDriver.perform(Collections.singletonList(sequence));
    }

    private Sequence getSequenceToPerformTap(PointerInput finger, Point size, int offsetX, int offsetY) {
        return new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), size.getX() + offsetX, size.getY() + offsetY)).addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(200L))).addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Point getCenter(WebElement element) {
        int x = element.getLocation().getX() + element.getSize().getWidth() / 2;
        int y = element.getLocation().getY() + element.getSize().getHeight() / 2;
        return new Point(x, y);
    }

    protected WebElement findElement(WebElementSource locator, boolean force) {
        if (AppiumDriverUnwrapper.isMobile(locator.driver())) {
            return force ? locator.getWebElement() : locator.findAndAssertElementIsVisible();
        }
        return super.findElement(locator, force);
    }
}

