/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.data.ClickHouseChecker;
import java.io.Serializable;
import java.util.Objects;

public class ClickHouseCredentials
implements Serializable {
    private static final long serialVersionUID = -8883041793709590486L;
    private final String accessToken;
    private final String userName;
    private final String password;

    public static ClickHouseCredentials fromAccessToken(String accessToken) {
        return new ClickHouseCredentials(accessToken);
    }

    public static ClickHouseCredentials fromUserAndPassword(String userName, String password) {
        return new ClickHouseCredentials(userName, password);
    }

    protected ClickHouseCredentials(String accessToken) {
        this.accessToken = ClickHouseChecker.nonNull(accessToken, "accessToken");
        this.userName = null;
        this.password = null;
    }

    protected ClickHouseCredentials(String userName, String password) {
        this.accessToken = null;
        this.userName = ClickHouseChecker.nonBlank(userName, "userName");
        this.password = password != null ? password : "";
    }

    public boolean useAccessToken() {
        return this.accessToken != null;
    }

    public String getAccessToken() {
        if (!this.useAccessToken()) {
            throw new IllegalStateException("No access token specified, please use user name and password instead.");
        }
        return this.accessToken;
    }

    public String getUserName() {
        if (this.useAccessToken()) {
            throw new IllegalStateException("No user name and password specified, please use access token instead.");
        }
        return this.userName;
    }

    public String getPassword() {
        if (this.useAccessToken()) {
            throw new IllegalStateException("No user name and password specified, please use access token instead.");
        }
        return this.password;
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.userName, this.password);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ClickHouseCredentials c = (ClickHouseCredentials)obj;
        return Objects.equals(this.accessToken, c.accessToken) && Objects.equals(this.userName, c.userName) && Objects.equals(this.password, c.password);
    }
}

