/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.concurrent;

import com.cedarsoft.concurrent.MultiLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;

public class MultiReadWriteLock
implements ReadWriteLock {
    @Nonnull
    private final MultiLock multiReadLock;
    @Nonnull
    private final MultiLock multiWriteLock;

    public MultiReadWriteLock(ReadWriteLock ... locks) {
        this(Arrays.asList(locks));
    }

    public MultiReadWriteLock(@Nonnull Iterable<? extends ReadWriteLock> locks) {
        ArrayList<Lock> readLocks = new ArrayList<Lock>();
        ArrayList<Lock> writeLocks = new ArrayList<Lock>();
        for (ReadWriteLock readWriteLock : locks) {
            readLocks.add(readWriteLock.readLock());
            writeLocks.add(readWriteLock.writeLock());
        }
        if (readLocks.isEmpty()) {
            throw new IllegalArgumentException("Need at least one lock");
        }
        this.multiReadLock = new MultiLock(readLocks);
        this.multiWriteLock = new MultiLock(writeLocks);
    }

    @Override
    @Nonnull
    public Lock readLock() {
        return this.multiReadLock;
    }

    @Override
    @Nonnull
    public Lock writeLock() {
        return this.multiWriteLock;
    }
}

