/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.concurrent;

import com.cedarsoft.concurrent.InvalidLockStateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;

public class LogingReentrantLock
implements ReadWriteLock {
    @Nonnull
    private final ReadWriteLock delegate = new ReentrantReadWriteLock();
    @Nonnull
    private final List<Thread> readLockingThreads = new ArrayList<Thread>();
    private final List<Thread> writeLockingThreads = new ArrayList<Thread>();
    @Nonnull
    private final LogingLock readLock = new LogingLock(this.delegate.readLock(), this.readLockingThreads);
    @Nonnull
    private final LogingLock writeLock = new LogingLock(this.delegate.writeLock(), this.writeLockingThreads){

        @Override
        public void lock() {
            if (!LogingReentrantLock.this.readLockingThreads.isEmpty()) {
                throw new InvalidLockStateException(LogingReentrantLock.this.readLockingThreads);
            }
            super.lock();
        }
    };

    @Override
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    public Lock writeLock() {
        return this.writeLock;
    }

    private static class LogingLock
    extends DelegatingLock {
        @Nonnull
        private final List<Thread> lockingThreads;

        private LogingLock(@Nonnull Lock delegate, @Nonnull List<Thread> lockingThreads) {
            super(delegate);
            this.lockingThreads = lockingThreads;
        }

        @Override
        public void lock() {
            this.lockingThreads.add(0, Thread.currentThread());
            super.lock();
        }

        @Override
        public void unlock() {
            this.lockingThreads.remove(Thread.currentThread());
            super.unlock();
        }

        @Nonnull
        public List<? extends Thread> getLockingThreads() {
            return Collections.unmodifiableList(this.lockingThreads);
        }
    }

    private static class DelegatingLock
    implements Lock {
        private final Lock delegate;

        protected DelegatingLock(@Nonnull Lock delegate) {
            this.delegate = delegate;
        }

        @Override
        public void lock() {
            this.delegate.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.delegate.lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.delegate.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.delegate.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            this.delegate.unlock();
        }

        @Override
        public Condition newCondition() {
            return this.delegate.newCondition();
        }
    }
}

