/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.concurrent;

import com.cedarsoft.concurrent.ThreadDeadlockDetector;
import java.io.PrintStream;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultDeadlockListener
implements ThreadDeadlockDetector.Listener {
    private final PrintStream out;

    public DefaultDeadlockListener() {
        this(System.err);
    }

    public DefaultDeadlockListener(@Nonnull PrintStream out) {
        this.out = out;
    }

    @Override
    public void deadlockDetected(@Nonnull Set<? extends Thread> deadlockedThreads) {
        this.out.println("Deadlocked Threads:");
        this.out.println("-------------------");
        for (Thread thread : deadlockedThreads) {
            this.out.println(thread);
            for (StackTraceElement ste : thread.getStackTrace()) {
                this.out.println("\t" + ste);
            }
        }
    }
}

