/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.concurrent;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;

public class ThreadDeadlockDetector {
    private static final long DEFAULT_DEADLOCK_CHECK_PERIOD = 10000L;
    @Nonnull
    private final Timer threadCheck = new Timer("ThreadDeadlockDetector", true);
    @Nonnull
    private final ThreadMXBean mXBean = ManagementFactory.getThreadMXBean();
    private final long deadlockCheckPeriod;
    @Nonnull
    private final Collection<Listener> listeners = new CopyOnWriteArraySet<Listener>();

    public ThreadDeadlockDetector() {
        this(10000L);
    }

    public ThreadDeadlockDetector(long deadlockCheckPeriod) {
        this.deadlockCheckPeriod = deadlockCheckPeriod;
    }

    public void start() {
        this.threadCheck.schedule(new TimerTask(){

            @Override
            public void run() {
                ThreadDeadlockDetector.this.checkForDeadlocks();
            }
        }, this.deadlockCheckPeriod);
    }

    public void stop() {
        this.threadCheck.cancel();
    }

    private void checkForDeadlocks() {
        long[] ids = this.findDeadlockedThreads();
        if (ids != null && ids.length > 0) {
            HashSet<Thread> threads = new HashSet<Thread>();
            for (long id : ids) {
                threads.add(ThreadDeadlockDetector.findMatchingThread(this.mXBean.getThreadInfo(id)));
            }
            this.fireDeadlockDetected(threads);
        }
        this.fireCheckRun();
    }

    private long[] findDeadlockedThreads() {
        if (this.mXBean.isSynchronizerUsageSupported()) {
            return this.mXBean.findDeadlockedThreads();
        }
        return this.mXBean.findMonitorDeadlockedThreads();
    }

    private void fireCheckRun() {
        for (Listener listener : this.listeners) {
            if (!(listener instanceof DetailedListener)) continue;
            ((DetailedListener)listener).checkHasBeenRun();
        }
    }

    private void fireDeadlockDetected(@Nonnull Set<? extends Thread> threads) {
        for (Listener listener : this.listeners) {
            listener.deadlockDetected(threads);
        }
    }

    @Nonnull
    private static Thread findMatchingThread(@Nonnull ThreadInfo threadInfo) {
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread.getId() != threadInfo.getThreadId()) continue;
            return thread;
        }
        throw new IllegalStateException("Deadlocked Thread not found");
    }

    public boolean addListener(@Nonnull Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(@Nonnull Listener listener) {
        return this.listeners.remove(listener);
    }

    public static interface DetailedListener
    extends Listener {
        public void checkHasBeenRun();
    }

    public static interface Listener {
        public void deadlockDetected(@Nonnull Set<? extends Thread> var1);
    }
}

