/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class InvalidLockStateException
extends RuntimeException {
    @Nonnull
    private final List<String> readLockingThreads = new ArrayList<String>();

    public InvalidLockStateException(@Nonnull List<? extends Thread> readLockingThreads) {
        super(InvalidLockStateException.createMessage(readLockingThreads));
        for (Thread thread : readLockingThreads) {
            this.readLockingThreads.add(thread.getName());
        }
    }

    @Nonnull
    public List<String> getReadLockingThreads() {
        return Collections.unmodifiableList(this.readLockingThreads);
    }

    private static String createMessage(@Nonnull List<? extends Thread> readLockingThreads) {
        StringBuilder message = new StringBuilder().append("Cannot get write lock because there are still read locks active in: ").append("\n");
        for (Thread thread : readLockingThreads) {
            message.append("\t").append(thread.getName());
        }
        return message.toString();
    }
}

