/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.json;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonDeserializationContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonDeserializer;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonElement;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonObject;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonParseException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSerializationContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSerializer;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonAnnotationAdapter$1;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JsonAnnotationAdapter
implements JsonDeserializer,
JsonSerializer {
    private final ClassLoader refLoader;

    public JsonAnnotationAdapter(ClassLoader classLoader) {
        this.refLoader = classLoader;
    }

    public JsonElement serialize(Annotation annotation, Type type, JsonSerializationContext jsonSerializationContext) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        JsonObject jsonObject = new JsonObject();
        for (Method method : clazz.getDeclaredMethods()) {
            try {
                jsonObject.add(method.getName(), jsonSerializationContext.serialize(method.invoke((Object)annotation, new Object[0])));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add(clazz.getName(), jsonObject);
        return jsonObject2;
    }

    @Override
    public Annotation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Set set = jsonObject.entrySet();
        if (set.size() != 1) {
            throw new JsonParseException("Annotation type with more than one property?");
        }
        Map.Entry entry = (Map.Entry)set.iterator().next();
        String string = (String)entry.getKey();
        try {
            Object object2;
            Class<?> clazz = Class.forName(string, false, this.refLoader);
            HashMap hashMap = Maps.newHashMap();
            for (Object object2 : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                Method method = clazz.getMethod((String)object2.getKey(), new Class[0]);
                hashMap.put(method, jsonDeserializationContext.deserialize((JsonElement)object2.getValue(), method.getGenericReturnType()));
            }
            Method method = Annotation.class.getMethod("annotationType", new Class[0]);
            object2 = new JsonAnnotationAdapter$1(this, method, clazz, hashMap);
            return (Annotation)Proxy.newProxyInstance(this.refLoader, new Class[]{clazz}, (InvocationHandler)object2);
        }
        catch (Exception exception) {
            throw new JsonParseException(exception);
        }
    }
}

