/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.Gson;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonReader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonToken;
import com.carrotsearch.ant.tasks.junit4.events.EventType;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.Serializer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;

public class Deserializer {
    private JsonReader input;
    private Gson gson;

    public Deserializer(InputStream inputStream, ClassLoader classLoader) {
        this.input = new JsonReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        this.input.setLenient(true);
        this.gson = Serializer.createGSon(classLoader);
    }

    public IEvent deserialize() {
        JsonToken jsonToken = this.input.peek();
        if (jsonToken == JsonToken.END_ARRAY) {
            return null;
        }
        this.input.beginArray();
        EventType eventType = EventType.valueOf(this.input.nextString());
        IEvent iEvent = (IEvent)this.gson.fromJson(this.input, (Type)eventType.eventClass);
        this.input.endArray();
        return iEvent;
    }
}

