/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.DefaultType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementListUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMapUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Transient;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Version;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ContactList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Hierarchy;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodContact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodPart;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodPartFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodScanner$PartMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

class MethodScanner
extends ContactList {
    private final MethodPartFactory factory;
    private final Hierarchy hierarchy;
    private final DefaultType access;
    private final MethodScanner$PartMap write;
    private final MethodScanner$PartMap read;
    private final Class type;

    public MethodScanner(Class clazz) {
        this(clazz, null);
    }

    public MethodScanner(Class clazz, DefaultType defaultType) {
        this(clazz, defaultType, true);
    }

    public MethodScanner(Class clazz, DefaultType defaultType, boolean bl) {
        this.factory = new MethodPartFactory(bl);
        this.hierarchy = new Hierarchy(clazz);
        this.write = new MethodScanner$PartMap(this, null);
        this.read = new MethodScanner$PartMap(this, null);
        this.access = defaultType;
        this.type = clazz;
        this.scan(clazz);
    }

    private void scan(Class clazz) {
        for (Class clazz2 : this.hierarchy) {
            this.scan(clazz2, this.access);
        }
        for (Class clazz2 : this.hierarchy) {
            this.scan(clazz2, clazz);
        }
        this.build();
        this.validate();
    }

    private void scan(Class clazz, Class clazz2) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            this.scan(method);
        }
    }

    private void scan(Method method) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = method.getDeclaredAnnotations()) {
            this.scan(method, annotation);
        }
    }

    private void scan(Class clazz, DefaultType defaultType) {
        Method[] methodArray = clazz.getDeclaredMethods();
        if (defaultType == DefaultType.PROPERTY) {
            for (Method method : methodArray) {
                Class clazz2 = this.factory.getType(method);
                if (clazz2 == null) continue;
                this.process(method);
            }
        }
    }

    private void scan(Method method, Annotation annotation) {
        if (annotation instanceof Attribute) {
            this.process(method, annotation);
        }
        if (annotation instanceof ElementUnion) {
            this.process(method, annotation);
        }
        if (annotation instanceof ElementListUnion) {
            this.process(method, annotation);
        }
        if (annotation instanceof ElementMapUnion) {
            this.process(method, annotation);
        }
        if (annotation instanceof ElementList) {
            this.process(method, annotation);
        }
        if (annotation instanceof ElementArray) {
            this.process(method, annotation);
        }
        if (annotation instanceof ElementMap) {
            this.process(method, annotation);
        }
        if (annotation instanceof Element) {
            this.process(method, annotation);
        }
        if (annotation instanceof Transient) {
            this.remove(method, annotation);
        }
        if (annotation instanceof Version) {
            this.process(method, annotation);
        }
        if (annotation instanceof Text) {
            this.process(method, annotation);
        }
    }

    private void process(Method method, Annotation annotation) {
        MethodPart methodPart = this.factory.getInstance(method, annotation);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.process(methodPart, this.write);
        }
    }

    private void process(Method method) {
        MethodPart methodPart = this.factory.getInstance(method);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.process(methodPart, this.write);
        }
    }

    private void process(MethodPart methodPart, MethodScanner$PartMap methodScanner$PartMap) {
        String string = methodPart.getName();
        if (string != null) {
            methodScanner$PartMap.put(string, methodPart);
        }
    }

    private void remove(Method method, Annotation annotation) {
        MethodPart methodPart = this.factory.getInstance(method, annotation);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.remove(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.remove(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.remove(methodPart, this.write);
        }
    }

    private void remove(MethodPart methodPart, MethodScanner$PartMap methodScanner$PartMap) {
        String string = methodPart.getName();
        if (string != null) {
            methodScanner$PartMap.remove(string);
        }
    }

    private void build() {
        for (String string : this.read) {
            MethodPart methodPart = (MethodPart)this.read.get(string);
            if (methodPart == null) continue;
            this.build(methodPart, string);
        }
    }

    private void build(MethodPart methodPart, String string) {
        MethodPart methodPart2 = this.write.take(string);
        if (methodPart2 != null) {
            this.build(methodPart, methodPart2);
        } else {
            this.build(methodPart);
        }
    }

    private void build(MethodPart methodPart) {
        this.add(new MethodContact(methodPart));
    }

    private void build(MethodPart methodPart, MethodPart methodPart2) {
        Annotation annotation = methodPart.getAnnotation();
        String string = methodPart.getName();
        if (!((Object)methodPart2.getAnnotation()).equals(annotation)) {
            throw new MethodException("Annotations do not match for '%s' in %s", string, this.type);
        }
        Class clazz = methodPart.getType();
        if (clazz != methodPart2.getType()) {
            throw new MethodException("Method types do not match for %s in %s", string, clazz);
        }
        this.add(new MethodContact(methodPart, methodPart2));
    }

    private void validate() {
        for (String string : this.write) {
            MethodPart methodPart = (MethodPart)this.write.get(string);
            if (methodPart == null) continue;
            this.validate(methodPart, string);
        }
    }

    private void validate(MethodPart methodPart, String string) {
        MethodPart methodPart2 = this.read.take(string);
        Method method = methodPart.getMethod();
        if (methodPart2 == null) {
            throw new MethodException("No matching get method for %s in %s", method, this.type);
        }
    }
}

