/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.$Gson$Types;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ParameterizedTypeHandlerMap {
    private static final Logger logger = Logger.getLogger(ParameterizedTypeHandlerMap.class.getName());
    private final Map systemMap = new HashMap();
    private final Map userMap = new HashMap();
    private final List systemTypeHierarchyList = new ArrayList();
    private final List userTypeHierarchyList = new ArrayList();
    private boolean modifiable = true;

    public synchronized void registerForTypeHierarchy(Class clazz, Object object, boolean bl) {
        Pair pair = new Pair(clazz, object);
        this.registerForTypeHierarchy(pair, bl);
    }

    public synchronized void registerForTypeHierarchy(Pair pair, boolean bl) {
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        List list = bl ? this.systemTypeHierarchyList : this.userTypeHierarchyList;
        int n = ParameterizedTypeHandlerMap.getIndexOfSpecificHandlerForTypeHierarchy((Class)pair.first, list);
        if (n >= 0) {
            logger.log(Level.WARNING, "Overriding the existing type handler for {0}", pair.first);
            list.remove(n);
        }
        if ((n = ParameterizedTypeHandlerMap.getIndexOfAnOverriddenHandler((Class)pair.first, list)) >= 0) {
            throw new IllegalArgumentException("The specified type handler for type " + pair.first + " hides the previously registered type hierarchy handler for " + ((Pair)list.get((int)n)).first + ". Gson does not allow this.");
        }
        list.add(0, pair);
    }

    private static int getIndexOfAnOverriddenHandler(Class clazz, List list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Pair pair = (Pair)list.get(i);
            if (!clazz.isAssignableFrom((Class)pair.first)) continue;
            return i;
        }
        return -1;
    }

    public synchronized void register(Type type, Object object, boolean bl) {
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        if (this.hasSpecificHandlerFor(type)) {
            logger.log(Level.WARNING, "Overriding the existing type handler for {0}", type);
        }
        Map map = bl ? this.systemMap : this.userMap;
        map.put(type, object);
    }

    public synchronized ParameterizedTypeHandlerMap makeUnmodifiable() {
        this.modifiable = false;
        return this;
    }

    public synchronized Object getHandlerFor(Type type, boolean bl) {
        Object object;
        if (!bl && (object = this.userMap.get(type)) != null) {
            return object;
        }
        object = this.systemMap.get(type);
        if (object != null) {
            return object;
        }
        Class clazz = $Gson$Types.getRawType(type);
        if (clazz != type && (object = this.getHandlerFor(clazz, bl)) != null) {
            return object;
        }
        object = this.getHandlerForTypeHierarchy(clazz, bl);
        return object;
    }

    private Object getHandlerForTypeHierarchy(Class clazz, boolean bl) {
        if (!bl) {
            for (Pair pair : this.userTypeHierarchyList) {
                if (!((Class)pair.first).isAssignableFrom(clazz)) continue;
                return pair.second;
            }
        }
        for (Pair pair : this.systemTypeHierarchyList) {
            if (!((Class)pair.first).isAssignableFrom(clazz)) continue;
            return pair.second;
        }
        return null;
    }

    public synchronized boolean hasSpecificHandlerFor(Type type) {
        return this.userMap.containsKey(type) || this.systemMap.containsKey(type);
    }

    private static int getIndexOfSpecificHandlerForTypeHierarchy(Class clazz, List list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!clazz.equals(((Pair)list.get((int)i)).first)) continue;
            return i;
        }
        return -1;
    }

    public synchronized ParameterizedTypeHandlerMap copyOf() {
        ParameterizedTypeHandlerMap parameterizedTypeHandlerMap = new ParameterizedTypeHandlerMap();
        parameterizedTypeHandlerMap.systemMap.putAll(this.systemMap);
        parameterizedTypeHandlerMap.userMap.putAll(this.userMap);
        parameterizedTypeHandlerMap.systemTypeHierarchyList.addAll(this.systemTypeHierarchyList);
        parameterizedTypeHandlerMap.userTypeHierarchyList.addAll(this.userTypeHierarchyList);
        return parameterizedTypeHandlerMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{userTypeHierarchyList:{");
        this.appendList(stringBuilder, this.userTypeHierarchyList);
        stringBuilder.append("},systemTypeHierarchyList:{");
        this.appendList(stringBuilder, this.systemTypeHierarchyList);
        stringBuilder.append("},userMap:{");
        this.appendMap(stringBuilder, this.userMap);
        stringBuilder.append("},systemMap:{");
        this.appendMap(stringBuilder, this.systemMap);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void appendList(StringBuilder stringBuilder, List list) {
        boolean bl = true;
        for (Pair pair : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.typeToString((Type)pair.first)).append(':');
            stringBuilder.append(pair.second);
        }
    }

    private void appendMap(StringBuilder stringBuilder, Map map) {
        boolean bl = true;
        for (Map.Entry entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.typeToString((Type)entry.getKey())).append(':');
            stringBuilder.append(entry.getValue());
        }
    }

    private String typeToString(Type type) {
        return $Gson$Types.getRawType(type).getSimpleName();
    }
}

