/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;

final class Threads {
    private static final EnumMap lockInfoStrings = new EnumMap(Thread.State.class);

    public static String threadName(Thread thread) {
        return "Thread[id=" + thread.getId() + ", name=" + thread.getName() + ", state=" + (Object)((Object)thread.getState()) + ", group=" + Threads.groupName(thread.getThreadGroup()) + "]";
    }

    private static String groupName(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return "{null group}";
        }
        return threadGroup.getName();
    }

    public static void append(StringBuilder stringBuilder, ThreadInfo threadInfo) {
        stringBuilder.append('\"').append(threadInfo.getThreadName()).append('\"');
        stringBuilder.append(" ID=").append(threadInfo.getThreadId());
        Thread.State state = threadInfo.getThreadState();
        stringBuilder.append(" ").append((Object)state);
        if (threadInfo.getLockName() != null) {
            stringBuilder.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            stringBuilder.append(" owned by \"").append(threadInfo.getLockOwnerName()).append("\" ID=").append(threadInfo.getLockOwnerId());
        }
        stringBuilder.append(threadInfo.isSuspended() ? " (suspended)" : "");
        stringBuilder.append(threadInfo.isInNative() ? " (in native code)" : "");
        stringBuilder.append("\n");
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        LockInfo lockInfo = threadInfo.getLockInfo();
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append("\tat ").append(stackTraceElementArray[i]).append("\n");
            if (i == 0 && lockInfo != null) {
                stringBuilder.append("\t- ").append((String)lockInfoStrings.get((Object)state)).append(lockInfo).append("\n");
            }
            for (LockInfo lockInfo2 : monitorInfoArray) {
                if (((MonitorInfo)lockInfo2).getLockedStackDepth() != i) continue;
                stringBuilder.append("\t- locked ").append(lockInfo2).append("\n");
            }
        }
        LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
        if (lockInfoArray.length > 0) {
            stringBuilder.append("\tLocked synchronizers:\n");
            for (LockInfo lockInfo2 : threadInfo.getLockedSynchronizers()) {
                stringBuilder.append("\t- ").append(lockInfo2).append("\n");
            }
        }
        stringBuilder.append("\n");
    }

    public static HashSet getAllThreads() {
        ThreadGroup threadGroup = Threads.getTopThreadGroup();
        return Threads.getThreads(threadGroup);
    }

    public static HashSet getThreads(ThreadGroup threadGroup) {
        int n;
        Thread[] threadArray = new Thread[2];
        while ((n = threadGroup.enumerate(threadArray, true)) == threadArray.length) {
            threadArray = new Thread[threadArray.length * 2];
        }
        return new HashSet<Thread>(Arrays.asList(threadArray).subList(0, n));
    }

    public static ThreadGroup getTopThreadGroup() {
        ThreadGroup threadGroup;
        for (threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null && threadGroup.getParent() != null; threadGroup = threadGroup.getParent()) {
        }
        if (threadGroup == null) {
            throw new RuntimeException("No root ThreadGroup for thread: " + Thread.currentThread());
        }
        return threadGroup;
    }

    static {
        lockInfoStrings.put(Thread.State.BLOCKED, "blocked on ");
        lockInfoStrings.put(Thread.State.WAITING, "waiting on ");
        lockInfoStrings.put(Thread.State.TIMED_WAITING, "timed waiting on ");
        lockInfoStrings.put(Thread.State.TERMINATED, "terminated? on ");
        lockInfoStrings.put(Thread.State.RUNNABLE, "runnable? on ");
        lockInfoStrings.put(Thread.State.NEW, "new? on ");
    }
}

