SELECT /*+ PARALLEL(AUTO) */
  NULL AS TABLE_CATALOG,
  OWNER AS TABLE_SCHEMA,
  VIEW_NAME AS TABLE_NAME,
  TEXT AS VIEW_DEFINITION,
  'UNKNOWN' AS CHECK_OPTION,
  CASE WHEN READ_ONLY = 'N' THEN 'Y' ELSE 'N' END AS IS_UPDATABLE
FROM
  ALL_VIEWS
WHERE
  OWNER NOT IN ('CTXSYS', 'DBSNMP', 'DMSYS', 'MDDATA', 'MDSYS', 'OLAPSYS', 'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'SI_INFORMTN_SCHEMA', 'SYS', 'SYSMAN', 'SYSTEM', 'XDB')
  AND OWNER NOT LIKE 'APEX%'
ORDER BY
  TABLE_SCHEMA,
  TABLE_NAME
