SELECT /*+ PARALLEL(AUTO) */
  NULL AS TRIGGER_CATALOG,
  OWNER AS TRIGGER_SCHEMA,
  TRIGGER_NAME AS TRIGGER_NAME,
  CASE
    WHEN TRIGGERING_EVENT LIKE '%INSERT%' THEN 'INSERT'
    WHEN TRIGGERING_EVENT LIKE '%UPDATE%'  THEN 'UPDATE'
    WHEN TRIGGERING_EVENT LIKE '%DELETE%'  THEN 'DELETE'
    ELSE 'UNKNOWN'
  END
  AS EVENT_MANIPULATION,
  NULL AS EVENT_OBJECT_CATALOG,
  TABLE_OWNER AS EVENT_OBJECT_SCHEMA,
  TABLE_NAME AS EVENT_OBJECT_TABLE,
  0
    AS ACTION_ORDER,
  WHEN_CLAUSE AS ACTION_CONDITION,
  CASE
    WHEN TRIGGER_TYPE LIKE '%ROW' THEN 'ROW'
    WHEN TRIGGER_TYPE LIKE '%STATEMENT' THEN 'STATEMENT'
    ELSE 'UNKNOWN'
  END
    AS ACTION_ORIENTATION,
  CASE
    WHEN TRIGGER_TYPE LIKE 'AFTER%' THEN 'AFTER'
    WHEN TRIGGER_TYPE LIKE 'BEFORE%' THEN 'BEFORE'
    ELSE 'INSTEAD OF'
  END
    AS CONDITION_TIMING,
  TRIGGER_BODY AS ACTION_STATEMENT
FROM
  ALL_TRIGGERS
WHERE
  OWNER NOT IN ('CTXSYS', 'DBSNMP', 'DMSYS', 'MDDATA', 'MDSYS', 'OLAPSYS', 'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'SI_INFORMTN_SCHEMA', 'SYS', 'SYSMAN', 'SYSTEM', 'XDB')
  AND OWNER NOT LIKE 'APEX%'
