SELECT /*+ PARALLEL(AUTO) */
  NULL AS CONSTRAINT_CATALOG,
  TABLE_CONTRAINTS.OWNER AS CONSTRAINT_SCHEMA,
  TABLE_CONTRAINTS.CONSTRAINT_NAME,
  NULL AS TABLE_CATALOG,
  TABLE_CONTRAINTS.OWNER AS TABLE_SCHEMA,
  TABLE_CONTRAINTS.TABLE_NAME,
  COLUMNS.COLUMN_NAME,
  COLUMNS.POSITION AS ORDINAL_POSITION
FROM
  ALL_CONSTRAINTS TABLE_CONTRAINTS
  INNER JOIN ALL_CONS_COLUMNS COLUMNS
    ON TABLE_CONTRAINTS.OWNER = COLUMNS.OWNER AND TABLE_CONTRAINTS.TABLE_NAME = COLUMNS.TABLE_NAME AND TABLE_CONTRAINTS.CONSTRAINT_NAME = COLUMNS.CONSTRAINT_NAME
WHERE
  TABLE_CONTRAINTS.OWNER NOT IN ('CTXSYS', 'DBSNMP', 'DMSYS', 'MDDATA', 'MDSYS', 'OLAPSYS', 'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'SI_INFORMTN_SCHEMA', 'SYS', 'SYSMAN', 'SYSTEM', 'XDB', 'DBSNMP')
  AND TABLE_CONTRAINTS.OWNER NOT LIKE 'APEX%'
  AND TABLE_CONTRAINTS.TABLE_NAME NOT LIKE 'BIN$%'
  AND TABLE_CONTRAINTS.CONSTRAINT_TYPE IN ('C', 'U', 'P', 'R')
