/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseCommandChainExecutable;
import schemacrawler.tools.executable.Commands;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.text.base.BaseTextOptionsBuilder;

public final class CommandDaisyChainExecutable
extends BaseCommandChainExecutable {
    public CommandDaisyChainExecutable(String commands) throws SchemaCrawlerException {
        super(commands);
    }

    @Override
    public void executeOn(Catalog catalog, Connection connection) throws Exception {
        Commands commands = new Commands(this.getCommand());
        if (commands.isEmpty()) {
            throw new SchemaCrawlerException("No command specified");
        }
        for (String command : commands) {
            Executable executable = this.addNext(command);
            BaseTextOptionsBuilder baseTextOptions = new BaseTextOptionsBuilder(this.additionalConfiguration);
            if (commands.hasMultipleCommands()) {
                if (commands.isFirstCommand(command)) {
                    baseTextOptions.hideFooter();
                } else if (commands.isLastCommand(command)) {
                    baseTextOptions.hideHeader();
                    baseTextOptions.hideInfo();
                    baseTextOptions.appendOutput();
                } else {
                    baseTextOptions.hideHeader();
                    baseTextOptions.hideInfo();
                    baseTextOptions.hideFooter();
                    baseTextOptions.appendOutput();
                }
            }
            Config executableAdditionalConfig = new Config();
            if (this.additionalConfiguration != null) {
                executableAdditionalConfig.putAll(this.additionalConfiguration);
            }
            executableAdditionalConfig.putAll(baseTextOptions.toConfig());
            executable.setAdditionalConfiguration(executableAdditionalConfig);
        }
        this.executeChain(catalog, connection);
    }
}

