/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.io.Serializable;
import sf.util.Utility;

public final class TableType
implements Serializable,
Comparable<TableType> {
    private static final long serialVersionUID = -8172248482959041873L;
    public static final TableType UNKNOWN = new TableType();
    private final String tableType;

    public TableType(String tableType) {
        this.tableType = Utility.isBlank(tableType) ? "UNKNOWN" : tableType.trim();
    }

    private TableType() {
        this(null);
    }

    @Override
    public int compareTo(TableType other) {
        if (other == null) {
            return 1;
        }
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableType)) {
            return false;
        }
        TableType other = (TableType)obj;
        return !(this.tableType == null ? other.tableType != null : !this.tableType.equalsIgnoreCase(other.tableType));
    }

    public String getTableType() {
        return this.tableType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableType == null ? 0 : this.tableType.hashCode());
        return result;
    }

    public boolean isEqualTo(String testTableType) {
        if (Utility.isBlank(testTableType)) {
            return false;
        }
        return this.tableType.equalsIgnoreCase(testTableType.trim());
    }

    public boolean isView() {
        return this.tableType.toUpperCase().contains("VIEW");
    }

    public String toString() {
        return this.tableType.toLowerCase();
    }
}

