/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class MetadataTemplate
extends BoxJSONObject {
    public static final URLTemplate METADATA_TEMPLATE_URL_TEMPLATE = new URLTemplate("metadata_templates/%s/%s/schema");
    public static final URLTemplate METADATA_TEMPLATE_BY_ID_URL_TEMPLATE = new URLTemplate("metadata_templates/%s");
    public static final URLTemplate METADATA_TEMPLATE_SCHEMA_URL_TEMPLATE = new URLTemplate("metadata_templates/schema");
    public static final URLTemplate ENTERPRISE_METADATA_URL_TEMPLATE = new URLTemplate("metadata_templates/%s");
    private static final String DEFAULT_METADATA_TYPE = "properties";
    private static final String GLOBAL_METADATA_SCOPE = "global";
    private static final String ENTERPRISE_METADATA_SCOPE = "enterprise";
    private static final int DEFAULT_ENTRIES_LIMIT = 100;
    private String id;
    private String templateKey;
    private String scope;
    private String displayName;
    private Boolean isHidden;
    private List<Field> fields;

    public MetadataTemplate() {
    }

    public MetadataTemplate(String json) {
        super(json);
    }

    MetadataTemplate(JsonObject jsonObject) {
        super(jsonObject);
    }

    public String getID() {
        return this.id;
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public String getScope() {
        return this.scope;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        String memberName = member.getName();
        if (memberName.equals("templateKey")) {
            this.templateKey = value.asString();
        } else if (memberName.equals("scope")) {
            this.scope = value.asString();
        } else if (memberName.equals("displayName")) {
            this.displayName = value.asString();
        } else if (memberName.equals("hidden")) {
            this.isHidden = value.asBoolean();
        } else if (memberName.equals("fields")) {
            this.fields = new ArrayList<Field>();
            for (JsonValue field : value.asArray()) {
                this.fields.add(new Field(field.asObject()));
            }
        } else if (memberName.equals("id")) {
            this.id = value.asString();
        }
    }

    public static MetadataTemplate createMetadataTemplate(BoxAPIConnection api, String scope, String templateKey, String displayName, boolean hidden, List<Field> fields) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("scope", scope);
        jsonObject.add("displayName", displayName);
        jsonObject.add("hidden", hidden);
        if (templateKey != null) {
            jsonObject.add("templateKey", templateKey);
        }
        JsonArray fieldsArray = new JsonArray();
        if (fields != null && !fields.isEmpty()) {
            for (Field field : fields) {
                JsonObject fieldObj = MetadataTemplate.getFieldJsonObject(field);
                fieldsArray.add((JsonValue)fieldObj);
            }
            jsonObject.add("fields", (JsonValue)fieldsArray);
        }
        URL url = METADATA_TEMPLATE_SCHEMA_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(jsonObject.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new MetadataTemplate(responseJSON);
    }

    private static JsonObject getFieldJsonObject(Field field) {
        Boolean fieldIsHidden;
        JsonObject fieldObj = new JsonObject();
        fieldObj.add("type", field.getType());
        fieldObj.add("key", field.getKey());
        fieldObj.add("displayName", field.getDisplayName());
        String fieldDesc = field.getDescription();
        if (fieldDesc != null) {
            fieldObj.add("description", field.getDescription());
        }
        if ((fieldIsHidden = field.getIsHidden()) != null) {
            fieldObj.add("hidden", field.getIsHidden().booleanValue());
        }
        JsonArray array = new JsonArray();
        List<String> options = field.getOptions();
        if (options != null && !options.isEmpty()) {
            for (String option : options) {
                JsonObject optionObj = new JsonObject();
                optionObj.add("key", option);
                array.add((JsonValue)optionObj);
            }
            fieldObj.add("options", (JsonValue)array);
        }
        return fieldObj;
    }

    public static MetadataTemplate updateMetadataTemplate(BoxAPIConnection api, String scope, String template, List<FieldOperation> fieldOperations) {
        JsonArray array = new JsonArray();
        for (FieldOperation fieldOperation : fieldOperations) {
            JsonObject jsonObject = MetadataTemplate.getFieldOperationJsonObject(fieldOperation);
            array.add((JsonValue)jsonObject);
        }
        QueryStringBuilder builder = new QueryStringBuilder();
        URL url = METADATA_TEMPLATE_URL_TEMPLATE.build(api.getBaseURL(), scope, template);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "PUT");
        request.setBody(array.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJson = JsonObject.readFrom((String)response.getJSON());
        return new MetadataTemplate(responseJson);
    }

    public static void deleteMetadataTemplate(BoxAPIConnection api, String scope, String template) {
        URL url = METADATA_TEMPLATE_URL_TEMPLATE.build(api.getBaseURL(), scope, template);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "DELETE");
        request.send();
    }

    private static JsonObject getFieldOperationJsonObject(FieldOperation fieldOperation) {
        List<String> multiSelectOptionKeys;
        String multiSelectOptionKey;
        String enumOptionKey;
        List<String> enumOptionKeys;
        List<String> fieldKeys;
        Field field;
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("op", fieldOperation.getOp().toString());
        String fieldKey = fieldOperation.getFieldKey();
        if (fieldKey != null) {
            jsonObject.add("fieldKey", fieldKey);
        }
        if ((field = fieldOperation.getData()) != null) {
            List<String> options;
            Boolean hidden;
            String description;
            String displayName;
            String key;
            JsonObject fieldObj = new JsonObject();
            String type = field.getType();
            if (type != null) {
                fieldObj.add("type", type);
            }
            if ((key = field.getKey()) != null) {
                fieldObj.add("key", key);
            }
            if ((displayName = field.getDisplayName()) != null) {
                fieldObj.add("displayName", displayName);
            }
            if ((description = field.getDescription()) != null) {
                fieldObj.add("description", description);
            }
            if ((hidden = field.getIsHidden()) != null) {
                fieldObj.add("hidden", hidden.booleanValue());
            }
            if ((options = field.getOptions()) != null) {
                JsonArray array = new JsonArray();
                for (String option : options) {
                    JsonObject optionObj = new JsonObject();
                    optionObj.add("key", option);
                    array.add((JsonValue)optionObj);
                }
                fieldObj.add("options", (JsonValue)array);
            }
            jsonObject.add("data", (JsonValue)fieldObj);
        }
        if ((fieldKeys = fieldOperation.getFieldKeys()) != null) {
            jsonObject.add("fieldKeys", (JsonValue)MetadataTemplate.getJsonArray(fieldKeys));
        }
        if ((enumOptionKeys = fieldOperation.getEnumOptionKeys()) != null) {
            jsonObject.add("enumOptionKeys", (JsonValue)MetadataTemplate.getJsonArray(enumOptionKeys));
        }
        if ((enumOptionKey = fieldOperation.getEnumOptionKey()) != null) {
            jsonObject.add("enumOptionKey", enumOptionKey);
        }
        if ((multiSelectOptionKey = fieldOperation.getMultiSelectOptionKey()) != null) {
            jsonObject.add("multiSelectOptionKey", multiSelectOptionKey);
        }
        if ((multiSelectOptionKeys = fieldOperation.getMultiSelectOptionKeys()) != null) {
            jsonObject.add("multiSelectOptionKeys", (JsonValue)MetadataTemplate.getJsonArray(multiSelectOptionKeys));
        }
        return jsonObject;
    }

    private static JsonArray getJsonArray(List<String> keys) {
        JsonArray array = new JsonArray();
        for (String key : keys) {
            array.add(key);
        }
        return array;
    }

    public static MetadataTemplate getMetadataTemplate(BoxAPIConnection api) {
        return MetadataTemplate.getMetadataTemplate(api, DEFAULT_METADATA_TYPE);
    }

    public static MetadataTemplate getMetadataTemplate(BoxAPIConnection api, String templateName) {
        String scope = MetadataTemplate.scopeBasedOnType(templateName);
        return MetadataTemplate.getMetadataTemplate(api, templateName, scope, new String[0]);
    }

    public static MetadataTemplate getMetadataTemplate(BoxAPIConnection api, String templateName, String scope, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = METADATA_TEMPLATE_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), scope, templateName);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new MetadataTemplate(response.getJSON());
    }

    public static MetadataTemplate getMetadataTemplateByID(BoxAPIConnection api, String templateID) {
        URL url = METADATA_TEMPLATE_BY_ID_URL_TEMPLATE.build(api.getBaseURL(), templateID);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new MetadataTemplate(response.getJSON());
    }

    public static Iterable<MetadataTemplate> getEnterpriseMetadataTemplates(BoxAPIConnection api, String ... fields) {
        return MetadataTemplate.getEnterpriseMetadataTemplates(ENTERPRISE_METADATA_SCOPE, api, fields);
    }

    public static Iterable<MetadataTemplate> getEnterpriseMetadataTemplates(String scope, BoxAPIConnection api, String ... fields) {
        return MetadataTemplate.getEnterpriseMetadataTemplates(ENTERPRISE_METADATA_SCOPE, 100, api, fields);
    }

    public static Iterable<MetadataTemplate> getEnterpriseMetadataTemplates(String scope, int limit, BoxAPIConnection api, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<MetadataTemplate>(api, ENTERPRISE_METADATA_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), scope), limit){

            @Override
            protected MetadataTemplate factory(JsonObject jsonObject) {
                return new MetadataTemplate(jsonObject);
            }
        };
    }

    private static String scopeBasedOnType(String typeName) {
        return typeName.equals(DEFAULT_METADATA_TYPE) ? GLOBAL_METADATA_SCOPE : ENTERPRISE_METADATA_SCOPE;
    }

    public static enum Operation {
        addEnumOption,
        editEnumOption,
        removeEnumOption,
        addField,
        editField,
        removeField,
        editTemplate,
        reorderEnumOptions,
        reorderFields,
        addMultiSelectOption,
        editMultiSelectOption,
        removeMultiSelectOption,
        reorderMultiSelectOptions;

    }

    public static class FieldOperation
    extends BoxJSONObject {
        private Operation op;
        private Field data;
        private String fieldKey;
        private List<String> fieldKeys;
        private List<String> enumOptionKeys;
        private String enumOptionKey;
        private String multiSelectOptionKey;
        private List<String> multiSelectOptionKeys;

        public FieldOperation() {
        }

        public FieldOperation(String json) {
            super(json);
        }

        FieldOperation(JsonObject jsonObject) {
            super(jsonObject);
        }

        public Operation getOp() {
            return this.op;
        }

        public Field getData() {
            return this.data;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public List<String> getFieldKeys() {
            return this.fieldKeys;
        }

        public List<String> getEnumOptionKeys() {
            return this.enumOptionKeys;
        }

        public void setOp(Operation op) {
            this.op = op;
        }

        public void setData(Field data) {
            this.data = data;
        }

        public void setFieldKey(String fieldKey) {
            this.fieldKey = fieldKey;
        }

        public void setFieldKeys(List<String> fieldKeys) {
            this.fieldKeys = fieldKeys;
        }

        public void setEnumOptionKeys(List<String> enumOptionKeys) {
            this.enumOptionKeys = enumOptionKeys;
        }

        public String getEnumOptionKey() {
            return this.enumOptionKey;
        }

        public void setEnumOptionKey(String enumOptionKey) {
            this.enumOptionKey = enumOptionKey;
        }

        public String getMultiSelectOptionKey() {
            return this.multiSelectOptionKey;
        }

        public void setMultiSelectOptionKey(String key) {
            this.multiSelectOptionKey = key;
        }

        public List<String> getMultiSelectOptionKeys() {
            return this.multiSelectOptionKeys;
        }

        public void setMultiSelectOptionKeys(List<String> keys) {
            this.multiSelectOptionKeys = keys;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            block8: {
                String memberName;
                JsonValue value;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            value = member.getValue();
                                            memberName = member.getName();
                                            if (!memberName.equals("op")) break block7;
                                            this.op = Operation.valueOf(value.asString());
                                            break block8;
                                        }
                                        if (!memberName.equals("data")) break block9;
                                        this.data = new Field(value.asObject());
                                        break block8;
                                    }
                                    if (!memberName.equals("fieldKey")) break block10;
                                    this.fieldKey = value.asString();
                                    break block8;
                                }
                                if (!memberName.equals("fieldKeys")) break block11;
                                if (this.fieldKeys == null) {
                                    this.fieldKeys = new ArrayList<String>();
                                } else {
                                    this.fieldKeys.clear();
                                }
                                JsonArray array = value.asArray();
                                for (JsonValue jsonValue : array) {
                                    this.fieldKeys.add(jsonValue.asString());
                                }
                                break block8;
                            }
                            if (!memberName.equals("enumOptionKeys")) break block12;
                            if (this.enumOptionKeys == null) {
                                this.enumOptionKeys = new ArrayList<String>();
                            } else {
                                this.enumOptionKeys.clear();
                            }
                            JsonArray array = value.asArray();
                            for (JsonValue jsonValue : array) {
                                this.enumOptionKeys.add(jsonValue.asString());
                            }
                            break block8;
                        }
                        if (!memberName.equals("enumOptionKey")) break block13;
                        this.enumOptionKey = value.asString();
                        break block8;
                    }
                    if (!memberName.equals("multiSelectOptionKey")) break block14;
                    this.multiSelectOptionKey = value.asString();
                    break block8;
                }
                if (!memberName.equals("multiSelectOptionKeys")) break block8;
                this.multiSelectOptionKeys = new ArrayList<String>();
                for (JsonValue key : value.asArray()) {
                    this.multiSelectOptionKeys.add(key.asString());
                }
            }
        }
    }

    public static class Option
    extends BoxJSONObject {
        private String id;
        private String key;

        public Option() {
        }

        public Option(String json) {
            super(json);
        }

        Option(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getID() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if (memberName.equals("id")) {
                this.id = value.asString();
            } else if (memberName.equals("key")) {
                this.key = value.asString();
            }
        }
    }

    public static class Field
    extends BoxJSONObject {
        private String id;
        private String type;
        private String key;
        private String displayName;
        private Boolean isHidden;
        private String description;
        private List<Option> options;

        public Field() {
        }

        public Field(String json) {
            super(json);
        }

        Field(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getID() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public Boolean getIsHidden() {
            return this.isHidden;
        }

        public void setIsHidden(boolean isHidden) {
            this.isHidden = isHidden;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getOptions() {
            if (this.options == null) {
                return null;
            }
            ArrayList<String> optionsList = new ArrayList<String>();
            for (Option option : this.options) {
                optionsList.add(option.getKey());
            }
            return optionsList;
        }

        public List<Option> getOptionsObjects() {
            return this.options;
        }

        public void setOptions(List<String> options) {
            if (options == null) {
                this.options = null;
            }
            ArrayList<Option> optionList = new ArrayList<Option>();
            for (String key : options) {
                JsonObject optionObject = new JsonObject();
                optionObject.add("key", key);
                Option newOption = new Option(optionObject);
                optionList.add(newOption);
            }
            this.options = optionList;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if (memberName.equals("type")) {
                this.type = value.asString();
            } else if (memberName.equals("key")) {
                this.key = value.asString();
            } else if (memberName.equals("displayName")) {
                this.displayName = value.asString();
            } else if (memberName.equals("hidden")) {
                this.isHidden = value.asBoolean();
            } else if (memberName.equals("description")) {
                this.description = value.asString();
            } else if (memberName.equals("options")) {
                this.options = new ArrayList<Option>();
                for (JsonValue option : value.asArray()) {
                    this.options.add(new Option(option.asObject()));
                }
            } else if (memberName.equals("id")) {
                this.id = value.asString();
            }
        }
    }
}

