/*
 * Decompiled with CFR 0.152.
 */
package com.bol.secure;

import com.bol.crypt.CryptVault;
import com.bol.crypt.DocumentCryptException;
import com.bol.crypt.FieldCryptException;
import com.bol.secure.AbstractEncryptionEventListener;
import com.bol.secure.Encrypted;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.util.ReflectionUtils;

public class ReflectionEncryptionEventListener
extends AbstractEncryptionEventListener<ReflectionEncryptionEventListener> {
    public ReflectionEncryptionEventListener(CryptVault cryptVault) {
        super(cryptVault);
    }

    static void cryptFields(Document document, Class node, Function<Object, Object> crypt) {
        for (Map.Entry field : document.entrySet()) {
            Field classField;
            String fieldName = (String)field.getKey();
            if (fieldName.equals("_class") || (classField = ReflectionUtils.findField((Class)node, (String)fieldName)) == null) continue;
            Object fieldValue = field.getValue();
            if (classField.isAnnotationPresent(Encrypted.class)) {
                try {
                    document.put(fieldName, crypt.apply(fieldValue));
                    continue;
                }
                catch (Exception e) {
                    throw new FieldCryptException(fieldName, e);
                }
            }
            try {
                Type subFieldType;
                ParameterizedType parameterizedType;
                if (Collection.class.isAssignableFrom(classField.getType())) {
                    parameterizedType = (ParameterizedType)classField.getGenericType();
                    subFieldType = parameterizedType.getActualTypeArguments()[0];
                    ArrayList list = (ArrayList)fieldValue;
                    for (int i = 0; i < list.size(); ++i) {
                        try {
                            ReflectionEncryptionEventListener.diveIntoGeneric(crypt, list.get(i), subFieldType);
                            continue;
                        }
                        catch (FieldCryptException e) {
                            throw e.chain(Integer.toString(i));
                        }
                    }
                    continue;
                }
                if (Map.class.isAssignableFrom(classField.getType())) {
                    parameterizedType = (ParameterizedType)classField.getGenericType();
                    subFieldType = parameterizedType.getActualTypeArguments()[1];
                    Document map = (Document)fieldValue;
                    for (Map.Entry entry : map.entrySet()) {
                        try {
                            ReflectionEncryptionEventListener.diveIntoGeneric(crypt, entry.getValue(), subFieldType);
                        }
                        catch (FieldCryptException e) {
                            throw e.chain((String)entry.getKey());
                        }
                    }
                    continue;
                }
                if (!(fieldValue instanceof Document)) continue;
                Document subObject = (Document)fieldValue;
                ReflectionEncryptionEventListener.diveIntoGeneric(crypt, subObject, classField.getType());
            }
            catch (FieldCryptException e) {
                throw e.chain(fieldName);
            }
        }
    }

    static void diveIntoGeneric(Function<Object, Object> crypt, Object value, Type fieldType) {
        if (value instanceof Document) {
            ReflectionEncryptionEventListener.diveInto(crypt, (Document)value, fieldType);
        } else if (value instanceof List) {
            ReflectionEncryptionEventListener.diveInto(crypt, (List)value, fieldType);
        } else {
            if (value.getClass().getPackage().getName().equals("java.lang")) {
                return;
            }
            throw new IllegalArgumentException("Unknown reflective value class: " + value.getClass());
        }
    }

    static void diveInto(Function<Object, Object> crypt, Document value, Type fieldType) {
        Class childNode = ReflectionEncryptionEventListener.fetchClassFromField(value);
        if (childNode != null) {
            ReflectionEncryptionEventListener.cryptFields(value, childNode, crypt);
            return;
        }
        if (!(fieldType instanceof Class)) {
            throw new IllegalArgumentException("Unknown reflective type class " + fieldType.getClass());
        }
        childNode = (Class)fieldType;
        ReflectionEncryptionEventListener.cryptFields(value, childNode, crypt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void diveInto(Function<Object, Object> crypt, List value, Type fieldType) {
        if (!(fieldType instanceof ParameterizedType)) throw new IllegalArgumentException("Unknown reflective type class " + fieldType.getClass());
        ParameterizedType subType = (ParameterizedType)fieldType;
        Class rawType = (Class)subType.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) throw new IllegalArgumentException("Unknown reflective raw type class " + rawType.getClass() + "; should be Map<> or Collection<>");
        Type subFieldType = subType.getActualTypeArguments()[0];
        for (Object o : value) {
            ReflectionEncryptionEventListener.diveIntoGeneric(crypt, o, subFieldType);
        }
    }

    private static Class<?> fetchClassFromField(Document value) {
        String className = (String)value.get((Object)"_class");
        if (className != null) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public void onAfterLoad(AfterLoadEvent event) {
        Document document = event.getDocument();
        try {
            ReflectionEncryptionEventListener.cryptFields(document, event.getType(), new AbstractEncryptionEventListener.Decoder());
        }
        catch (Exception e) {
            ObjectId id = document.getObjectId((Object)"_id");
            throw new DocumentCryptException(event.getCollectionName(), id, e);
        }
    }

    public void onBeforeSave(BeforeSaveEvent event) {
        Document document = event.getDocument();
        try {
            ReflectionEncryptionEventListener.cryptFields(document, event.getSource().getClass(), new AbstractEncryptionEventListener.Encoder());
        }
        catch (Exception e) {
            ObjectId id = document.getObjectId((Object)"_id");
            throw new DocumentCryptException(event.getCollectionName(), id, e);
        }
    }
}

