/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.jositransport;

import com.beanit.jositransport.TConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public final class ClientTSap {
    public byte[] tSelRemote = null;
    public byte[] tSelLocal = null;
    private int maxTPDUSizeParam = 16;
    private SocketFactory socketFactory = null;
    private int messageTimeout = 0;
    private int messageFragmentTimeout = 60000;

    public ClientTSap() {
        this.socketFactory = SocketFactory.getDefault();
    }

    public ClientTSap(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public static int getMaxTPDUSize(int maxTPDUSizeParam) {
        if (maxTPDUSizeParam < 7 || maxTPDUSizeParam > 16) {
            throw new IllegalArgumentException("maxTPDUSizeParam is out of bound");
        }
        if (maxTPDUSizeParam == 16) {
            return 65531;
        }
        return (int)Math.pow(2.0, maxTPDUSizeParam);
    }

    public void setMessageTimeout(int messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public void setMessageFragmentTimeout(int messageFragmentTimeout) {
        this.messageFragmentTimeout = messageFragmentTimeout;
    }

    public int getMaxTPDUSizeParam() {
        return this.maxTPDUSizeParam;
    }

    public void setMaxTPDUSizeParam(int maxTPDUSizeParam) {
        if (maxTPDUSizeParam < 7 || maxTPDUSizeParam > 16) {
            throw new IllegalArgumentException("maxTPDUSizeParam is out of bound");
        }
        this.maxTPDUSizeParam = maxTPDUSizeParam;
    }

    public TConnection connectTo(InetAddress address, int port) throws IOException {
        return this.connectTo(address, port, null, -1);
    }

    public TConnection connectTo(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        Socket socket;
        if (localAddr == null) {
            socket = this.socketFactory.createSocket();
            socket.connect(new InetSocketAddress(address, port), this.messageTimeout);
        } else {
            socket = this.socketFactory.createSocket(address, port, localAddr, localPort);
        }
        TConnection tConnection = new TConnection(socket, this.maxTPDUSizeParam, this.messageTimeout, this.messageFragmentTimeout, null);
        tConnection.tSelRemote = this.tSelRemote;
        tConnection.tSelLocal = this.tSelLocal;
        tConnection.startConnection();
        return tConnection;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }
}

