/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.presentation.asn1;

import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.josistack.internal.presentation.asn1.FullyEncodedData;
import com.beanit.josistack.internal.presentation.asn1.SimplyEncodedData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class UserData
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private SimplyEncodedData simplyEncodedData = null;
    private FullyEncodedData fullyEncodedData = null;

    public UserData() {
    }

    public UserData(byte[] code) {
        this.code = code;
    }

    public SimplyEncodedData getSimplyEncodedData() {
        return this.simplyEncodedData;
    }

    public void setSimplyEncodedData(SimplyEncodedData simplyEncodedData) {
        this.simplyEncodedData = simplyEncodedData;
    }

    public FullyEncodedData getFullyEncodedData() {
        return this.fullyEncodedData;
    }

    public void setFullyEncodedData(FullyEncodedData fullyEncodedData) {
        this.fullyEncodedData = fullyEncodedData;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.fullyEncodedData != null) {
            codeLength += this.fullyEncodedData.encode(reverseOS, false);
            reverseOS.write(97);
            return ++codeLength;
        }
        if (this.simplyEncodedData != null) {
            codeLength += this.simplyEncodedData.encode(reverseOS, false);
            reverseOS.write(64);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(64, 0, 0)) {
            this.simplyEncodedData = new SimplyEncodedData();
            return tlvByteCount += this.simplyEncodedData.decode(is, false);
        }
        if (berTag.equals(64, 32, 1)) {
            this.fullyEncodedData = new FullyEncodedData();
            return tlvByteCount += this.fullyEncodedData.decode(is, false);
        }
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.simplyEncodedData != null) {
            sb.append("simplyEncodedData: ").append((Object)this.simplyEncodedData);
            return;
        }
        if (this.fullyEncodedData != null) {
            sb.append("fullyEncodedData: ");
            this.fullyEncodedData.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }
}

