/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.presentation.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.josistack.internal.presentation.asn1.AbstractSyntaxName;
import com.beanit.josistack.internal.presentation.asn1.PresentationContextIdentifier;
import com.beanit.josistack.internal.presentation.asn1.TransferSyntaxName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ContextList
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private List<SEQUENCE> seqOf = null;

    public ContextList() {
        this.seqOf = new ArrayList<SEQUENCE>();
    }

    public ContextList(byte[] code) {
        this.code = code;
    }

    public List<SEQUENCE> getSEQUENCE() {
        if (this.seqOf == null) {
            this.seqOf = new ArrayList<SEQUENCE>();
        }
        return this.seqOf;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        for (int i = this.seqOf.size() - 1; i >= 0; --i) {
            codeLength += this.seqOf.get(i).encode(reverseOS, true);
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        while (vByteCount < lengthVal || lengthVal < 0) {
            vByteCount += berTag.decode(is);
            if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                vByteCount += BerLength.readEocByte((InputStream)is);
                break;
            }
            if (!berTag.equals((Object)SEQUENCE.tag)) {
                throw new IOException("Tag does not match mandatory sequence of/set of component.");
            }
            SEQUENCE element = new SEQUENCE();
            vByteCount += element.decode(is, false);
            this.seqOf.add(element);
        }
        if (lengthVal >= 0 && vByteCount != lengthVal) {
            throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + lengthVal + " but has " + vByteCount);
        }
        return tlByteCount + vByteCount;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.seqOf == null) {
            sb.append("null");
        } else {
            Iterator<SEQUENCE> it = this.seqOf.iterator();
            if (it.hasNext()) {
                it.next().appendAsString(sb, indentLevel + 1);
                while (it.hasNext()) {
                    sb.append(",\n");
                    for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                        sb.append("\t");
                    }
                    it.next().appendAsString(sb, indentLevel + 1);
                }
            }
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class SEQUENCE
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private PresentationContextIdentifier presentationContextIdentifier = null;
        private AbstractSyntaxName abstractSyntaxName = null;
        private TransferSyntaxNameList transferSyntaxNameList = null;

        public SEQUENCE() {
        }

        public SEQUENCE(byte[] code) {
            this.code = code;
        }

        public PresentationContextIdentifier getPresentationContextIdentifier() {
            return this.presentationContextIdentifier;
        }

        public void setPresentationContextIdentifier(PresentationContextIdentifier presentationContextIdentifier) {
            this.presentationContextIdentifier = presentationContextIdentifier;
        }

        public AbstractSyntaxName getAbstractSyntaxName() {
            return this.abstractSyntaxName;
        }

        public void setAbstractSyntaxName(AbstractSyntaxName abstractSyntaxName) {
            this.abstractSyntaxName = abstractSyntaxName;
        }

        public TransferSyntaxNameList getTransferSyntaxNameList() {
            return this.transferSyntaxNameList;
        }

        public void setTransferSyntaxNameList(TransferSyntaxNameList transferSyntaxNameList) {
            this.transferSyntaxNameList = transferSyntaxNameList;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.transferSyntaxNameList.encode(reverseOS, true);
            codeLength += this.abstractSyntaxName.encode(reverseOS, true);
            codeLength += this.presentationContextIdentifier.encode(reverseOS, true);
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);
            if (berTag.equals((Object)PresentationContextIdentifier.tag)) {
                this.presentationContextIdentifier = new PresentationContextIdentifier();
                vByteCount += this.presentationContextIdentifier.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals((Object)AbstractSyntaxName.tag)) {
                this.abstractSyntaxName = new AbstractSyntaxName();
                vByteCount += this.abstractSyntaxName.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals((Object)TransferSyntaxNameList.tag)) {
                this.transferSyntaxNameList = new TransferSyntaxNameList();
                if (lengthVal >= 0 && (vByteCount += this.transferSyntaxNameList.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.presentationContextIdentifier != null) {
                sb.append("presentationContextIdentifier: ").append((Object)this.presentationContextIdentifier);
            } else {
                sb.append("presentationContextIdentifier: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.abstractSyntaxName != null) {
                sb.append("abstractSyntaxName: ").append((Object)this.abstractSyntaxName);
            } else {
                sb.append("abstractSyntaxName: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.transferSyntaxNameList != null) {
                sb.append("transferSyntaxNameList: ");
                this.transferSyntaxNameList.appendAsString(sb, indentLevel + 1);
            } else {
                sb.append("transferSyntaxNameList: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }

        public static class TransferSyntaxNameList
        implements BerType,
        Serializable {
            public static final BerTag tag = new BerTag(0, 32, 16);
            private static final long serialVersionUID = 1L;
            private byte[] code = null;
            private List<TransferSyntaxName> seqOf = null;

            public TransferSyntaxNameList() {
                this.seqOf = new ArrayList<TransferSyntaxName>();
            }

            public TransferSyntaxNameList(byte[] code) {
                this.code = code;
            }

            public List<TransferSyntaxName> getTransferSyntaxName() {
                if (this.seqOf == null) {
                    this.seqOf = new ArrayList<TransferSyntaxName>();
                }
                return this.seqOf;
            }

            public int encode(OutputStream reverseOS) throws IOException {
                return this.encode(reverseOS, true);
            }

            public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                if (this.code != null) {
                    reverseOS.write(this.code);
                    if (withTag) {
                        return tag.encode(reverseOS) + this.code.length;
                    }
                    return this.code.length;
                }
                int codeLength = 0;
                for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                    codeLength += this.seqOf.get(i).encode(reverseOS, true);
                }
                codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
                if (withTag) {
                    codeLength += tag.encode(reverseOS);
                }
                return codeLength;
            }

            public int decode(InputStream is) throws IOException {
                return this.decode(is, true);
            }

            public int decode(InputStream is, boolean withTag) throws IOException {
                int tlByteCount = 0;
                int vByteCount = 0;
                BerTag berTag = new BerTag();
                if (withTag) {
                    tlByteCount += tag.decodeAndCheck(is);
                }
                BerLength length = new BerLength();
                tlByteCount += length.decode(is);
                int lengthVal = length.val;
                while (vByteCount < lengthVal || lengthVal < 0) {
                    vByteCount += berTag.decode(is);
                    if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                        vByteCount += BerLength.readEocByte((InputStream)is);
                        break;
                    }
                    if (!berTag.equals((Object)TransferSyntaxName.tag)) {
                        throw new IOException("Tag does not match mandatory sequence of/set of component.");
                    }
                    TransferSyntaxName element = new TransferSyntaxName();
                    vByteCount += element.decode(is, false);
                    this.seqOf.add(element);
                }
                if (lengthVal >= 0 && vByteCount != lengthVal) {
                    throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + lengthVal + " but has " + vByteCount);
                }
                return tlByteCount + vByteCount;
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode((OutputStream)reverseOS, false);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                int i;
                sb.append("{\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.seqOf == null) {
                    sb.append("null");
                } else {
                    Iterator<TransferSyntaxName> it = this.seqOf.iterator();
                    if (it.hasNext()) {
                        sb.append((Object)it.next());
                        while (it.hasNext()) {
                            sb.append(",\n");
                            for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                                sb.append("\t");
                            }
                            sb.append((Object)it.next());
                        }
                    }
                }
                sb.append("\n");
                for (i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
                sb.append("}");
            }
        }
    }
}

