/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.presentation.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.josistack.internal.presentation.asn1.CalledPresentationSelector;
import com.beanit.josistack.internal.presentation.asn1.CallingPresentationSelector;
import com.beanit.josistack.internal.presentation.asn1.DefaultContextName;
import com.beanit.josistack.internal.presentation.asn1.ModeSelector;
import com.beanit.josistack.internal.presentation.asn1.PresentationContextDefinitionList;
import com.beanit.josistack.internal.presentation.asn1.PresentationRequirements;
import com.beanit.josistack.internal.presentation.asn1.ProtocolVersion;
import com.beanit.josistack.internal.presentation.asn1.UserData;
import com.beanit.josistack.internal.presentation.asn1.UserSessionRequirements;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CPType
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 17);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private ModeSelector modeSelector = null;
    private NormalModeParameters normalModeParameters = null;

    public CPType() {
    }

    public CPType(byte[] code) {
        this.code = code;
    }

    public ModeSelector getModeSelector() {
        return this.modeSelector;
    }

    public void setModeSelector(ModeSelector modeSelector) {
        this.modeSelector = modeSelector;
    }

    public NormalModeParameters getNormalModeParameters() {
        return this.normalModeParameters;
    }

    public void setNormalModeParameters(NormalModeParameters normalModeParameters) {
        this.normalModeParameters = normalModeParameters;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.normalModeParameters != null) {
            codeLength += this.normalModeParameters.encode(reverseOS, false);
            reverseOS.write(162);
            ++codeLength;
        }
        codeLength += this.modeSelector.encode(reverseOS, false);
        reverseOS.write(160);
        ++codeLength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        while (vByteCount < lengthVal || lengthVal < 0) {
            vByteCount += berTag.decode(is);
            if (berTag.equals(128, 32, 0)) {
                this.modeSelector = new ModeSelector();
                vByteCount += this.modeSelector.decode(is, false);
                continue;
            }
            if (berTag.equals(128, 32, 2)) {
                this.normalModeParameters = new NormalModeParameters();
                vByteCount += this.normalModeParameters.decode(is, false);
                continue;
            }
            if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Tag does not match any set component: " + berTag);
        }
        if (vByteCount != lengthVal) {
            throw new IOException("Length of set does not match length tag, length tag: " + lengthVal + ", actual set length: " + vByteCount);
        }
        return tlByteCount + vByteCount;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.modeSelector != null) {
            sb.append("modeSelector: ");
            this.modeSelector.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("modeSelector: <empty-required-field>");
        }
        if (this.normalModeParameters != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("normalModeParameters: ");
            this.normalModeParameters.appendAsString(sb, indentLevel + 1);
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class NormalModeParameters
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private ProtocolVersion protocolVersion = null;
        private CallingPresentationSelector callingPresentationSelector = null;
        private CalledPresentationSelector calledPresentationSelector = null;
        private PresentationContextDefinitionList presentationContextDefinitionList = null;
        private DefaultContextName defaultContextName = null;
        private PresentationRequirements presentationRequirements = null;
        private UserSessionRequirements userSessionRequirements = null;
        private UserData userData = null;

        public NormalModeParameters() {
        }

        public NormalModeParameters(byte[] code) {
            this.code = code;
        }

        public ProtocolVersion getProtocolVersion() {
            return this.protocolVersion;
        }

        public void setProtocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        public CallingPresentationSelector getCallingPresentationSelector() {
            return this.callingPresentationSelector;
        }

        public void setCallingPresentationSelector(CallingPresentationSelector callingPresentationSelector) {
            this.callingPresentationSelector = callingPresentationSelector;
        }

        public CalledPresentationSelector getCalledPresentationSelector() {
            return this.calledPresentationSelector;
        }

        public void setCalledPresentationSelector(CalledPresentationSelector calledPresentationSelector) {
            this.calledPresentationSelector = calledPresentationSelector;
        }

        public PresentationContextDefinitionList getPresentationContextDefinitionList() {
            return this.presentationContextDefinitionList;
        }

        public void setPresentationContextDefinitionList(PresentationContextDefinitionList presentationContextDefinitionList) {
            this.presentationContextDefinitionList = presentationContextDefinitionList;
        }

        public DefaultContextName getDefaultContextName() {
            return this.defaultContextName;
        }

        public void setDefaultContextName(DefaultContextName defaultContextName) {
            this.defaultContextName = defaultContextName;
        }

        public PresentationRequirements getPresentationRequirements() {
            return this.presentationRequirements;
        }

        public void setPresentationRequirements(PresentationRequirements presentationRequirements) {
            this.presentationRequirements = presentationRequirements;
        }

        public UserSessionRequirements getUserSessionRequirements() {
            return this.userSessionRequirements;
        }

        public void setUserSessionRequirements(UserSessionRequirements userSessionRequirements) {
            this.userSessionRequirements = userSessionRequirements;
        }

        public UserData getUserData() {
            return this.userData;
        }

        public void setUserData(UserData userData) {
            this.userData = userData;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            if (this.userData != null) {
                codeLength += this.userData.encode(reverseOS);
            }
            if (this.userSessionRequirements != null) {
                codeLength += this.userSessionRequirements.encode(reverseOS, false);
                reverseOS.write(137);
                ++codeLength;
            }
            if (this.presentationRequirements != null) {
                codeLength += this.presentationRequirements.encode(reverseOS, false);
                reverseOS.write(136);
                ++codeLength;
            }
            if (this.defaultContextName != null) {
                codeLength += this.defaultContextName.encode(reverseOS, false);
                reverseOS.write(166);
                ++codeLength;
            }
            if (this.presentationContextDefinitionList != null) {
                codeLength += this.presentationContextDefinitionList.encode(reverseOS, false);
                reverseOS.write(164);
                ++codeLength;
            }
            if (this.calledPresentationSelector != null) {
                codeLength += this.calledPresentationSelector.encode(reverseOS, false);
                reverseOS.write(130);
                ++codeLength;
            }
            if (this.callingPresentationSelector != null) {
                codeLength += this.callingPresentationSelector.encode(reverseOS, false);
                reverseOS.write(129);
                ++codeLength;
            }
            if (this.protocolVersion != null) {
                codeLength += this.protocolVersion.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            if (lengthVal == 0) {
                return tlByteCount;
            }
            vByteCount += berTag.decode(is);
            if (berTag.equals(128, 0, 0)) {
                this.protocolVersion = new ProtocolVersion();
                if (lengthVal >= 0 && (vByteCount += this.protocolVersion.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 1)) {
                this.callingPresentationSelector = new CallingPresentationSelector();
                if (lengthVal >= 0 && (vByteCount += this.callingPresentationSelector.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 2)) {
                this.calledPresentationSelector = new CalledPresentationSelector();
                if (lengthVal >= 0 && (vByteCount += this.calledPresentationSelector.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 4)) {
                this.presentationContextDefinitionList = new PresentationContextDefinitionList();
                if (lengthVal >= 0 && (vByteCount += this.presentationContextDefinitionList.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 6)) {
                this.defaultContextName = new DefaultContextName();
                if (lengthVal >= 0 && (vByteCount += this.defaultContextName.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 8)) {
                this.presentationRequirements = new PresentationRequirements();
                if (lengthVal >= 0 && (vByteCount += this.presentationRequirements.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 9)) {
                this.userSessionRequirements = new UserSessionRequirements();
                if (lengthVal >= 0 && (vByteCount += this.userSessionRequirements.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            }
            this.userData = new UserData();
            int numDecodedBytes = this.userData.decode(is, berTag);
            if (numDecodedBytes != 0) {
                if (lengthVal >= 0 && (vByteCount += numDecodedBytes) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                this.userData = null;
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            boolean firstSelectedElement = true;
            if (this.protocolVersion != null) {
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("protocolVersion: ").append((Object)this.protocolVersion);
                firstSelectedElement = false;
            }
            if (this.callingPresentationSelector != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("callingPresentationSelector: ").append((Object)this.callingPresentationSelector);
                firstSelectedElement = false;
            }
            if (this.calledPresentationSelector != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("calledPresentationSelector: ").append((Object)this.calledPresentationSelector);
                firstSelectedElement = false;
            }
            if (this.presentationContextDefinitionList != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("presentationContextDefinitionList: ");
                this.presentationContextDefinitionList.appendAsString(sb, indentLevel + 1);
                firstSelectedElement = false;
            }
            if (this.defaultContextName != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("defaultContextName: ");
                this.defaultContextName.appendAsString(sb, indentLevel + 1);
                firstSelectedElement = false;
            }
            if (this.presentationRequirements != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("presentationRequirements: ").append((Object)this.presentationRequirements);
                firstSelectedElement = false;
            }
            if (this.userSessionRequirements != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("userSessionRequirements: ").append((Object)this.userSessionRequirements);
                firstSelectedElement = false;
            }
            if (this.userData != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("userData: ");
                this.userData.appendAsString(sb, indentLevel + 1);
                firstSelectedElement = false;
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

