/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerBitString;
import com.beanit.asn1bean.ber.types.BerObjectIdentifier;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.josistack.internal.acse.asn1.ACSERequirements;
import com.beanit.josistack.internal.acse.asn1.AEInvocationIdentifier;
import com.beanit.josistack.internal.acse.asn1.AEQualifier;
import com.beanit.josistack.internal.acse.asn1.APInvocationIdentifier;
import com.beanit.josistack.internal.acse.asn1.APTitle;
import com.beanit.josistack.internal.acse.asn1.ApplicationContextNameList;
import com.beanit.josistack.internal.acse.asn1.AssociationInformation;
import com.beanit.josistack.internal.acse.asn1.AuthenticationValue;
import com.beanit.josistack.internal.acse.asn1.ImplementationData;
import com.beanit.josistack.internal.acse.asn1.MechanismName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AARQApdu
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(64, 32, 0);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private BerBitString protocolVersion = null;
    private BerObjectIdentifier applicationContextName = null;
    private APTitle calledAPTitle = null;
    private AEQualifier calledAEQualifier = null;
    private APInvocationIdentifier calledAPInvocationIdentifier = null;
    private AEInvocationIdentifier calledAEInvocationIdentifier = null;
    private APTitle callingAPTitle = null;
    private AEQualifier callingAEQualifier = null;
    private APInvocationIdentifier callingAPInvocationIdentifier = null;
    private AEInvocationIdentifier callingAEInvocationIdentifier = null;
    private ACSERequirements senderAcseRequirements = null;
    private MechanismName mechanismName = null;
    private AuthenticationValue callingAuthenticationValue = null;
    private ApplicationContextNameList applicationContextNameList = null;
    private ImplementationData implementationInformation = null;
    private AssociationInformation userInformation = null;

    public AARQApdu() {
    }

    public AARQApdu(byte[] code) {
        this.code = code;
    }

    public BerBitString getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(BerBitString protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public BerObjectIdentifier getApplicationContextName() {
        return this.applicationContextName;
    }

    public void setApplicationContextName(BerObjectIdentifier applicationContextName) {
        this.applicationContextName = applicationContextName;
    }

    public APTitle getCalledAPTitle() {
        return this.calledAPTitle;
    }

    public void setCalledAPTitle(APTitle calledAPTitle) {
        this.calledAPTitle = calledAPTitle;
    }

    public AEQualifier getCalledAEQualifier() {
        return this.calledAEQualifier;
    }

    public void setCalledAEQualifier(AEQualifier calledAEQualifier) {
        this.calledAEQualifier = calledAEQualifier;
    }

    public APInvocationIdentifier getCalledAPInvocationIdentifier() {
        return this.calledAPInvocationIdentifier;
    }

    public void setCalledAPInvocationIdentifier(APInvocationIdentifier calledAPInvocationIdentifier) {
        this.calledAPInvocationIdentifier = calledAPInvocationIdentifier;
    }

    public AEInvocationIdentifier getCalledAEInvocationIdentifier() {
        return this.calledAEInvocationIdentifier;
    }

    public void setCalledAEInvocationIdentifier(AEInvocationIdentifier calledAEInvocationIdentifier) {
        this.calledAEInvocationIdentifier = calledAEInvocationIdentifier;
    }

    public APTitle getCallingAPTitle() {
        return this.callingAPTitle;
    }

    public void setCallingAPTitle(APTitle callingAPTitle) {
        this.callingAPTitle = callingAPTitle;
    }

    public AEQualifier getCallingAEQualifier() {
        return this.callingAEQualifier;
    }

    public void setCallingAEQualifier(AEQualifier callingAEQualifier) {
        this.callingAEQualifier = callingAEQualifier;
    }

    public APInvocationIdentifier getCallingAPInvocationIdentifier() {
        return this.callingAPInvocationIdentifier;
    }

    public void setCallingAPInvocationIdentifier(APInvocationIdentifier callingAPInvocationIdentifier) {
        this.callingAPInvocationIdentifier = callingAPInvocationIdentifier;
    }

    public AEInvocationIdentifier getCallingAEInvocationIdentifier() {
        return this.callingAEInvocationIdentifier;
    }

    public void setCallingAEInvocationIdentifier(AEInvocationIdentifier callingAEInvocationIdentifier) {
        this.callingAEInvocationIdentifier = callingAEInvocationIdentifier;
    }

    public ACSERequirements getSenderAcseRequirements() {
        return this.senderAcseRequirements;
    }

    public void setSenderAcseRequirements(ACSERequirements senderAcseRequirements) {
        this.senderAcseRequirements = senderAcseRequirements;
    }

    public MechanismName getMechanismName() {
        return this.mechanismName;
    }

    public void setMechanismName(MechanismName mechanismName) {
        this.mechanismName = mechanismName;
    }

    public AuthenticationValue getCallingAuthenticationValue() {
        return this.callingAuthenticationValue;
    }

    public void setCallingAuthenticationValue(AuthenticationValue callingAuthenticationValue) {
        this.callingAuthenticationValue = callingAuthenticationValue;
    }

    public ApplicationContextNameList getApplicationContextNameList() {
        return this.applicationContextNameList;
    }

    public void setApplicationContextNameList(ApplicationContextNameList applicationContextNameList) {
        this.applicationContextNameList = applicationContextNameList;
    }

    public ImplementationData getImplementationInformation() {
        return this.implementationInformation;
    }

    public void setImplementationInformation(ImplementationData implementationInformation) {
        this.implementationInformation = implementationInformation;
    }

    public AssociationInformation getUserInformation() {
        return this.userInformation;
    }

    public void setUserInformation(AssociationInformation userInformation) {
        this.userInformation = userInformation;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        int sublength;
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.userInformation != null) {
            codeLength += this.userInformation.encode(reverseOS, false);
            reverseOS.write(190);
            ++codeLength;
        }
        if (this.implementationInformation != null) {
            codeLength += this.implementationInformation.encode(reverseOS, false);
            reverseOS.write(157);
            ++codeLength;
        }
        if (this.applicationContextNameList != null) {
            codeLength += this.applicationContextNameList.encode(reverseOS, false);
            reverseOS.write(173);
            ++codeLength;
        }
        if (this.callingAuthenticationValue != null) {
            sublength = this.callingAuthenticationValue.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(172);
            ++codeLength;
        }
        if (this.mechanismName != null) {
            codeLength += this.mechanismName.encode(reverseOS, false);
            reverseOS.write(139);
            ++codeLength;
        }
        if (this.senderAcseRequirements != null) {
            codeLength += this.senderAcseRequirements.encode(reverseOS, false);
            reverseOS.write(138);
            ++codeLength;
        }
        if (this.callingAEInvocationIdentifier != null) {
            sublength = this.callingAEInvocationIdentifier.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(169);
            ++codeLength;
        }
        if (this.callingAPInvocationIdentifier != null) {
            sublength = this.callingAPInvocationIdentifier.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(168);
            ++codeLength;
        }
        if (this.callingAEQualifier != null) {
            sublength = this.callingAEQualifier.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(167);
            ++codeLength;
        }
        if (this.callingAPTitle != null) {
            sublength = this.callingAPTitle.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(166);
            ++codeLength;
        }
        if (this.calledAEInvocationIdentifier != null) {
            sublength = this.calledAEInvocationIdentifier.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(165);
            ++codeLength;
        }
        if (this.calledAPInvocationIdentifier != null) {
            sublength = this.calledAPInvocationIdentifier.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(164);
            ++codeLength;
        }
        if (this.calledAEQualifier != null) {
            sublength = this.calledAEQualifier.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(163);
            ++codeLength;
        }
        if (this.calledAPTitle != null) {
            sublength = this.calledAPTitle.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(162);
            ++codeLength;
        }
        sublength = this.applicationContextName.encode(reverseOS, true);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(161);
        ++codeLength;
        if (this.protocolVersion != null) {
            codeLength += this.protocolVersion.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.protocolVersion = new BerBitString();
            vByteCount += this.protocolVersion.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            vByteCount += length.decode(is);
            this.applicationContextName = new BerObjectIdentifier();
            vByteCount += this.applicationContextName.decode(is, true);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 32, 2)) {
            vByteCount += length.decode(is);
            this.calledAPTitle = new APTitle();
            vByteCount += this.calledAPTitle.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 3)) {
            vByteCount += length.decode(is);
            this.calledAEQualifier = new AEQualifier();
            vByteCount += this.calledAEQualifier.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 4)) {
            vByteCount += length.decode(is);
            this.calledAPInvocationIdentifier = new APInvocationIdentifier();
            vByteCount += this.calledAPInvocationIdentifier.decode(is, true);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 5)) {
            vByteCount += length.decode(is);
            this.calledAEInvocationIdentifier = new AEInvocationIdentifier();
            vByteCount += this.calledAEInvocationIdentifier.decode(is, true);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 6)) {
            vByteCount += length.decode(is);
            this.callingAPTitle = new APTitle();
            vByteCount += this.callingAPTitle.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 7)) {
            vByteCount += length.decode(is);
            this.callingAEQualifier = new AEQualifier();
            vByteCount += this.callingAEQualifier.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 8)) {
            vByteCount += length.decode(is);
            this.callingAPInvocationIdentifier = new APInvocationIdentifier();
            vByteCount += this.callingAPInvocationIdentifier.decode(is, true);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 9)) {
            vByteCount += length.decode(is);
            this.callingAEInvocationIdentifier = new AEInvocationIdentifier();
            vByteCount += this.callingAEInvocationIdentifier.decode(is, true);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 10)) {
            this.senderAcseRequirements = new ACSERequirements();
            if (lengthVal >= 0 && (vByteCount += this.senderAcseRequirements.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 11)) {
            this.mechanismName = new MechanismName();
            if (lengthVal >= 0 && (vByteCount += this.mechanismName.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 12)) {
            vByteCount += length.decode(is);
            this.callingAuthenticationValue = new AuthenticationValue();
            vByteCount += this.callingAuthenticationValue.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 13)) {
            this.applicationContextNameList = new ApplicationContextNameList();
            if (lengthVal >= 0 && (vByteCount += this.applicationContextNameList.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 29)) {
            this.implementationInformation = new ImplementationData();
            if (lengthVal >= 0 && (vByteCount += this.implementationInformation.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 30)) {
            this.userInformation = new AssociationInformation();
            if (lengthVal >= 0 && (vByteCount += this.userInformation.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.protocolVersion != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("protocolVersion: ").append(this.protocolVersion);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.applicationContextName != null) {
            sb.append("applicationContextName: ").append(this.applicationContextName);
        } else {
            sb.append("applicationContextName: <empty-required-field>");
        }
        if (this.calledAPTitle != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("calledAPTitle: ");
            this.calledAPTitle.appendAsString(sb, indentLevel + 1);
        }
        if (this.calledAEQualifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("calledAEQualifier: ");
            this.calledAEQualifier.appendAsString(sb, indentLevel + 1);
        }
        if (this.calledAPInvocationIdentifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("calledAPInvocationIdentifier: ").append((Object)this.calledAPInvocationIdentifier);
        }
        if (this.calledAEInvocationIdentifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("calledAEInvocationIdentifier: ").append((Object)this.calledAEInvocationIdentifier);
        }
        if (this.callingAPTitle != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("callingAPTitle: ");
            this.callingAPTitle.appendAsString(sb, indentLevel + 1);
        }
        if (this.callingAEQualifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("callingAEQualifier: ");
            this.callingAEQualifier.appendAsString(sb, indentLevel + 1);
        }
        if (this.callingAPInvocationIdentifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("callingAPInvocationIdentifier: ").append((Object)this.callingAPInvocationIdentifier);
        }
        if (this.callingAEInvocationIdentifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("callingAEInvocationIdentifier: ").append((Object)this.callingAEInvocationIdentifier);
        }
        if (this.senderAcseRequirements != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("senderAcseRequirements: ").append((Object)this.senderAcseRequirements);
        }
        if (this.mechanismName != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("mechanismName: ").append((Object)this.mechanismName);
        }
        if (this.callingAuthenticationValue != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("callingAuthenticationValue: ");
            this.callingAuthenticationValue.appendAsString(sb, indentLevel + 1);
        }
        if (this.applicationContextNameList != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("applicationContextNameList: ");
            this.applicationContextNameList.appendAsString(sb, indentLevel + 1);
        }
        if (this.implementationInformation != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("implementationInformation: ").append((Object)this.implementationInformation);
        }
        if (this.userInformation != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("userInformation: ");
            this.userInformation.appendAsString(sb, indentLevel + 1);
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

