/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        int size = Math.min(len, this.available());
        this.buf.get(b, off, size);
        return size;
    }

    @Override
    public int available() throws IOException {
        return this.buf.limit() - this.buf.position();
    }
}

