/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerNull;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.DataAccessError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WriteResponse
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private List<CHOICE> seqOf = null;

    public WriteResponse() {
        this.seqOf = new ArrayList<CHOICE>();
    }

    public WriteResponse(byte[] code) {
        this.code = code;
    }

    public List<CHOICE> getCHOICE() {
        if (this.seqOf == null) {
            this.seqOf = new ArrayList<CHOICE>();
        }
        return this.seqOf;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        for (int i = this.seqOf.size() - 1; i >= 0; --i) {
            codeLength += this.seqOf.get(i).encode(reverseOS);
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        while (vByteCount < lengthVal || lengthVal < 0) {
            vByteCount += berTag.decode(is);
            if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                vByteCount += BerLength.readEocByte((InputStream)is);
                break;
            }
            CHOICE element = new CHOICE();
            int numDecodedBytes = element.decode(is, berTag);
            if (numDecodedBytes == 0) {
                throw new IOException("Tag did not match");
            }
            vByteCount += numDecodedBytes;
            this.seqOf.add(element);
        }
        if (lengthVal >= 0 && vByteCount != lengthVal) {
            throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + lengthVal + " but has " + vByteCount);
        }
        return tlByteCount + vByteCount;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.seqOf == null) {
            sb.append("null");
        } else {
            Iterator<CHOICE> it = this.seqOf.iterator();
            if (it.hasNext()) {
                it.next().appendAsString(sb, indentLevel + 1);
                while (it.hasNext()) {
                    sb.append(",\n");
                    for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                        sb.append("\t");
                    }
                    it.next().appendAsString(sb, indentLevel + 1);
                }
            }
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class CHOICE
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private DataAccessError failure = null;
        private BerNull success = null;

        public CHOICE() {
        }

        public CHOICE(byte[] code) {
            this.code = code;
        }

        public DataAccessError getFailure() {
            return this.failure;
        }

        public void setFailure(DataAccessError failure) {
            this.failure = failure;
        }

        public BerNull getSuccess() {
            return this.success;
        }

        public void setSuccess(BerNull success) {
            this.success = success;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                return this.code.length;
            }
            int codeLength = 0;
            if (this.success != null) {
                codeLength += this.success.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.failure != null) {
                codeLength += this.failure.encode(reverseOS, false);
                reverseOS.write(128);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            boolean tagWasPassed;
            int tlvByteCount = 0;
            boolean bl = tagWasPassed = berTag != null;
            if (berTag == null) {
                berTag = new BerTag();
                tlvByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 0)) {
                this.failure = new DataAccessError();
                return tlvByteCount += this.failure.decode(is, false);
            }
            if (berTag.equals(128, 0, 1)) {
                this.success = new BerNull();
                return tlvByteCount += this.success.decode(is, false);
            }
            if (tagWasPassed) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.failure != null) {
                sb.append("failure: ").append((Object)this.failure);
                return;
            }
            if (this.success != null) {
                sb.append("success: ").append(this.success);
                return;
            }
            sb.append("<none>");
        }
    }
}

