/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerNull;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.BerBoolean;
import com.beanit.iec61850bean.internal.mms.asn1.Identifier;
import com.beanit.iec61850bean.internal.mms.asn1.Integer32;
import com.beanit.iec61850bean.internal.mms.asn1.TypeSpecification;
import com.beanit.iec61850bean.internal.mms.asn1.Unsigned32;
import com.beanit.iec61850bean.internal.mms.asn1.Unsigned8;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TypeDescription
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private Array array = null;
    private Structure structure = null;
    private BerNull bool = null;
    private Integer32 bitString = null;
    private Unsigned8 integer = null;
    private Unsigned8 unsigned = null;
    private FloatingPoint floatingPoint = null;
    private Integer32 octetString = null;
    private Integer32 visibleString = null;
    private BerBoolean binaryTime = null;
    private Integer32 mMSString = null;
    private BerNull utcTime = null;

    public TypeDescription() {
    }

    public TypeDescription(byte[] code) {
        this.code = code;
    }

    public Array getArray() {
        return this.array;
    }

    public void setArray(Array array) {
        this.array = array;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    public BerNull getBool() {
        return this.bool;
    }

    public void setBool(BerNull bool) {
        this.bool = bool;
    }

    public Integer32 getBitString() {
        return this.bitString;
    }

    public void setBitString(Integer32 bitString) {
        this.bitString = bitString;
    }

    public Unsigned8 getInteger() {
        return this.integer;
    }

    public void setInteger(Unsigned8 integer) {
        this.integer = integer;
    }

    public Unsigned8 getUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(Unsigned8 unsigned) {
        this.unsigned = unsigned;
    }

    public FloatingPoint getFloatingPoint() {
        return this.floatingPoint;
    }

    public void setFloatingPoint(FloatingPoint floatingPoint) {
        this.floatingPoint = floatingPoint;
    }

    public Integer32 getOctetString() {
        return this.octetString;
    }

    public void setOctetString(Integer32 octetString) {
        this.octetString = octetString;
    }

    public Integer32 getVisibleString() {
        return this.visibleString;
    }

    public void setVisibleString(Integer32 visibleString) {
        this.visibleString = visibleString;
    }

    public BerBoolean getBinaryTime() {
        return this.binaryTime;
    }

    public void setBinaryTime(BerBoolean binaryTime) {
        this.binaryTime = binaryTime;
    }

    public Integer32 getMMSString() {
        return this.mMSString;
    }

    public void setMMSString(Integer32 mMSString) {
        this.mMSString = mMSString;
    }

    public BerNull getUtcTime() {
        return this.utcTime;
    }

    public void setUtcTime(BerNull utcTime) {
        this.utcTime = utcTime;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.utcTime != null) {
            codeLength += this.utcTime.encode(reverseOS, false);
            reverseOS.write(145);
            return ++codeLength;
        }
        if (this.mMSString != null) {
            codeLength += this.mMSString.encode(reverseOS, false);
            reverseOS.write(144);
            return ++codeLength;
        }
        if (this.binaryTime != null) {
            codeLength += this.binaryTime.encode(reverseOS, false);
            reverseOS.write(140);
            return ++codeLength;
        }
        if (this.visibleString != null) {
            codeLength += this.visibleString.encode(reverseOS, false);
            reverseOS.write(138);
            return ++codeLength;
        }
        if (this.octetString != null) {
            codeLength += this.octetString.encode(reverseOS, false);
            reverseOS.write(137);
            return ++codeLength;
        }
        if (this.floatingPoint != null) {
            codeLength += this.floatingPoint.encode(reverseOS, false);
            reverseOS.write(167);
            return ++codeLength;
        }
        if (this.unsigned != null) {
            codeLength += this.unsigned.encode(reverseOS, false);
            reverseOS.write(134);
            return ++codeLength;
        }
        if (this.integer != null) {
            codeLength += this.integer.encode(reverseOS, false);
            reverseOS.write(133);
            return ++codeLength;
        }
        if (this.bitString != null) {
            codeLength += this.bitString.encode(reverseOS, false);
            reverseOS.write(132);
            return ++codeLength;
        }
        if (this.bool != null) {
            codeLength += this.bool.encode(reverseOS, false);
            reverseOS.write(131);
            return ++codeLength;
        }
        if (this.structure != null) {
            codeLength += this.structure.encode(reverseOS, false);
            reverseOS.write(162);
            return ++codeLength;
        }
        if (this.array != null) {
            codeLength += this.array.encode(reverseOS, false);
            reverseOS.write(161);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            this.array = new Array();
            return tlvByteCount += this.array.decode(is, false);
        }
        if (berTag.equals(128, 32, 2)) {
            this.structure = new Structure();
            return tlvByteCount += this.structure.decode(is, false);
        }
        if (berTag.equals(128, 0, 3)) {
            this.bool = new BerNull();
            return tlvByteCount += this.bool.decode(is, false);
        }
        if (berTag.equals(128, 0, 4)) {
            this.bitString = new Integer32();
            return tlvByteCount += this.bitString.decode(is, false);
        }
        if (berTag.equals(128, 0, 5)) {
            this.integer = new Unsigned8();
            return tlvByteCount += this.integer.decode(is, false);
        }
        if (berTag.equals(128, 0, 6)) {
            this.unsigned = new Unsigned8();
            return tlvByteCount += this.unsigned.decode(is, false);
        }
        if (berTag.equals(128, 32, 7)) {
            this.floatingPoint = new FloatingPoint();
            return tlvByteCount += this.floatingPoint.decode(is, false);
        }
        if (berTag.equals(128, 0, 9)) {
            this.octetString = new Integer32();
            return tlvByteCount += this.octetString.decode(is, false);
        }
        if (berTag.equals(128, 0, 10)) {
            this.visibleString = new Integer32();
            return tlvByteCount += this.visibleString.decode(is, false);
        }
        if (berTag.equals(128, 0, 12)) {
            this.binaryTime = new BerBoolean();
            return tlvByteCount += this.binaryTime.decode(is, false);
        }
        if (berTag.equals(128, 0, 16)) {
            this.mMSString = new Integer32();
            return tlvByteCount += this.mMSString.decode(is, false);
        }
        if (berTag.equals(128, 0, 17)) {
            this.utcTime = new BerNull();
            return tlvByteCount += this.utcTime.decode(is, false);
        }
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.array != null) {
            sb.append("array: ");
            this.array.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.structure != null) {
            sb.append("structure: ");
            this.structure.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.bool != null) {
            sb.append("bool: ").append(this.bool);
            return;
        }
        if (this.bitString != null) {
            sb.append("bitString: ").append((Object)this.bitString);
            return;
        }
        if (this.integer != null) {
            sb.append("integer: ").append((Object)this.integer);
            return;
        }
        if (this.unsigned != null) {
            sb.append("unsigned: ").append((Object)this.unsigned);
            return;
        }
        if (this.floatingPoint != null) {
            sb.append("floatingPoint: ");
            this.floatingPoint.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.octetString != null) {
            sb.append("octetString: ").append((Object)this.octetString);
            return;
        }
        if (this.visibleString != null) {
            sb.append("visibleString: ").append((Object)this.visibleString);
            return;
        }
        if (this.binaryTime != null) {
            sb.append("binaryTime: ").append(this.binaryTime);
            return;
        }
        if (this.mMSString != null) {
            sb.append("mMSString: ").append((Object)this.mMSString);
            return;
        }
        if (this.utcTime != null) {
            sb.append("utcTime: ").append(this.utcTime);
            return;
        }
        sb.append("<none>");
    }

    public static class FloatingPoint
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Unsigned8 formatWidth = null;
        private Unsigned8 exponentWidth = null;

        public FloatingPoint() {
        }

        public FloatingPoint(byte[] code) {
            this.code = code;
        }

        public Unsigned8 getFormatWidth() {
            return this.formatWidth;
        }

        public void setFormatWidth(Unsigned8 formatWidth) {
            this.formatWidth = formatWidth;
        }

        public Unsigned8 getExponentWidth() {
            return this.exponentWidth;
        }

        public void setExponentWidth(Unsigned8 exponentWidth) {
            this.exponentWidth = exponentWidth;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.exponentWidth.encode(reverseOS, true);
            codeLength += this.formatWidth.encode(reverseOS, true);
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);
            if (berTag.equals((Object)Unsigned8.tag)) {
                this.formatWidth = new Unsigned8();
                vByteCount += this.formatWidth.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals((Object)Unsigned8.tag)) {
                this.exponentWidth = new Unsigned8();
                if (lengthVal >= 0 && (vByteCount += this.exponentWidth.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.formatWidth != null) {
                sb.append("formatWidth: ").append((Object)this.formatWidth);
            } else {
                sb.append("formatWidth: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.exponentWidth != null) {
                sb.append("exponentWidth: ").append((Object)this.exponentWidth);
            } else {
                sb.append("exponentWidth: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }

    public static class Structure
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private BerBoolean packed = null;
        private Components components = null;

        public Structure() {
        }

        public Structure(byte[] code) {
            this.code = code;
        }

        public BerBoolean getPacked() {
            return this.packed;
        }

        public void setPacked(BerBoolean packed) {
            this.packed = packed;
        }

        public Components getComponents() {
            return this.components;
        }

        public void setComponents(Components components) {
            this.components = components;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.components.encode(reverseOS, false);
            reverseOS.write(161);
            ++codeLength;
            if (this.packed != null) {
                codeLength += this.packed.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);
            if (berTag.equals(128, 0, 0)) {
                this.packed = new BerBoolean();
                vByteCount += this.packed.decode(is, false);
                vByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 1)) {
                this.components = new Components();
                if (lengthVal >= 0 && (vByteCount += this.components.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            boolean firstSelectedElement = true;
            if (this.packed != null) {
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("packed: ").append(this.packed);
                firstSelectedElement = false;
            }
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.components != null) {
                sb.append("components: ");
                this.components.appendAsString(sb, indentLevel + 1);
            } else {
                sb.append("components: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }

        public static class Components
        implements BerType,
        Serializable {
            public static final BerTag tag = new BerTag(0, 32, 16);
            private static final long serialVersionUID = 1L;
            private byte[] code = null;
            private List<SEQUENCE> seqOf = null;

            public Components() {
                this.seqOf = new ArrayList<SEQUENCE>();
            }

            public Components(byte[] code) {
                this.code = code;
            }

            public List<SEQUENCE> getSEQUENCE() {
                if (this.seqOf == null) {
                    this.seqOf = new ArrayList<SEQUENCE>();
                }
                return this.seqOf;
            }

            public int encode(OutputStream reverseOS) throws IOException {
                return this.encode(reverseOS, true);
            }

            public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                if (this.code != null) {
                    reverseOS.write(this.code);
                    if (withTag) {
                        return tag.encode(reverseOS) + this.code.length;
                    }
                    return this.code.length;
                }
                int codeLength = 0;
                for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                    codeLength += this.seqOf.get(i).encode(reverseOS, true);
                }
                codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
                if (withTag) {
                    codeLength += tag.encode(reverseOS);
                }
                return codeLength;
            }

            public int decode(InputStream is) throws IOException {
                return this.decode(is, true);
            }

            public int decode(InputStream is, boolean withTag) throws IOException {
                int tlByteCount = 0;
                int vByteCount = 0;
                BerTag berTag = new BerTag();
                if (withTag) {
                    tlByteCount += tag.decodeAndCheck(is);
                }
                BerLength length = new BerLength();
                tlByteCount += length.decode(is);
                int lengthVal = length.val;
                while (vByteCount < lengthVal || lengthVal < 0) {
                    vByteCount += berTag.decode(is);
                    if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                        vByteCount += BerLength.readEocByte((InputStream)is);
                        break;
                    }
                    if (!berTag.equals((Object)SEQUENCE.tag)) {
                        throw new IOException("Tag does not match mandatory sequence of/set of component.");
                    }
                    SEQUENCE element = new SEQUENCE();
                    vByteCount += element.decode(is, false);
                    this.seqOf.add(element);
                }
                if (lengthVal >= 0 && vByteCount != lengthVal) {
                    throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + lengthVal + " but has " + vByteCount);
                }
                return tlByteCount + vByteCount;
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode((OutputStream)reverseOS, false);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                int i;
                sb.append("{\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.seqOf == null) {
                    sb.append("null");
                } else {
                    Iterator<SEQUENCE> it = this.seqOf.iterator();
                    if (it.hasNext()) {
                        it.next().appendAsString(sb, indentLevel + 1);
                        while (it.hasNext()) {
                            sb.append(",\n");
                            for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                                sb.append("\t");
                            }
                            it.next().appendAsString(sb, indentLevel + 1);
                        }
                    }
                }
                sb.append("\n");
                for (i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
                sb.append("}");
            }

            public static class SEQUENCE
            implements BerType,
            Serializable {
                public static final BerTag tag = new BerTag(0, 32, 16);
                private static final long serialVersionUID = 1L;
                private byte[] code = null;
                private Identifier componentName = null;
                private TypeSpecification componentType = null;

                public SEQUENCE() {
                }

                public SEQUENCE(byte[] code) {
                    this.code = code;
                }

                public Identifier getComponentName() {
                    return this.componentName;
                }

                public void setComponentName(Identifier componentName) {
                    this.componentName = componentName;
                }

                public TypeSpecification getComponentType() {
                    return this.componentType;
                }

                public void setComponentType(TypeSpecification componentType) {
                    this.componentType = componentType;
                }

                public int encode(OutputStream reverseOS) throws IOException {
                    return this.encode(reverseOS, true);
                }

                public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                    if (this.code != null) {
                        reverseOS.write(this.code);
                        if (withTag) {
                            return tag.encode(reverseOS) + this.code.length;
                        }
                        return this.code.length;
                    }
                    int codeLength = 0;
                    int sublength = this.componentType.encode(reverseOS);
                    codeLength += sublength;
                    codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
                    reverseOS.write(161);
                    ++codeLength;
                    if (this.componentName != null) {
                        codeLength += this.componentName.encode(reverseOS, false);
                        reverseOS.write(128);
                        ++codeLength;
                    }
                    codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
                    if (withTag) {
                        codeLength += tag.encode(reverseOS);
                    }
                    return codeLength;
                }

                public int decode(InputStream is) throws IOException {
                    return this.decode(is, true);
                }

                public int decode(InputStream is, boolean withTag) throws IOException {
                    int tlByteCount = 0;
                    int vByteCount = 0;
                    BerTag berTag = new BerTag();
                    if (withTag) {
                        tlByteCount += tag.decodeAndCheck(is);
                    }
                    BerLength length = new BerLength();
                    tlByteCount += length.decode(is);
                    int lengthVal = length.val;
                    vByteCount += berTag.decode(is);
                    if (berTag.equals(128, 0, 0)) {
                        this.componentName = new Identifier();
                        vByteCount += this.componentName.decode(is, false);
                        vByteCount += berTag.decode(is);
                    }
                    if (berTag.equals(128, 32, 1)) {
                        vByteCount += length.decode(is);
                        this.componentType = new TypeSpecification();
                        vByteCount += this.componentType.decode(is, null);
                        if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                            return tlByteCount + vByteCount;
                        }
                        vByteCount += berTag.decode(is);
                    } else {
                        throw new IOException("Tag does not match mandatory sequence component.");
                    }
                    if (lengthVal < 0) {
                        if (!berTag.equals(0, 0, 0)) {
                            throw new IOException("Decoded sequence has wrong end of contents octets");
                        }
                        return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
                    }
                    throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
                }

                public void encodeAndSave(int encodingSizeGuess) throws IOException {
                    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                    this.encode((OutputStream)reverseOS, false);
                    this.code = reverseOS.getArray();
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    this.appendAsString(sb, 0);
                    return sb.toString();
                }

                public void appendAsString(StringBuilder sb, int indentLevel) {
                    int i;
                    sb.append("{");
                    boolean firstSelectedElement = true;
                    if (this.componentName != null) {
                        sb.append("\n");
                        for (i = 0; i < indentLevel + 1; ++i) {
                            sb.append("\t");
                        }
                        sb.append("componentName: ").append((Object)this.componentName);
                        firstSelectedElement = false;
                    }
                    if (!firstSelectedElement) {
                        sb.append(",\n");
                    }
                    for (i = 0; i < indentLevel + 1; ++i) {
                        sb.append("\t");
                    }
                    if (this.componentType != null) {
                        sb.append("componentType: ");
                        this.componentType.appendAsString(sb, indentLevel + 1);
                    } else {
                        sb.append("componentType: <empty-required-field>");
                    }
                    sb.append("\n");
                    for (i = 0; i < indentLevel; ++i) {
                        sb.append("\t");
                    }
                    sb.append("}");
                }
            }
        }
    }

    public static class Array
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private BerBoolean packed = null;
        private Unsigned32 numberOfElements = null;
        private TypeSpecification elementType = null;

        public Array() {
        }

        public Array(byte[] code) {
            this.code = code;
        }

        public BerBoolean getPacked() {
            return this.packed;
        }

        public void setPacked(BerBoolean packed) {
            this.packed = packed;
        }

        public Unsigned32 getNumberOfElements() {
            return this.numberOfElements;
        }

        public void setNumberOfElements(Unsigned32 numberOfElements) {
            this.numberOfElements = numberOfElements;
        }

        public TypeSpecification getElementType() {
            return this.elementType;
        }

        public void setElementType(TypeSpecification elementType) {
            this.elementType = elementType;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            int sublength = this.elementType.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(162);
            ++codeLength;
            codeLength += this.numberOfElements.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
            if (this.packed != null) {
                codeLength += this.packed.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);
            if (berTag.equals(128, 0, 0)) {
                this.packed = new BerBoolean();
                vByteCount += this.packed.decode(is, false);
                vByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 1)) {
                this.numberOfElements = new Unsigned32();
                vByteCount += this.numberOfElements.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals(128, 32, 2)) {
                vByteCount += length.decode(is);
                this.elementType = new TypeSpecification();
                vByteCount += this.elementType.decode(is, null);
                if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            boolean firstSelectedElement = true;
            if (this.packed != null) {
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("packed: ").append(this.packed);
                firstSelectedElement = false;
            }
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.numberOfElements != null) {
                sb.append("numberOfElements: ").append((Object)this.numberOfElements);
            } else {
                sb.append("numberOfElements: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.elementType != null) {
                sb.append("elementType: ");
                this.elementType.appendAsString(sb, indentLevel + 1);
            } else {
                sb.append("elementType: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

