/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.Identifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ObjectName
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private Identifier vmdSpecific = null;
    private DomainSpecific domainSpecific = null;
    private Identifier aaSpecific = null;

    public ObjectName() {
    }

    public ObjectName(byte[] code) {
        this.code = code;
    }

    public Identifier getVmdSpecific() {
        return this.vmdSpecific;
    }

    public void setVmdSpecific(Identifier vmdSpecific) {
        this.vmdSpecific = vmdSpecific;
    }

    public DomainSpecific getDomainSpecific() {
        return this.domainSpecific;
    }

    public void setDomainSpecific(DomainSpecific domainSpecific) {
        this.domainSpecific = domainSpecific;
    }

    public Identifier getAaSpecific() {
        return this.aaSpecific;
    }

    public void setAaSpecific(Identifier aaSpecific) {
        this.aaSpecific = aaSpecific;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.aaSpecific != null) {
            codeLength += this.aaSpecific.encode(reverseOS, false);
            reverseOS.write(130);
            return ++codeLength;
        }
        if (this.domainSpecific != null) {
            codeLength += this.domainSpecific.encode(reverseOS, false);
            reverseOS.write(161);
            return ++codeLength;
        }
        if (this.vmdSpecific != null) {
            codeLength += this.vmdSpecific.encode(reverseOS, false);
            reverseOS.write(128);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 0)) {
            this.vmdSpecific = new Identifier();
            return tlvByteCount += this.vmdSpecific.decode(is, false);
        }
        if (berTag.equals(128, 32, 1)) {
            this.domainSpecific = new DomainSpecific();
            return tlvByteCount += this.domainSpecific.decode(is, false);
        }
        if (berTag.equals(128, 0, 2)) {
            this.aaSpecific = new Identifier();
            return tlvByteCount += this.aaSpecific.decode(is, false);
        }
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.vmdSpecific != null) {
            sb.append("vmdSpecific: ").append((Object)this.vmdSpecific);
            return;
        }
        if (this.domainSpecific != null) {
            sb.append("domainSpecific: ");
            this.domainSpecific.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.aaSpecific != null) {
            sb.append("aaSpecific: ").append((Object)this.aaSpecific);
            return;
        }
        sb.append("<none>");
    }

    public static class DomainSpecific
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Identifier domainID = null;
        private Identifier itemID = null;

        public DomainSpecific() {
        }

        public DomainSpecific(byte[] code) {
            this.code = code;
        }

        public Identifier getDomainID() {
            return this.domainID;
        }

        public void setDomainID(Identifier domainID) {
            this.domainID = domainID;
        }

        public Identifier getItemID() {
            return this.itemID;
        }

        public void setItemID(Identifier itemID) {
            this.itemID = itemID;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.itemID.encode(reverseOS, true);
            codeLength += this.domainID.encode(reverseOS, true);
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);
            if (berTag.equals((Object)Identifier.tag)) {
                this.domainID = new Identifier();
                vByteCount += this.domainID.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals((Object)Identifier.tag)) {
                this.itemID = new Identifier();
                if (lengthVal >= 0 && (vByteCount += this.itemID.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.domainID != null) {
                sb.append("domainID: ").append((Object)this.domainID);
            } else {
                sb.append("domainID: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.itemID != null) {
                sb.append("itemID: ").append((Object)this.itemID);
            } else {
                sb.append("itemID: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

