/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.Integer16;
import com.beanit.iec61850bean.internal.mms.asn1.Integer32;
import com.beanit.iec61850bean.internal.mms.asn1.Integer8;
import com.beanit.iec61850bean.internal.mms.asn1.ParameterSupportOptions;
import com.beanit.iec61850bean.internal.mms.asn1.ServiceSupportOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class InitiateResponsePDU
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private Integer32 localDetailCalled = null;
    private Integer16 negotiatedMaxServOutstandingCalling = null;
    private Integer16 negotiatedMaxServOutstandingCalled = null;
    private Integer8 negotiatedDataStructureNestingLevel = null;
    private InitResponseDetail initResponseDetail = null;

    public InitiateResponsePDU() {
    }

    public InitiateResponsePDU(byte[] code) {
        this.code = code;
    }

    public Integer32 getLocalDetailCalled() {
        return this.localDetailCalled;
    }

    public void setLocalDetailCalled(Integer32 localDetailCalled) {
        this.localDetailCalled = localDetailCalled;
    }

    public Integer16 getNegotiatedMaxServOutstandingCalling() {
        return this.negotiatedMaxServOutstandingCalling;
    }

    public void setNegotiatedMaxServOutstandingCalling(Integer16 negotiatedMaxServOutstandingCalling) {
        this.negotiatedMaxServOutstandingCalling = negotiatedMaxServOutstandingCalling;
    }

    public Integer16 getNegotiatedMaxServOutstandingCalled() {
        return this.negotiatedMaxServOutstandingCalled;
    }

    public void setNegotiatedMaxServOutstandingCalled(Integer16 negotiatedMaxServOutstandingCalled) {
        this.negotiatedMaxServOutstandingCalled = negotiatedMaxServOutstandingCalled;
    }

    public Integer8 getNegotiatedDataStructureNestingLevel() {
        return this.negotiatedDataStructureNestingLevel;
    }

    public void setNegotiatedDataStructureNestingLevel(Integer8 negotiatedDataStructureNestingLevel) {
        this.negotiatedDataStructureNestingLevel = negotiatedDataStructureNestingLevel;
    }

    public InitResponseDetail getInitResponseDetail() {
        return this.initResponseDetail;
    }

    public void setInitResponseDetail(InitResponseDetail initResponseDetail) {
        this.initResponseDetail = initResponseDetail;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.initResponseDetail.encode(reverseOS, false);
        reverseOS.write(164);
        ++codeLength;
        if (this.negotiatedDataStructureNestingLevel != null) {
            codeLength += this.negotiatedDataStructureNestingLevel.encode(reverseOS, false);
            reverseOS.write(131);
            ++codeLength;
        }
        codeLength += this.negotiatedMaxServOutstandingCalled.encode(reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        codeLength += this.negotiatedMaxServOutstandingCalling.encode(reverseOS, false);
        reverseOS.write(129);
        ++codeLength;
        if (this.localDetailCalled != null) {
            codeLength += this.localDetailCalled.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.localDetailCalled = new Integer32();
            vByteCount += this.localDetailCalled.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 1)) {
            this.negotiatedMaxServOutstandingCalling = new Integer16();
            vByteCount += this.negotiatedMaxServOutstandingCalling.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 2)) {
            this.negotiatedMaxServOutstandingCalled = new Integer16();
            vByteCount += this.negotiatedMaxServOutstandingCalled.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 3)) {
            this.negotiatedDataStructureNestingLevel = new Integer8();
            vByteCount += this.negotiatedDataStructureNestingLevel.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 4)) {
            this.initResponseDetail = new InitResponseDetail();
            if (lengthVal >= 0 && (vByteCount += this.initResponseDetail.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.localDetailCalled != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("localDetailCalled: ").append((Object)this.localDetailCalled);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.negotiatedMaxServOutstandingCalling != null) {
            sb.append("negotiatedMaxServOutstandingCalling: ").append((Object)this.negotiatedMaxServOutstandingCalling);
        } else {
            sb.append("negotiatedMaxServOutstandingCalling: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.negotiatedMaxServOutstandingCalled != null) {
            sb.append("negotiatedMaxServOutstandingCalled: ").append((Object)this.negotiatedMaxServOutstandingCalled);
        } else {
            sb.append("negotiatedMaxServOutstandingCalled: <empty-required-field>");
        }
        if (this.negotiatedDataStructureNestingLevel != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("negotiatedDataStructureNestingLevel: ").append((Object)this.negotiatedDataStructureNestingLevel);
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.initResponseDetail != null) {
            sb.append("initResponseDetail: ");
            this.initResponseDetail.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("initResponseDetail: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class InitResponseDetail
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Integer16 negotiatedVersionNumber = null;
        private ParameterSupportOptions negotiatedParameterCBB = null;
        private ServiceSupportOptions servicesSupportedCalled = null;

        public InitResponseDetail() {
        }

        public InitResponseDetail(byte[] code) {
            this.code = code;
        }

        public Integer16 getNegotiatedVersionNumber() {
            return this.negotiatedVersionNumber;
        }

        public void setNegotiatedVersionNumber(Integer16 negotiatedVersionNumber) {
            this.negotiatedVersionNumber = negotiatedVersionNumber;
        }

        public ParameterSupportOptions getNegotiatedParameterCBB() {
            return this.negotiatedParameterCBB;
        }

        public void setNegotiatedParameterCBB(ParameterSupportOptions negotiatedParameterCBB) {
            this.negotiatedParameterCBB = negotiatedParameterCBB;
        }

        public ServiceSupportOptions getServicesSupportedCalled() {
            return this.servicesSupportedCalled;
        }

        public void setServicesSupportedCalled(ServiceSupportOptions servicesSupportedCalled) {
            this.servicesSupportedCalled = servicesSupportedCalled;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.servicesSupportedCalled.encode(reverseOS, false);
            reverseOS.write(130);
            ++codeLength;
            codeLength += this.negotiatedParameterCBB.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
            codeLength += this.negotiatedVersionNumber.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);
            if (berTag.equals(128, 0, 0)) {
                this.negotiatedVersionNumber = new Integer16();
                vByteCount += this.negotiatedVersionNumber.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals(128, 0, 1)) {
                this.negotiatedParameterCBB = new ParameterSupportOptions();
                vByteCount += this.negotiatedParameterCBB.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals(128, 0, 2)) {
                this.servicesSupportedCalled = new ServiceSupportOptions();
                if (lengthVal >= 0 && (vByteCount += this.servicesSupportedCalled.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.negotiatedVersionNumber != null) {
                sb.append("negotiatedVersionNumber: ").append((Object)this.negotiatedVersionNumber);
            } else {
                sb.append("negotiatedVersionNumber: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.negotiatedParameterCBB != null) {
                sb.append("negotiatedParameterCBB: ").append((Object)this.negotiatedParameterCBB);
            } else {
                sb.append("negotiatedParameterCBB: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.servicesSupportedCalled != null) {
                sb.append("servicesSupportedCalled: ").append((Object)this.servicesSupportedCalled);
            } else {
                sb.append("servicesSupportedCalled: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

