/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.Integer16;
import com.beanit.iec61850bean.internal.mms.asn1.Integer32;
import com.beanit.iec61850bean.internal.mms.asn1.Integer8;
import com.beanit.iec61850bean.internal.mms.asn1.ParameterSupportOptions;
import com.beanit.iec61850bean.internal.mms.asn1.ServiceSupportOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class InitiateRequestPDU
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private Integer32 localDetailCalling = null;
    private Integer16 proposedMaxServOutstandingCalling = null;
    private Integer16 proposedMaxServOutstandingCalled = null;
    private Integer8 proposedDataStructureNestingLevel = null;
    private InitRequestDetail initRequestDetail = null;

    public InitiateRequestPDU() {
    }

    public InitiateRequestPDU(byte[] code) {
        this.code = code;
    }

    public Integer32 getLocalDetailCalling() {
        return this.localDetailCalling;
    }

    public void setLocalDetailCalling(Integer32 localDetailCalling) {
        this.localDetailCalling = localDetailCalling;
    }

    public Integer16 getProposedMaxServOutstandingCalling() {
        return this.proposedMaxServOutstandingCalling;
    }

    public void setProposedMaxServOutstandingCalling(Integer16 proposedMaxServOutstandingCalling) {
        this.proposedMaxServOutstandingCalling = proposedMaxServOutstandingCalling;
    }

    public Integer16 getProposedMaxServOutstandingCalled() {
        return this.proposedMaxServOutstandingCalled;
    }

    public void setProposedMaxServOutstandingCalled(Integer16 proposedMaxServOutstandingCalled) {
        this.proposedMaxServOutstandingCalled = proposedMaxServOutstandingCalled;
    }

    public Integer8 getProposedDataStructureNestingLevel() {
        return this.proposedDataStructureNestingLevel;
    }

    public void setProposedDataStructureNestingLevel(Integer8 proposedDataStructureNestingLevel) {
        this.proposedDataStructureNestingLevel = proposedDataStructureNestingLevel;
    }

    public InitRequestDetail getInitRequestDetail() {
        return this.initRequestDetail;
    }

    public void setInitRequestDetail(InitRequestDetail initRequestDetail) {
        this.initRequestDetail = initRequestDetail;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.initRequestDetail.encode(reverseOS, false);
        reverseOS.write(164);
        ++codeLength;
        if (this.proposedDataStructureNestingLevel != null) {
            codeLength += this.proposedDataStructureNestingLevel.encode(reverseOS, false);
            reverseOS.write(131);
            ++codeLength;
        }
        codeLength += this.proposedMaxServOutstandingCalled.encode(reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        codeLength += this.proposedMaxServOutstandingCalling.encode(reverseOS, false);
        reverseOS.write(129);
        ++codeLength;
        if (this.localDetailCalling != null) {
            codeLength += this.localDetailCalling.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.localDetailCalling = new Integer32();
            vByteCount += this.localDetailCalling.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 1)) {
            this.proposedMaxServOutstandingCalling = new Integer16();
            vByteCount += this.proposedMaxServOutstandingCalling.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 2)) {
            this.proposedMaxServOutstandingCalled = new Integer16();
            vByteCount += this.proposedMaxServOutstandingCalled.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 3)) {
            this.proposedDataStructureNestingLevel = new Integer8();
            vByteCount += this.proposedDataStructureNestingLevel.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 4)) {
            this.initRequestDetail = new InitRequestDetail();
            if (lengthVal >= 0 && (vByteCount += this.initRequestDetail.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.localDetailCalling != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("localDetailCalling: ").append((Object)this.localDetailCalling);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.proposedMaxServOutstandingCalling != null) {
            sb.append("proposedMaxServOutstandingCalling: ").append((Object)this.proposedMaxServOutstandingCalling);
        } else {
            sb.append("proposedMaxServOutstandingCalling: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.proposedMaxServOutstandingCalled != null) {
            sb.append("proposedMaxServOutstandingCalled: ").append((Object)this.proposedMaxServOutstandingCalled);
        } else {
            sb.append("proposedMaxServOutstandingCalled: <empty-required-field>");
        }
        if (this.proposedDataStructureNestingLevel != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("proposedDataStructureNestingLevel: ").append((Object)this.proposedDataStructureNestingLevel);
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.initRequestDetail != null) {
            sb.append("initRequestDetail: ");
            this.initRequestDetail.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("initRequestDetail: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class InitRequestDetail
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Integer16 proposedVersionNumber = null;
        private ParameterSupportOptions proposedParameterCBB = null;
        private ServiceSupportOptions servicesSupportedCalling = null;

        public InitRequestDetail() {
        }

        public InitRequestDetail(byte[] code) {
            this.code = code;
        }

        public Integer16 getProposedVersionNumber() {
            return this.proposedVersionNumber;
        }

        public void setProposedVersionNumber(Integer16 proposedVersionNumber) {
            this.proposedVersionNumber = proposedVersionNumber;
        }

        public ParameterSupportOptions getProposedParameterCBB() {
            return this.proposedParameterCBB;
        }

        public void setProposedParameterCBB(ParameterSupportOptions proposedParameterCBB) {
            this.proposedParameterCBB = proposedParameterCBB;
        }

        public ServiceSupportOptions getServicesSupportedCalling() {
            return this.servicesSupportedCalling;
        }

        public void setServicesSupportedCalling(ServiceSupportOptions servicesSupportedCalling) {
            this.servicesSupportedCalling = servicesSupportedCalling;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.servicesSupportedCalling.encode(reverseOS, false);
            reverseOS.write(130);
            ++codeLength;
            codeLength += this.proposedParameterCBB.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
            codeLength += this.proposedVersionNumber.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);
            if (berTag.equals(128, 0, 0)) {
                this.proposedVersionNumber = new Integer16();
                vByteCount += this.proposedVersionNumber.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals(128, 0, 1)) {
                this.proposedParameterCBB = new ParameterSupportOptions();
                vByteCount += this.proposedParameterCBB.decode(is, false);
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals(128, 0, 2)) {
                this.servicesSupportedCalling = new ServiceSupportOptions();
                if (lengthVal >= 0 && (vByteCount += this.servicesSupportedCalling.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.proposedVersionNumber != null) {
                sb.append("proposedVersionNumber: ").append((Object)this.proposedVersionNumber);
            } else {
                sb.append("proposedVersionNumber: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.proposedParameterCBB != null) {
                sb.append("proposedParameterCBB: ").append((Object)this.proposedParameterCBB);
            } else {
                sb.append("proposedParameterCBB: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.servicesSupportedCalling != null) {
                sb.append("servicesSupportedCalling: ").append((Object)this.servicesSupportedCalling);
            } else {
                sb.append("servicesSupportedCalling: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

