/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerNull;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.Identifier;
import com.beanit.iec61850bean.internal.mms.asn1.ObjectClass;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class GetNameListRequest
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private ObjectClass objectClass = null;
    private ObjectScope objectScope = null;
    private Identifier continueAfter = null;

    public GetNameListRequest() {
    }

    public GetNameListRequest(byte[] code) {
        this.code = code;
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(ObjectClass objectClass) {
        this.objectClass = objectClass;
    }

    public ObjectScope getObjectScope() {
        return this.objectScope;
    }

    public void setObjectScope(ObjectScope objectScope) {
        this.objectScope = objectScope;
    }

    public Identifier getContinueAfter() {
        return this.continueAfter;
    }

    public void setContinueAfter(Identifier continueAfter) {
        this.continueAfter = continueAfter;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.continueAfter != null) {
            codeLength += this.continueAfter.encode(reverseOS, false);
            reverseOS.write(130);
            ++codeLength;
        }
        int sublength = this.objectScope.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(161);
        ++codeLength;
        sublength = this.objectClass.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(160);
        ++codeLength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            vByteCount += length.decode(is);
            this.objectClass = new ObjectClass();
            vByteCount += this.objectClass.decode(is, null);
            vByteCount += length.readEocIfIndefinite(is);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 32, 1)) {
            vByteCount += length.decode(is);
            this.objectScope = new ObjectScope();
            vByteCount += this.objectScope.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 0, 2)) {
            this.continueAfter = new Identifier();
            if (lengthVal >= 0 && (vByteCount += this.continueAfter.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.objectClass != null) {
            sb.append("objectClass: ");
            this.objectClass.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("objectClass: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.objectScope != null) {
            sb.append("objectScope: ");
            this.objectScope.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("objectScope: <empty-required-field>");
        }
        if (this.continueAfter != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("continueAfter: ").append((Object)this.continueAfter);
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class ObjectScope
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private BerNull vmdSpecific = null;
        private Identifier domainSpecific = null;
        private BerNull aaSpecific = null;

        public ObjectScope() {
        }

        public ObjectScope(byte[] code) {
            this.code = code;
        }

        public BerNull getVmdSpecific() {
            return this.vmdSpecific;
        }

        public void setVmdSpecific(BerNull vmdSpecific) {
            this.vmdSpecific = vmdSpecific;
        }

        public Identifier getDomainSpecific() {
            return this.domainSpecific;
        }

        public void setDomainSpecific(Identifier domainSpecific) {
            this.domainSpecific = domainSpecific;
        }

        public BerNull getAaSpecific() {
            return this.aaSpecific;
        }

        public void setAaSpecific(BerNull aaSpecific) {
            this.aaSpecific = aaSpecific;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                return this.code.length;
            }
            int codeLength = 0;
            if (this.aaSpecific != null) {
                codeLength += this.aaSpecific.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.domainSpecific != null) {
                codeLength += this.domainSpecific.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.vmdSpecific != null) {
                codeLength += this.vmdSpecific.encode(reverseOS, false);
                reverseOS.write(128);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            boolean tagWasPassed;
            int tlvByteCount = 0;
            boolean bl = tagWasPassed = berTag != null;
            if (berTag == null) {
                berTag = new BerTag();
                tlvByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 0)) {
                this.vmdSpecific = new BerNull();
                return tlvByteCount += this.vmdSpecific.decode(is, false);
            }
            if (berTag.equals(128, 0, 1)) {
                this.domainSpecific = new Identifier();
                return tlvByteCount += this.domainSpecific.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.aaSpecific = new BerNull();
                return tlvByteCount += this.aaSpecific.decode(is, false);
            }
            if (tagWasPassed) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.vmdSpecific != null) {
                sb.append("vmdSpecific: ").append(this.vmdSpecific);
                return;
            }
            if (this.domainSpecific != null) {
                sb.append("domainSpecific: ").append((Object)this.domainSpecific);
                return;
            }
            if (this.aaSpecific != null) {
                sb.append("aaSpecific: ").append(this.aaSpecific);
                return;
            }
            sb.append("<none>");
        }
    }
}

