/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.FileName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class FileDirectoryRequest
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private FileName fileSpecification = null;
    private FileName continueAfter = null;

    public FileDirectoryRequest() {
    }

    public FileDirectoryRequest(byte[] code) {
        this.code = code;
    }

    public FileName getFileSpecification() {
        return this.fileSpecification;
    }

    public void setFileSpecification(FileName fileSpecification) {
        this.fileSpecification = fileSpecification;
    }

    public FileName getContinueAfter() {
        return this.continueAfter;
    }

    public void setContinueAfter(FileName continueAfter) {
        this.continueAfter = continueAfter;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.continueAfter != null) {
            codeLength += this.continueAfter.encode(reverseOS, false);
            reverseOS.write(161);
            ++codeLength;
        }
        if (this.fileSpecification != null) {
            codeLength += this.fileSpecification.encode(reverseOS, false);
            reverseOS.write(160);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        if (lengthVal == 0) {
            return tlByteCount;
        }
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            this.fileSpecification = new FileName();
            if (lengthVal >= 0 && (vByteCount += this.fileSpecification.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            this.continueAfter = new FileName();
            if (lengthVal >= 0 && (vByteCount += this.continueAfter.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.fileSpecification != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("fileSpecification: ");
            this.fileSpecification.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        if (this.continueAfter != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("continueAfter: ");
            this.continueAfter.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

