/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerBitString;
import com.beanit.asn1bean.ber.types.BerInteger;
import com.beanit.asn1bean.ber.types.BerOctetString;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.asn1bean.ber.types.string.BerVisibleString;
import com.beanit.iec61850bean.internal.BerBoolean;
import com.beanit.iec61850bean.internal.mms.asn1.FloatingPoint;
import com.beanit.iec61850bean.internal.mms.asn1.MMSString;
import com.beanit.iec61850bean.internal.mms.asn1.TimeOfDay;
import com.beanit.iec61850bean.internal.mms.asn1.UtcTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Data
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private Array array = null;
    private Structure structure = null;
    private BerBoolean bool = null;
    private BerBitString bitString = null;
    private BerInteger integer = null;
    private BerInteger unsigned = null;
    private FloatingPoint floatingPoint = null;
    private BerOctetString octetString = null;
    private BerVisibleString visibleString = null;
    private TimeOfDay binaryTime = null;
    private MMSString mMSString = null;
    private UtcTime utcTime = null;

    public Data() {
    }

    public Data(byte[] code) {
        this.code = code;
    }

    public Array getArray() {
        return this.array;
    }

    public void setArray(Array array) {
        this.array = array;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    public BerBoolean getBool() {
        return this.bool;
    }

    public void setBool(BerBoolean bool) {
        this.bool = bool;
    }

    public BerBitString getBitString() {
        return this.bitString;
    }

    public void setBitString(BerBitString bitString) {
        this.bitString = bitString;
    }

    public BerInteger getInteger() {
        return this.integer;
    }

    public void setInteger(BerInteger integer) {
        this.integer = integer;
    }

    public BerInteger getUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(BerInteger unsigned) {
        this.unsigned = unsigned;
    }

    public FloatingPoint getFloatingPoint() {
        return this.floatingPoint;
    }

    public void setFloatingPoint(FloatingPoint floatingPoint) {
        this.floatingPoint = floatingPoint;
    }

    public BerOctetString getOctetString() {
        return this.octetString;
    }

    public void setOctetString(BerOctetString octetString) {
        this.octetString = octetString;
    }

    public BerVisibleString getVisibleString() {
        return this.visibleString;
    }

    public void setVisibleString(BerVisibleString visibleString) {
        this.visibleString = visibleString;
    }

    public TimeOfDay getBinaryTime() {
        return this.binaryTime;
    }

    public void setBinaryTime(TimeOfDay binaryTime) {
        this.binaryTime = binaryTime;
    }

    public MMSString getMMSString() {
        return this.mMSString;
    }

    public void setMMSString(MMSString mMSString) {
        this.mMSString = mMSString;
    }

    public UtcTime getUtcTime() {
        return this.utcTime;
    }

    public void setUtcTime(UtcTime utcTime) {
        this.utcTime = utcTime;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.utcTime != null) {
            codeLength += this.utcTime.encode(reverseOS, false);
            reverseOS.write(145);
            return ++codeLength;
        }
        if (this.mMSString != null) {
            codeLength += this.mMSString.encode(reverseOS, false);
            reverseOS.write(144);
            return ++codeLength;
        }
        if (this.binaryTime != null) {
            codeLength += this.binaryTime.encode(reverseOS, false);
            reverseOS.write(140);
            return ++codeLength;
        }
        if (this.visibleString != null) {
            codeLength += this.visibleString.encode(reverseOS, false);
            reverseOS.write(138);
            return ++codeLength;
        }
        if (this.octetString != null) {
            codeLength += this.octetString.encode(reverseOS, false);
            reverseOS.write(137);
            return ++codeLength;
        }
        if (this.floatingPoint != null) {
            codeLength += this.floatingPoint.encode(reverseOS, false);
            reverseOS.write(135);
            return ++codeLength;
        }
        if (this.unsigned != null) {
            codeLength += this.unsigned.encode(reverseOS, false);
            reverseOS.write(134);
            return ++codeLength;
        }
        if (this.integer != null) {
            codeLength += this.integer.encode(reverseOS, false);
            reverseOS.write(133);
            return ++codeLength;
        }
        if (this.bitString != null) {
            codeLength += this.bitString.encode(reverseOS, false);
            reverseOS.write(132);
            return ++codeLength;
        }
        if (this.bool != null) {
            codeLength += this.bool.encode(reverseOS, false);
            reverseOS.write(131);
            return ++codeLength;
        }
        if (this.structure != null) {
            codeLength += this.structure.encode(reverseOS, false);
            reverseOS.write(162);
            return ++codeLength;
        }
        if (this.array != null) {
            codeLength += this.array.encode(reverseOS, false);
            reverseOS.write(161);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            this.array = new Array();
            return tlvByteCount += this.array.decode(is, false);
        }
        if (berTag.equals(128, 32, 2)) {
            this.structure = new Structure();
            return tlvByteCount += this.structure.decode(is, false);
        }
        if (berTag.equals(128, 0, 3)) {
            this.bool = new BerBoolean();
            return tlvByteCount += this.bool.decode(is, false);
        }
        if (berTag.equals(128, 0, 4)) {
            this.bitString = new BerBitString();
            return tlvByteCount += this.bitString.decode(is, false);
        }
        if (berTag.equals(128, 0, 5)) {
            this.integer = new BerInteger();
            return tlvByteCount += this.integer.decode(is, false);
        }
        if (berTag.equals(128, 0, 6)) {
            this.unsigned = new BerInteger();
            return tlvByteCount += this.unsigned.decode(is, false);
        }
        if (berTag.equals(128, 0, 7)) {
            this.floatingPoint = new FloatingPoint();
            return tlvByteCount += this.floatingPoint.decode(is, false);
        }
        if (berTag.equals(128, 0, 9)) {
            this.octetString = new BerOctetString();
            return tlvByteCount += this.octetString.decode(is, false);
        }
        if (berTag.equals(128, 0, 10)) {
            this.visibleString = new BerVisibleString();
            return tlvByteCount += this.visibleString.decode(is, false);
        }
        if (berTag.equals(128, 0, 12)) {
            this.binaryTime = new TimeOfDay();
            return tlvByteCount += this.binaryTime.decode(is, false);
        }
        if (berTag.equals(128, 0, 16)) {
            this.mMSString = new MMSString();
            return tlvByteCount += this.mMSString.decode(is, false);
        }
        if (berTag.equals(128, 0, 17)) {
            this.utcTime = new UtcTime();
            return tlvByteCount += this.utcTime.decode(is, false);
        }
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.array != null) {
            sb.append("array: ");
            this.array.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.structure != null) {
            sb.append("structure: ");
            this.structure.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.bool != null) {
            sb.append("bool: ").append(this.bool);
            return;
        }
        if (this.bitString != null) {
            sb.append("bitString: ").append(this.bitString);
            return;
        }
        if (this.integer != null) {
            sb.append("integer: ").append(this.integer);
            return;
        }
        if (this.unsigned != null) {
            sb.append("unsigned: ").append(this.unsigned);
            return;
        }
        if (this.floatingPoint != null) {
            sb.append("floatingPoint: ").append((Object)this.floatingPoint);
            return;
        }
        if (this.octetString != null) {
            sb.append("octetString: ").append(this.octetString);
            return;
        }
        if (this.visibleString != null) {
            sb.append("visibleString: ").append(this.visibleString);
            return;
        }
        if (this.binaryTime != null) {
            sb.append("binaryTime: ").append((Object)this.binaryTime);
            return;
        }
        if (this.mMSString != null) {
            sb.append("mMSString: ").append((Object)this.mMSString);
            return;
        }
        if (this.utcTime != null) {
            sb.append("utcTime: ").append((Object)this.utcTime);
            return;
        }
        sb.append("<none>");
    }

    public static class Structure
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private List<Data> seqOf = null;

        public Structure() {
            this.seqOf = new ArrayList<Data>();
        }

        public Structure(byte[] code) {
            this.code = code;
        }

        public List<Data> getData() {
            if (this.seqOf == null) {
                this.seqOf = new ArrayList<Data>();
            }
            return this.seqOf;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                codeLength += this.seqOf.get(i).encode(reverseOS);
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            while (vByteCount < lengthVal || lengthVal < 0) {
                vByteCount += berTag.decode(is);
                if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                    vByteCount += BerLength.readEocByte((InputStream)is);
                    break;
                }
                Data element = new Data();
                int numDecodedBytes = element.decode(is, berTag);
                if (numDecodedBytes == 0) {
                    throw new IOException("Tag did not match");
                }
                vByteCount += numDecodedBytes;
                this.seqOf.add(element);
            }
            if (lengthVal >= 0 && vByteCount != lengthVal) {
                throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + lengthVal + " but has " + vByteCount);
            }
            return tlByteCount + vByteCount;
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.seqOf == null) {
                sb.append("null");
            } else {
                Iterator<Data> it = this.seqOf.iterator();
                if (it.hasNext()) {
                    it.next().appendAsString(sb, indentLevel + 1);
                    while (it.hasNext()) {
                        sb.append(",\n");
                        for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                            sb.append("\t");
                        }
                        it.next().appendAsString(sb, indentLevel + 1);
                    }
                }
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }

    public static class Array
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private List<Data> seqOf = null;

        public Array() {
            this.seqOf = new ArrayList<Data>();
        }

        public Array(byte[] code) {
            this.code = code;
        }

        public List<Data> getData() {
            if (this.seqOf == null) {
                this.seqOf = new ArrayList<Data>();
            }
            return this.seqOf;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                codeLength += this.seqOf.get(i).encode(reverseOS);
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            while (vByteCount < lengthVal || lengthVal < 0) {
                vByteCount += berTag.decode(is);
                if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                    vByteCount += BerLength.readEocByte((InputStream)is);
                    break;
                }
                Data element = new Data();
                int numDecodedBytes = element.decode(is, berTag);
                if (numDecodedBytes == 0) {
                    throw new IOException("Tag did not match");
                }
                vByteCount += numDecodedBytes;
                this.seqOf.add(element);
            }
            if (lengthVal >= 0 && vByteCount != lengthVal) {
                throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + lengthVal + " but has " + vByteCount);
            }
            return tlByteCount + vByteCount;
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.seqOf == null) {
                sb.append("null");
            } else {
                Iterator<Data> it = this.seqOf.iterator();
                if (it.hasNext()) {
                    it.next().appendAsString(sb, indentLevel + 1);
                    while (it.hasNext()) {
                        sb.append(",\n");
                        for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                            sb.append("\t");
                        }
                        it.next().appendAsString(sb, indentLevel + 1);
                    }
                }
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

