/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerNull;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.AlternateAccess;
import com.beanit.iec61850bean.internal.mms.asn1.BasicIdentifier;
import com.beanit.iec61850bean.internal.mms.asn1.Unsigned32;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AlternateAccessSelection
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private SelectAlternateAccess selectAlternateAccess = null;
    private SelectAccess selectAccess = null;

    public AlternateAccessSelection() {
    }

    public AlternateAccessSelection(byte[] code) {
        this.code = code;
    }

    public SelectAlternateAccess getSelectAlternateAccess() {
        return this.selectAlternateAccess;
    }

    public void setSelectAlternateAccess(SelectAlternateAccess selectAlternateAccess) {
        this.selectAlternateAccess = selectAlternateAccess;
    }

    public SelectAccess getSelectAccess() {
        return this.selectAccess;
    }

    public void setSelectAccess(SelectAccess selectAccess) {
        this.selectAccess = selectAccess;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.selectAccess != null) {
            return codeLength += this.selectAccess.encode(reverseOS);
        }
        if (this.selectAlternateAccess != null) {
            codeLength += this.selectAlternateAccess.encode(reverseOS, false);
            reverseOS.write(160);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 0)) {
            this.selectAlternateAccess = new SelectAlternateAccess();
            return tlvByteCount += this.selectAlternateAccess.decode(is, false);
        }
        this.selectAccess = new SelectAccess();
        int numDecodedBytes = this.selectAccess.decode(is, berTag);
        if (numDecodedBytes != 0) {
            return tlvByteCount + numDecodedBytes;
        }
        this.selectAccess = null;
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.selectAlternateAccess != null) {
            sb.append("selectAlternateAccess: ");
            this.selectAlternateAccess.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.selectAccess != null) {
            sb.append("selectAccess: ");
            this.selectAccess.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }

    public static class SelectAccess
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private Component component = null;
        private Unsigned32 index = null;
        private IndexRange indexRange = null;
        private BerNull allElements = null;

        public SelectAccess() {
        }

        public SelectAccess(byte[] code) {
            this.code = code;
        }

        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component component) {
            this.component = component;
        }

        public Unsigned32 getIndex() {
            return this.index;
        }

        public void setIndex(Unsigned32 index) {
            this.index = index;
        }

        public IndexRange getIndexRange() {
            return this.indexRange;
        }

        public void setIndexRange(IndexRange indexRange) {
            this.indexRange = indexRange;
        }

        public BerNull getAllElements() {
            return this.allElements;
        }

        public void setAllElements(BerNull allElements) {
            this.allElements = allElements;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                return this.code.length;
            }
            int codeLength = 0;
            if (this.allElements != null) {
                codeLength += this.allElements.encode(reverseOS, false);
                reverseOS.write(132);
                return ++codeLength;
            }
            if (this.indexRange != null) {
                codeLength += this.indexRange.encode(reverseOS, false);
                reverseOS.write(163);
                return ++codeLength;
            }
            if (this.index != null) {
                codeLength += this.index.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.component != null) {
                int sublength = this.component.encode(reverseOS);
                codeLength += sublength;
                codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
                reverseOS.write(161);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            boolean tagWasPassed;
            int tlvByteCount = 0;
            boolean bl = tagWasPassed = berTag != null;
            if (berTag == null) {
                berTag = new BerTag();
                tlvByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 1)) {
                BerLength length = new BerLength();
                tlvByteCount += length.decode(is);
                this.component = new Component();
                tlvByteCount += this.component.decode(is, null);
                return tlvByteCount += length.readEocIfIndefinite(is);
            }
            if (berTag.equals(128, 0, 2)) {
                this.index = new Unsigned32();
                return tlvByteCount += this.index.decode(is, false);
            }
            if (berTag.equals(128, 32, 3)) {
                this.indexRange = new IndexRange();
                return tlvByteCount += this.indexRange.decode(is, false);
            }
            if (berTag.equals(128, 0, 4)) {
                this.allElements = new BerNull();
                return tlvByteCount += this.allElements.decode(is, false);
            }
            if (tagWasPassed) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.component != null) {
                sb.append("component: ");
                this.component.appendAsString(sb, indentLevel + 1);
                return;
            }
            if (this.index != null) {
                sb.append("index: ").append((Object)this.index);
                return;
            }
            if (this.indexRange != null) {
                sb.append("indexRange: ");
                this.indexRange.appendAsString(sb, indentLevel + 1);
                return;
            }
            if (this.allElements != null) {
                sb.append("allElements: ").append(this.allElements);
                return;
            }
            sb.append("<none>");
        }

        public static class IndexRange
        implements BerType,
        Serializable {
            public static final BerTag tag = new BerTag(0, 32, 16);
            private static final long serialVersionUID = 1L;
            private byte[] code = null;
            private Unsigned32 lowIndex = null;
            private Unsigned32 numberOfElements = null;

            public IndexRange() {
            }

            public IndexRange(byte[] code) {
                this.code = code;
            }

            public Unsigned32 getLowIndex() {
                return this.lowIndex;
            }

            public void setLowIndex(Unsigned32 lowIndex) {
                this.lowIndex = lowIndex;
            }

            public Unsigned32 getNumberOfElements() {
                return this.numberOfElements;
            }

            public void setNumberOfElements(Unsigned32 numberOfElements) {
                this.numberOfElements = numberOfElements;
            }

            public int encode(OutputStream reverseOS) throws IOException {
                return this.encode(reverseOS, true);
            }

            public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                if (this.code != null) {
                    reverseOS.write(this.code);
                    if (withTag) {
                        return tag.encode(reverseOS) + this.code.length;
                    }
                    return this.code.length;
                }
                int codeLength = 0;
                codeLength += this.numberOfElements.encode(reverseOS, false);
                reverseOS.write(129);
                ++codeLength;
                codeLength += this.lowIndex.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
                codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
                if (withTag) {
                    codeLength += tag.encode(reverseOS);
                }
                return codeLength;
            }

            public int decode(InputStream is) throws IOException {
                return this.decode(is, true);
            }

            public int decode(InputStream is, boolean withTag) throws IOException {
                int tlByteCount = 0;
                int vByteCount = 0;
                BerTag berTag = new BerTag();
                if (withTag) {
                    tlByteCount += tag.decodeAndCheck(is);
                }
                BerLength length = new BerLength();
                tlByteCount += length.decode(is);
                int lengthVal = length.val;
                vByteCount += berTag.decode(is);
                if (berTag.equals(128, 0, 0)) {
                    this.lowIndex = new Unsigned32();
                    vByteCount += this.lowIndex.decode(is, false);
                    vByteCount += berTag.decode(is);
                } else {
                    throw new IOException("Tag does not match mandatory sequence component.");
                }
                if (berTag.equals(128, 0, 1)) {
                    this.numberOfElements = new Unsigned32();
                    if (lengthVal >= 0 && (vByteCount += this.numberOfElements.decode(is, false)) == lengthVal) {
                        return tlByteCount + vByteCount;
                    }
                    vByteCount += berTag.decode(is);
                } else {
                    throw new IOException("Tag does not match mandatory sequence component.");
                }
                if (lengthVal < 0) {
                    if (!berTag.equals(0, 0, 0)) {
                        throw new IOException("Decoded sequence has wrong end of contents octets");
                    }
                    return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
                }
                throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode((OutputStream)reverseOS, false);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                int i;
                sb.append("{");
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.lowIndex != null) {
                    sb.append("lowIndex: ").append((Object)this.lowIndex);
                } else {
                    sb.append("lowIndex: <empty-required-field>");
                }
                sb.append(",\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.numberOfElements != null) {
                    sb.append("numberOfElements: ").append((Object)this.numberOfElements);
                } else {
                    sb.append("numberOfElements: <empty-required-field>");
                }
                sb.append("\n");
                for (i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
                sb.append("}");
            }
        }

        public static class Component
        implements BerType,
        Serializable {
            private static final long serialVersionUID = 1L;
            private byte[] code = null;
            private BasicIdentifier basic = null;

            public Component() {
            }

            public Component(byte[] code) {
                this.code = code;
            }

            public BasicIdentifier getBasic() {
                return this.basic;
            }

            public void setBasic(BasicIdentifier basic) {
                this.basic = basic;
            }

            public int encode(OutputStream reverseOS) throws IOException {
                if (this.code != null) {
                    reverseOS.write(this.code);
                    return this.code.length;
                }
                int codeLength = 0;
                if (this.basic != null) {
                    return codeLength += this.basic.encode(reverseOS, true);
                }
                throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
            }

            public int decode(InputStream is) throws IOException {
                return this.decode(is, null);
            }

            public int decode(InputStream is, BerTag berTag) throws IOException {
                boolean tagWasPassed;
                int tlvByteCount = 0;
                boolean bl = tagWasPassed = berTag != null;
                if (berTag == null) {
                    berTag = new BerTag();
                    tlvByteCount += berTag.decode(is);
                }
                if (berTag.equals((Object)BasicIdentifier.tag)) {
                    this.basic = new BasicIdentifier();
                    return tlvByteCount += this.basic.decode(is, false);
                }
                if (tagWasPassed) {
                    return 0;
                }
                throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode((OutputStream)reverseOS);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                if (this.basic != null) {
                    sb.append("basic: ").append((Object)this.basic);
                    return;
                }
                sb.append("<none>");
            }
        }
    }

    public static class SelectAlternateAccess
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private AccessSelection accessSelection = null;
        private AlternateAccess alternateAccess = null;

        public SelectAlternateAccess() {
        }

        public SelectAlternateAccess(byte[] code) {
            this.code = code;
        }

        public AccessSelection getAccessSelection() {
            return this.accessSelection;
        }

        public void setAccessSelection(AccessSelection accessSelection) {
            this.accessSelection = accessSelection;
        }

        public AlternateAccess getAlternateAccess() {
            return this.alternateAccess;
        }

        public void setAlternateAccess(AlternateAccess alternateAccess) {
            this.alternateAccess = alternateAccess;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.alternateAccess.encode(reverseOS, true);
            codeLength += this.accessSelection.encode(reverseOS);
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            vByteCount += berTag.decode(is);
            this.accessSelection = new AccessSelection();
            int numDecodedBytes = this.accessSelection.decode(is, berTag);
            if (numDecodedBytes != 0) {
                vByteCount += numDecodedBytes;
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (berTag.equals((Object)AlternateAccess.tag)) {
                this.alternateAccess = new AlternateAccess();
                if (lengthVal >= 0 && (vByteCount += this.alternateAccess.decode(is, false)) == lengthVal) {
                    return tlByteCount + vByteCount;
                }
                vByteCount += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match mandatory sequence component.");
            }
            if (lengthVal < 0) {
                if (!berTag.equals(0, 0, 0)) {
                    throw new IOException("Decoded sequence has wrong end of contents octets");
                }
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.accessSelection != null) {
                sb.append("accessSelection: ");
                this.accessSelection.appendAsString(sb, indentLevel + 1);
            } else {
                sb.append("accessSelection: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.alternateAccess != null) {
                sb.append("alternateAccess: ");
                this.alternateAccess.appendAsString(sb, indentLevel + 1);
            } else {
                sb.append("alternateAccess: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }

        public static class AccessSelection
        implements BerType,
        Serializable {
            private static final long serialVersionUID = 1L;
            private byte[] code = null;
            private Component component = null;
            private Unsigned32 index = null;
            private IndexRange indexRange = null;
            private BerNull allElements = null;

            public AccessSelection() {
            }

            public AccessSelection(byte[] code) {
                this.code = code;
            }

            public Component getComponent() {
                return this.component;
            }

            public void setComponent(Component component) {
                this.component = component;
            }

            public Unsigned32 getIndex() {
                return this.index;
            }

            public void setIndex(Unsigned32 index) {
                this.index = index;
            }

            public IndexRange getIndexRange() {
                return this.indexRange;
            }

            public void setIndexRange(IndexRange indexRange) {
                this.indexRange = indexRange;
            }

            public BerNull getAllElements() {
                return this.allElements;
            }

            public void setAllElements(BerNull allElements) {
                this.allElements = allElements;
            }

            public int encode(OutputStream reverseOS) throws IOException {
                if (this.code != null) {
                    reverseOS.write(this.code);
                    return this.code.length;
                }
                int codeLength = 0;
                if (this.allElements != null) {
                    codeLength += this.allElements.encode(reverseOS, false);
                    reverseOS.write(131);
                    return ++codeLength;
                }
                if (this.indexRange != null) {
                    codeLength += this.indexRange.encode(reverseOS, false);
                    reverseOS.write(162);
                    return ++codeLength;
                }
                if (this.index != null) {
                    codeLength += this.index.encode(reverseOS, false);
                    reverseOS.write(129);
                    return ++codeLength;
                }
                if (this.component != null) {
                    int sublength = this.component.encode(reverseOS);
                    codeLength += sublength;
                    codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
                    reverseOS.write(160);
                    return ++codeLength;
                }
                throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
            }

            public int decode(InputStream is) throws IOException {
                return this.decode(is, null);
            }

            public int decode(InputStream is, BerTag berTag) throws IOException {
                boolean tagWasPassed;
                int tlvByteCount = 0;
                boolean bl = tagWasPassed = berTag != null;
                if (berTag == null) {
                    berTag = new BerTag();
                    tlvByteCount += berTag.decode(is);
                }
                if (berTag.equals(128, 32, 0)) {
                    BerLength length = new BerLength();
                    tlvByteCount += length.decode(is);
                    this.component = new Component();
                    tlvByteCount += this.component.decode(is, null);
                    return tlvByteCount += length.readEocIfIndefinite(is);
                }
                if (berTag.equals(128, 0, 1)) {
                    this.index = new Unsigned32();
                    return tlvByteCount += this.index.decode(is, false);
                }
                if (berTag.equals(128, 32, 2)) {
                    this.indexRange = new IndexRange();
                    return tlvByteCount += this.indexRange.decode(is, false);
                }
                if (berTag.equals(128, 0, 3)) {
                    this.allElements = new BerNull();
                    return tlvByteCount += this.allElements.decode(is, false);
                }
                if (tagWasPassed) {
                    return 0;
                }
                throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode((OutputStream)reverseOS);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                if (this.component != null) {
                    sb.append("component: ");
                    this.component.appendAsString(sb, indentLevel + 1);
                    return;
                }
                if (this.index != null) {
                    sb.append("index: ").append((Object)this.index);
                    return;
                }
                if (this.indexRange != null) {
                    sb.append("indexRange: ");
                    this.indexRange.appendAsString(sb, indentLevel + 1);
                    return;
                }
                if (this.allElements != null) {
                    sb.append("allElements: ").append(this.allElements);
                    return;
                }
                sb.append("<none>");
            }

            public static class IndexRange
            implements BerType,
            Serializable {
                public static final BerTag tag = new BerTag(0, 32, 16);
                private static final long serialVersionUID = 1L;
                private byte[] code = null;
                private Unsigned32 lowIndex = null;
                private Unsigned32 numberOfElements = null;

                public IndexRange() {
                }

                public IndexRange(byte[] code) {
                    this.code = code;
                }

                public Unsigned32 getLowIndex() {
                    return this.lowIndex;
                }

                public void setLowIndex(Unsigned32 lowIndex) {
                    this.lowIndex = lowIndex;
                }

                public Unsigned32 getNumberOfElements() {
                    return this.numberOfElements;
                }

                public void setNumberOfElements(Unsigned32 numberOfElements) {
                    this.numberOfElements = numberOfElements;
                }

                public int encode(OutputStream reverseOS) throws IOException {
                    return this.encode(reverseOS, true);
                }

                public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                    if (this.code != null) {
                        reverseOS.write(this.code);
                        if (withTag) {
                            return tag.encode(reverseOS) + this.code.length;
                        }
                        return this.code.length;
                    }
                    int codeLength = 0;
                    codeLength += this.numberOfElements.encode(reverseOS, false);
                    reverseOS.write(129);
                    ++codeLength;
                    codeLength += this.lowIndex.encode(reverseOS, false);
                    reverseOS.write(128);
                    ++codeLength;
                    codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
                    if (withTag) {
                        codeLength += tag.encode(reverseOS);
                    }
                    return codeLength;
                }

                public int decode(InputStream is) throws IOException {
                    return this.decode(is, true);
                }

                public int decode(InputStream is, boolean withTag) throws IOException {
                    int tlByteCount = 0;
                    int vByteCount = 0;
                    BerTag berTag = new BerTag();
                    if (withTag) {
                        tlByteCount += tag.decodeAndCheck(is);
                    }
                    BerLength length = new BerLength();
                    tlByteCount += length.decode(is);
                    int lengthVal = length.val;
                    vByteCount += berTag.decode(is);
                    if (berTag.equals(128, 0, 0)) {
                        this.lowIndex = new Unsigned32();
                        vByteCount += this.lowIndex.decode(is, false);
                        vByteCount += berTag.decode(is);
                    } else {
                        throw new IOException("Tag does not match mandatory sequence component.");
                    }
                    if (berTag.equals(128, 0, 1)) {
                        this.numberOfElements = new Unsigned32();
                        if (lengthVal >= 0 && (vByteCount += this.numberOfElements.decode(is, false)) == lengthVal) {
                            return tlByteCount + vByteCount;
                        }
                        vByteCount += berTag.decode(is);
                    } else {
                        throw new IOException("Tag does not match mandatory sequence component.");
                    }
                    if (lengthVal < 0) {
                        if (!berTag.equals(0, 0, 0)) {
                            throw new IOException("Decoded sequence has wrong end of contents octets");
                        }
                        return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
                    }
                    throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
                }

                public void encodeAndSave(int encodingSizeGuess) throws IOException {
                    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                    this.encode((OutputStream)reverseOS, false);
                    this.code = reverseOS.getArray();
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    this.appendAsString(sb, 0);
                    return sb.toString();
                }

                public void appendAsString(StringBuilder sb, int indentLevel) {
                    int i;
                    sb.append("{");
                    sb.append("\n");
                    for (i = 0; i < indentLevel + 1; ++i) {
                        sb.append("\t");
                    }
                    if (this.lowIndex != null) {
                        sb.append("lowIndex: ").append((Object)this.lowIndex);
                    } else {
                        sb.append("lowIndex: <empty-required-field>");
                    }
                    sb.append(",\n");
                    for (i = 0; i < indentLevel + 1; ++i) {
                        sb.append("\t");
                    }
                    if (this.numberOfElements != null) {
                        sb.append("numberOfElements: ").append((Object)this.numberOfElements);
                    } else {
                        sb.append("numberOfElements: <empty-required-field>");
                    }
                    sb.append("\n");
                    for (i = 0; i < indentLevel; ++i) {
                        sb.append("\t");
                    }
                    sb.append("}");
                }
            }

            public static class Component
            implements BerType,
            Serializable {
                private static final long serialVersionUID = 1L;
                private byte[] code = null;
                private BasicIdentifier basic = null;

                public Component() {
                }

                public Component(byte[] code) {
                    this.code = code;
                }

                public BasicIdentifier getBasic() {
                    return this.basic;
                }

                public void setBasic(BasicIdentifier basic) {
                    this.basic = basic;
                }

                public int encode(OutputStream reverseOS) throws IOException {
                    if (this.code != null) {
                        reverseOS.write(this.code);
                        return this.code.length;
                    }
                    int codeLength = 0;
                    if (this.basic != null) {
                        return codeLength += this.basic.encode(reverseOS, true);
                    }
                    throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
                }

                public int decode(InputStream is) throws IOException {
                    return this.decode(is, null);
                }

                public int decode(InputStream is, BerTag berTag) throws IOException {
                    boolean tagWasPassed;
                    int tlvByteCount = 0;
                    boolean bl = tagWasPassed = berTag != null;
                    if (berTag == null) {
                        berTag = new BerTag();
                        tlvByteCount += berTag.decode(is);
                    }
                    if (berTag.equals((Object)BasicIdentifier.tag)) {
                        this.basic = new BasicIdentifier();
                        return tlvByteCount += this.basic.decode(is, false);
                    }
                    if (tagWasPassed) {
                        return 0;
                    }
                    throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
                }

                public void encodeAndSave(int encodingSizeGuess) throws IOException {
                    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                    this.encode((OutputStream)reverseOS);
                    this.code = reverseOS.getArray();
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    this.appendAsString(sb, 0);
                    return sb.toString();
                }

                public void appendAsString(StringBuilder sb, int indentLevel) {
                    if (this.basic != null) {
                        sb.append("basic: ").append((Object)this.basic);
                        return;
                    }
                    sb.append("<none>");
                }
            }
        }
    }
}

