/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.cli;

import com.beanit.iec61850bean.internal.cli.CliParameterBuilder;
import com.beanit.iec61850bean.internal.cli.CliParseException;
import com.beanit.iec61850bean.internal.cli.ValueCliParameter;
import java.util.ArrayList;
import java.util.List;

public class StringListCliParameter
extends ValueCliParameter {
    List<String> value;
    private List<String> defaultValue = null;

    StringListCliParameter(CliParameterBuilder builder, String parameterName, List<String> defaultValue) {
        super(builder, parameterName);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    StringListCliParameter(CliParameterBuilder builder, String parameterName) {
        super(builder, parameterName);
    }

    public List<String> getValue() {
        return this.value;
    }

    @Override
    int parse(String[] args, int i) throws CliParseException {
        this.selected = true;
        this.value = new ArrayList<String>();
        ++i;
        while (!(i >= args.length || args[i].length() > 0 && args[i].startsWith("-"))) {
            this.value.add(args[i++]);
        }
        if (this.value.size() == 0) {
            throw new CliParseException("Parameter " + this.name + " has no value.");
        }
        return this.value.size() + 1;
    }

    @Override
    int appendSynopsis(StringBuilder sb) {
        int length = 0;
        if (this.optional) {
            sb.append("[");
            ++length;
        }
        sb.append(this.name).append(" <").append(this.parameterName).append(">...");
        length += this.name.length() + 6 + this.parameterName.length();
        if (this.optional) {
            sb.append("]");
            ++length;
        }
        return length;
    }

    @Override
    public void appendDescription(StringBuilder sb) {
        sb.append("\t").append(this.name).append(" <").append(this.parameterName).append(">...\n\t    ").append(this.description);
        if (this.defaultValue != null) {
            sb.append(" Default is \"");
            for (String stringValue : this.defaultValue) {
                sb.append(stringValue);
            }
            sb.append("\".");
        }
    }
}

