/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui.databind;

import com.beanit.iec61850bean.BdaInt32U;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.clientgui.databind.TextFieldDataBind;

public class Int32UDataBind
extends TextFieldDataBind<BdaInt32U> {
    private static final UInt32Filter FILTER = new UInt32Filter();

    public Int32UDataBind(BdaInt32U data) {
        super(data, BdaType.INT32U, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(Long.toString(((BdaInt32U)this.data).getValue()));
    }

    @Override
    protected void writeImpl() {
        ((BdaInt32U)this.data).setValue(Long.parseLong(this.inputField.getText()));
    }

    private static class UInt32Filter
    extends TextFieldDataBind.AbstractFilter {
        private UInt32Filter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                long value = Long.parseLong(text);
                return value >= 0L && value <= 0xFFFFFFFFL;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

