/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui;

import com.beanit.iec61850bean.ClientAssociation;
import com.beanit.iec61850bean.ClientSap;
import com.beanit.iec61850bean.ServerModel;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.clientgui.BasicDataBind;
import com.beanit.iec61850bean.clientgui.DataObjectTreeCellRenderer;
import com.beanit.iec61850bean.clientgui.DataObjectTreeNode;
import com.beanit.iec61850bean.clientgui.DataTreeNode;
import com.beanit.iec61850bean.clientgui.ServerModelParser;
import com.beanit.iec61850bean.clientgui.SettingsFrame;
import com.beanit.iec61850bean.clientgui.util.Counter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ClientGui
extends JFrame
implements ActionListener,
TreeSelectionListener {
    private static final String ADDRESS_KEY = "serverAddress";
    private static final String PORT_KEY = "serverPort";
    private static final String TSEL_LOCAL_KEY = "tselLocal";
    private static final String TSEL_REMOTE_KEY = "tselRemote";
    private static final String LASTCONNECTION_FILE = "lastconnection.properties";
    private static final long serialVersionUID = -1938913902977758367L;
    private final JTextField ipTextField = new JTextField("127.0.0.1");
    private final JTextField portTextField = new JTextField("10002");
    private final JTree tree = new JTree(new DefaultMutableTreeNode("No server connected"));
    private final JPanel detailsPanel = new JPanel();
    private final GridBagLayout detailsLayout = new GridBagLayout();
    private final SettingsFrame settingsFrame = new SettingsFrame();
    private ClientAssociation association;
    private DataTreeNode selectedNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientGui() {
        super("IEC61850bean Client GUI");
        Properties lastConnection = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(LASTCONNECTION_FILE);
            lastConnection.load(in);
            this.ipTextField.setText(lastConnection.getProperty(ADDRESS_KEY));
            this.portTextField.setText(lastConnection.getProperty(PORT_KEY));
            String[] tselString = lastConnection.getProperty(TSEL_LOCAL_KEY).split(",");
            byte[] tsel = new byte[]{(byte)Integer.parseInt(tselString[0]), (byte)Integer.parseInt(tselString[1])};
            this.settingsFrame.setTselLocal(tsel);
            tselString = lastConnection.getProperty(TSEL_REMOTE_KEY).split(",");
            tsel = new byte[]{(byte)Integer.parseInt(tselString[0]), (byte)Integer.parseInt(tselString[1])};
            this.settingsFrame.setTselRemote(tsel);
        }
        catch (Exception tselString) {
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException tselString) {}
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            System.out.println("Object not instantiated: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            System.out.println("Illegal acces: " + e.getMessage());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.out.println("Unsupported LookAndFeel: " + e.getMessage());
        }
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        GridBagConstraints topPanelConstraint = new GridBagConstraints();
        topPanelConstraint.fill = 2;
        topPanelConstraint.gridwidth = 0;
        topPanelConstraint.gridx = 0;
        topPanelConstraint.gridy = 0;
        topPanelConstraint.insets = new Insets(5, 5, 5, 5);
        topPanelConstraint.anchor = 11;
        gbl.setConstraints(topPanel, topPanelConstraint);
        this.add(topPanel);
        JLabel label = new JLabel("IP: ");
        topPanel.add(label);
        topPanel.add(this.ipTextField);
        topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        label = new JLabel("Port: ");
        topPanel.add(label);
        topPanel.add(this.portTextField);
        topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton newServerButton = new JButton("Connect to Server");
        newServerButton.addActionListener(this);
        newServerButton.setActionCommand("Connect");
        topPanel.add(newServerButton);
        topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton settingsButton = new JButton("Settings");
        settingsButton.addActionListener(this);
        settingsButton.setActionCommand("Settings");
        topPanel.add(settingsButton);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new DataObjectTreeCellRenderer());
        this.tree.setMinimumSize(new Dimension(100, 0));
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setMinimumSize(new Dimension(100, 0));
        treeScrollPane.setVisible(true);
        GridBagConstraints treeScrollPaneConstraint = new GridBagConstraints();
        treeScrollPaneConstraint.fill = 1;
        treeScrollPaneConstraint.gridx = 0;
        treeScrollPaneConstraint.gridy = 1;
        treeScrollPaneConstraint.weightx = 0.2;
        treeScrollPaneConstraint.weighty = 1.0;
        treeScrollPaneConstraint.insets = new Insets(5, 5, 5, 5);
        gbl.setConstraints(treeScrollPane, treeScrollPaneConstraint);
        this.add(treeScrollPane);
        this.detailsPanel.setLayout(this.detailsLayout);
        this.detailsPanel.setAlignmentY(0.0f);
        JScrollPane detailsScrollPane = new JScrollPane(this.detailsPanel);
        this.detailsPanel.setMaximumSize(detailsScrollPane.getSize());
        detailsScrollPane.setMinimumSize(new Dimension(0, 0));
        detailsScrollPane.setPreferredSize(new Dimension(200, 0));
        detailsScrollPane.setVisible(true);
        GridBagConstraints detailsScrollPaneConstraint = new GridBagConstraints();
        detailsScrollPaneConstraint.fill = 1;
        detailsScrollPaneConstraint.gridx = 1;
        detailsScrollPaneConstraint.gridy = 1;
        detailsScrollPaneConstraint.weightx = 0.8;
        detailsScrollPaneConstraint.weighty = 1.0;
        detailsScrollPaneConstraint.insets = new Insets(5, 5, 5, 5);
        gbl.setConstraints(detailsScrollPane, detailsScrollPaneConstraint);
        this.add(detailsScrollPane);
        this.setSize(700, 500);
        this.setMinimumSize(new Dimension(420, 0));
        this.setVisible(true);
    }

    public static void main(String[] args) {
        ClientGui clientGui = new ClientGui();
        clientGui.setDefaultCloseOperation(3);
        clientGui.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if ("connect".equalsIgnoreCase(arg0.getActionCommand())) {
            this.connect();
        } else if ("reload".equalsIgnoreCase(arg0.getActionCommand())) {
            this.reload();
        } else if ("write".equalsIgnoreCase(arg0.getActionCommand())) {
            this.write();
        } else if ("settings".equalsIgnoreCase(arg0.getActionCommand())) {
            this.settingsFrame.setVisible(true);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.detailsPanel.removeAll();
        this.detailsPanel.repaint();
        if (e.getNewLeadSelectionPath() != null) {
            this.selectedNode = (DataTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            if (this.selectedNode.readable()) {
                this.showDataDetails(this.selectedNode, new Counter());
                JPanel filler = new JPanel();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 1;
                gbc.gridx = 0;
                gbc.gridy = -1;
                gbc.gridwidth = 3;
                gbc.gridheight = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 1.0;
                this.detailsLayout.setConstraints(filler, gbc);
                this.detailsPanel.add(filler);
                JButton button = new JButton("Reload values");
                button.addActionListener(this);
                button.setActionCommand("reload");
                gbc = new GridBagConstraints();
                gbc.fill = 0;
                gbc.gridx = 0;
                gbc.gridy = -1;
                gbc.gridwidth = 2;
                gbc.gridheight = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 16;
                gbc.insets = new Insets(0, 5, 5, 0);
                this.detailsLayout.setConstraints(button, gbc);
                this.detailsPanel.add(button);
                if (this.selectedNode.writable()) {
                    button = new JButton("Write values");
                    button.addActionListener(this);
                    button.setActionCommand("write");
                    gbc = new GridBagConstraints();
                    gbc.fill = 0;
                    gbc.gridx = 2;
                    gbc.gridy = -1;
                    gbc.gridwidth = 1;
                    gbc.gridheight = 1;
                    gbc.weightx = 0.0;
                    gbc.weighty = 0.0;
                    gbc.anchor = 14;
                    gbc.insets = new Insets(0, 0, 5, 5);
                    this.detailsLayout.setConstraints(button, gbc);
                    this.detailsPanel.add(button);
                }
            }
        } else {
            this.selectedNode = null;
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        ServerModel serverModel;
        ClientSap clientSap = new ClientSap();
        InetAddress address = null;
        try {
            address = InetAddress.getByName(this.ipTextField.getText());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
            return;
        }
        int remotePort = 10002;
        try {
            remotePort = Integer.parseInt(this.portTextField.getText());
            if (remotePort < 1 || remotePort > 65535) {
                throw new NumberFormatException("port must be in range [1, 65535]");
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        clientSap.setTSelLocal(this.settingsFrame.getTselLocal());
        clientSap.setTSelRemote(this.settingsFrame.getTselRemote());
        try {
            this.association = clientSap.associate(address, remotePort, null, null);
        }
        catch (IOException e) {
            System.out.println("Error connecting to server: " + e.getMessage());
            return;
        }
        try {
            serverModel = this.association.retrieveModel();
            this.association.getAllDataValues();
        }
        catch (ServiceError e) {
            System.out.println("Service Error requesting model." + e.getMessage());
            this.association.close();
            return;
        }
        catch (IOException e) {
            System.out.println("Fatal IOException requesting model." + e.getMessage());
            return;
        }
        ServerModelParser parser = new ServerModelParser(serverModel);
        this.tree.setModel(new DefaultTreeModel(parser.getModelTree()));
        Properties lastConnectSettings = new Properties();
        FileOutputStream out = null;
        try {
            lastConnectSettings.setProperty(ADDRESS_KEY, this.ipTextField.getText());
            lastConnectSettings.setProperty(PORT_KEY, this.portTextField.getText());
            byte[] tsel = this.settingsFrame.getTselLocal();
            lastConnectSettings.setProperty(TSEL_LOCAL_KEY, tsel[0] + "," + tsel[1]);
            tsel = this.settingsFrame.getTselRemote();
            lastConnectSettings.setProperty(TSEL_REMOTE_KEY, tsel[0] + "," + tsel[1]);
            out = new FileOutputStream(LASTCONNECTION_FILE);
            lastConnectSettings.store(out, null);
        }
        catch (IOException ex) {
            System.out.println("Writing properties file failed. Reason: " + ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.validate();
    }

    private void reload() {
        if (this.selectedNode.readable()) {
            try {
                this.selectedNode.reset(this.association);
            }
            catch (ServiceError e) {
                System.out.println("ServiceError on reading" + e.getMessage());
                return;
            }
            catch (IOException e) {
                System.out.println("IOException on reading" + e.getMessage());
                return;
            }
            this.validate();
        }
    }

    private void write() {
        if (this.selectedNode.writable()) {
            try {
                this.selectedNode.writeValues(this.association);
            }
            catch (ServiceError e) {
                System.out.println("ServiceError on writing" + e.getMessage());
                return;
            }
            catch (IOException e) {
                System.out.println("IOException on writing" + e.getMessage());
                return;
            }
            this.validate();
        }
    }

    private void showDataDetails(DataTreeNode node, Counter y) {
        if (node.getData() != null) {
            BasicDataBind<?> data = node.getData();
            JLabel nameLabel = data.getNameLabel();
            nameLabel.setText(nameLabel.getText() + ": ");
            this.addDetailsComponent(nameLabel, 0, y.getValue(), 1, 1, 0.0, 0.0);
            this.addDetailsComponent(data.getValueField(), 1, y.getValue(), 2, 1, 1.0, 0.0);
            y.increment();
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                y.increment();
                DataObjectTreeNode childNode = (DataObjectTreeNode)node.getChildAt(i);
                this.showDataDetails(childNode, childNode.toString(), y);
            }
        }
    }

    private void showDataDetails(DataTreeNode node, String pre, Counter y) {
        if (node.getData() != null) {
            BasicDataBind<?> data = node.getData();
            JLabel nameLabel = data.getNameLabel();
            nameLabel.setText(pre + ": ");
            this.addDetailsComponent(nameLabel, 0, y.getValue(), 1, 1, 0.0, 0.0);
            this.addDetailsComponent(data.getValueField(), 1, y.getValue(), 2, 1, 1.0, 0.0);
            y.increment();
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                y.increment();
                DataObjectTreeNode childNode = (DataObjectTreeNode)node.getChildAt(i);
                this.showDataDetails(childNode, pre + "." + childNode.toString(), y);
                this.detailsPanel.add(new JSeparator());
                this.addDetailsComponent(new JSeparator(), 0, y.getValue(), 3, 1, 1.0, 0.0);
            }
        }
    }

    private void addDetailsComponent(Component c, int x, int y, int width, int height, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.anchor = 11;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.detailsLayout.setConstraints(c, gbc);
        this.detailsPanel.add(c);
    }
}

