/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.asn1bean.ber.types.BerBitString;
import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaBoolean;
import com.beanit.iec61850bean.BdaEntryTime;
import com.beanit.iec61850bean.BdaReasonForInclusion;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.FcDataObject;
import com.beanit.iec61850bean.FcModelNode;
import com.beanit.iec61850bean.ModelNode;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.Rcb;
import com.beanit.iec61850bean.ServerAssociation;
import com.beanit.iec61850bean.internal.mms.asn1.AccessResult;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.Identifier;
import com.beanit.iec61850bean.internal.mms.asn1.InformationReport;
import com.beanit.iec61850bean.internal.mms.asn1.MMSpdu;
import com.beanit.iec61850bean.internal.mms.asn1.ObjectName;
import com.beanit.iec61850bean.internal.mms.asn1.UnconfirmedPDU;
import com.beanit.iec61850bean.internal.mms.asn1.UnconfirmedService;
import com.beanit.iec61850bean.internal.mms.asn1.VariableAccessSpecification;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Urcb
extends Rcb {
    final HashMap<FcModelNode, BdaReasonForInclusion> membersToBeReported = new LinkedHashMap<FcModelNode, BdaReasonForInclusion>();
    ServerAssociation reserved = null;
    boolean enabled = false;
    private Timer integrityTimer;
    private ScheduledFuture<?> bufTmFuture = null;

    public Urcb(ObjectReference objectReference, List<FcModelNode> children) {
        super(objectReference, Fc.RP, children);
    }

    public BdaBoolean getResv() {
        return (BdaBoolean)this.children.get("Resv");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enable() {
        for (FcModelNode dataSetMember : this.dataSet) {
            for (BasicDataAttribute bda : dataSetMember.getBasicDataAttributes()) {
                List<Urcb> list;
                if (bda.dchg) {
                    if (this.getTrgOps().isDataChange()) {
                        list = bda.chgRcbs;
                        synchronized (list) {
                            bda.chgRcbs.add(this);
                        }
                    }
                } else if (bda.qchg && this.getTrgOps().isQualityChange()) {
                    list = bda.chgRcbs;
                    synchronized (list) {
                        bda.chgRcbs.add(this);
                    }
                }
                if (!bda.dupd || !this.getTrgOps().isDataUpdate()) continue;
                list = bda.dupdRcbs;
                synchronized (list) {
                    bda.dupdRcbs.add(this);
                }
            }
        }
        if (this.getTrgOps().isIntegrity() && this.getIntgPd().getValue() >= 10L) {
            this.integrityTimer = new Timer();
            this.integrityTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Urcb urcb = Urcb.this;
                    synchronized (urcb) {
                        if (!Urcb.this.enabled) {
                            return;
                        }
                        Urcb.this.reserved.sendAnMmsPdu(Urcb.this.getMmsReport(true, false));
                    }
                }
            }, this.getIntgPd().getValue(), this.getIntgPd().getValue());
        }
        this.enabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disable() {
        for (FcModelNode dataSetMember : this.dataSet) {
            for (BasicDataAttribute bda : dataSetMember.getBasicDataAttributes()) {
                List<Urcb> list;
                if (bda.dchg) {
                    if (this.getTrgOps().isDataChange()) {
                        list = bda.chgRcbs;
                        synchronized (list) {
                            bda.chgRcbs.remove(this);
                        }
                    }
                } else if (bda.qchg && this.getTrgOps().isQualityChange()) {
                    list = bda.chgRcbs;
                    synchronized (list) {
                        bda.chgRcbs.remove(this);
                    }
                }
                if (!bda.dupd || !this.getTrgOps().isDataUpdate()) continue;
                list = bda.dupdRcbs;
                synchronized (list) {
                    bda.dupdRcbs.remove(this);
                }
            }
        }
        if (this.integrityTimer != null) {
            this.integrityTimer.cancel();
        }
        this.enabled = false;
    }

    void generalInterrogation() {
        this.reserved.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Urcb urcb = Urcb.this;
                synchronized (urcb) {
                    if (!Urcb.this.enabled) {
                        return;
                    }
                    Urcb.this.reserved.sendAnMmsPdu(Urcb.this.getMmsReport(false, true));
                }
            }
        });
    }

    private MMSpdu getMmsReport(boolean integrity, boolean gi) {
        InformationReport.ListOfAccessResult listOfAccessResult = new InformationReport.ListOfAccessResult();
        List<AccessResult> accessResults = listOfAccessResult.getAccessResult();
        AccessResult accessResult = new AccessResult();
        accessResult.setSuccess(this.getRptId().getMmsDataObj());
        accessResults.add(accessResult);
        accessResult = new AccessResult();
        accessResult.setSuccess(this.getOptFlds().getMmsDataObj());
        accessResults.add(accessResult);
        if (this.getOptFlds().isSequenceNumber()) {
            accessResult = new AccessResult();
            accessResult.setSuccess(this.getSqNum().getMmsDataObj());
            accessResults.add(accessResult);
        }
        this.getSqNum().setValue((short)(this.getSqNum().getValue() + 1));
        if (this.getOptFlds().isReportTimestamp()) {
            BdaEntryTime entryTime = new BdaEntryTime(null, null, null, false, false);
            entryTime.setTimestamp(System.currentTimeMillis());
            accessResult = new AccessResult();
            accessResult.setSuccess(entryTime.getMmsDataObj());
            accessResults.add(accessResult);
        }
        if (this.getOptFlds().isDataSetName()) {
            accessResult = new AccessResult();
            accessResult.setSuccess(this.getDatSet().getMmsDataObj());
            accessResults.add(accessResult);
        }
        if (this.getOptFlds().isConfigRevision()) {
            accessResult = new AccessResult();
            accessResult.setSuccess(this.getConfRev().getMmsDataObj());
            accessResults.add(accessResult);
        }
        List<FcModelNode> dataSetMembers = this.dataSet.getMembers();
        int dataSetSize = dataSetMembers.size();
        byte[] inclusionStringArray = new byte[(dataSetSize - 1) / 8 + 1];
        if (integrity || gi) {
            for (int i = 0; i < dataSetSize; ++i) {
                inclusionStringArray[i / 8] = (byte)(inclusionStringArray[i / 8] | 1 << 7 - i % 8);
            }
            BerBitString inclusionString = new BerBitString(inclusionStringArray, dataSetSize);
            Data data = new Data();
            data.setBitString(inclusionString);
            accessResult = new AccessResult();
            accessResult.setSuccess(data);
            accessResults.add(accessResult);
            for (FcModelNode dataSetMember : dataSetMembers) {
                accessResult = new AccessResult();
                accessResult.setSuccess(dataSetMember.getMmsDataObj());
                accessResults.add(accessResult);
            }
            BdaReasonForInclusion reasonForInclusion = new BdaReasonForInclusion(null);
            if (integrity) {
                reasonForInclusion.setIntegrity(true);
            } else {
                reasonForInclusion.setGeneralInterrogation(true);
            }
            if (this.getOptFlds().isReasonForInclusion()) {
                for (int i = 0; i < dataSetMembers.size(); ++i) {
                    accessResult = new AccessResult();
                    accessResult.setSuccess(reasonForInclusion.getMmsDataObj());
                    accessResults.add(accessResult);
                }
            }
        } else {
            int index = 0;
            for (FcModelNode dataSetMember : this.dataSet) {
                if (this.membersToBeReported.get(dataSetMember) != null) {
                    inclusionStringArray[index / 8] = (byte)(inclusionStringArray[index / 8] | 1 << 7 - index % 8);
                }
                ++index;
            }
            BerBitString inclusionString = new BerBitString(inclusionStringArray, dataSetSize);
            Data data = new Data();
            data.setBitString(inclusionString);
            accessResult = new AccessResult();
            accessResult.setSuccess(data);
            accessResults.add(accessResult);
            for (FcModelNode dataSetMember : dataSetMembers) {
                if (this.membersToBeReported.get(dataSetMember) == null) continue;
                accessResult = new AccessResult();
                accessResult.setSuccess(dataSetMember.getMmsDataObj());
                accessResults.add(accessResult);
            }
            if (this.getOptFlds().isReasonForInclusion()) {
                for (FcModelNode dataSetMember : dataSetMembers) {
                    BdaReasonForInclusion reasonForInclusion = this.membersToBeReported.get(dataSetMember);
                    if (reasonForInclusion == null) continue;
                    accessResult = new AccessResult();
                    accessResult.setSuccess(reasonForInclusion.getMmsDataObj());
                    accessResults.add(accessResult);
                }
            }
            this.membersToBeReported.clear();
            this.bufTmFuture = null;
        }
        ObjectName objectName = new ObjectName();
        objectName.setVmdSpecific(new Identifier("RPT".getBytes(StandardCharsets.UTF_8)));
        VariableAccessSpecification varAccSpec = new VariableAccessSpecification();
        varAccSpec.setVariableListName(objectName);
        InformationReport infoReport = new InformationReport();
        infoReport.setVariableAccessSpecification(varAccSpec);
        infoReport.setListOfAccessResult(listOfAccessResult);
        UnconfirmedService unconfirmedService = new UnconfirmedService();
        unconfirmedService.setInformationReport(infoReport);
        UnconfirmedPDU unconfirmedPDU = new UnconfirmedPDU();
        unconfirmedPDU.setService(unconfirmedService);
        MMSpdu mmsPdu = new MMSpdu();
        mmsPdu.setUnconfirmedPDU(unconfirmedPDU);
        return mmsPdu;
    }

    @Override
    public FcDataObject copy() {
        ArrayList<FcModelNode> childCopies = new ArrayList<FcModelNode>(this.children.size());
        for (ModelNode childNode : this.children.values()) {
            childCopies.add((FcModelNode)childNode.copy());
        }
        Urcb urcb = new Urcb(this.objectReference, childCopies);
        urcb.dataSet = this.dataSet;
        return urcb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void report(BasicDataAttribute bda, boolean dchg, boolean qchg, boolean dupd) {
        Urcb urcb = this;
        synchronized (urcb) {
            BdaReasonForInclusion reasonForInclusion;
            if (!this.enabled) {
                return;
            }
            BasicDataAttribute memberFound = null;
            FcModelNode fcModelNode = bda;
            while (memberFound == null) {
                for (FcModelNode member : this.dataSet) {
                    if (member != fcModelNode) continue;
                    memberFound = fcModelNode;
                    break;
                }
                if (memberFound != null) break;
                if (!(fcModelNode.parent instanceof FcModelNode)) {
                    return;
                }
                fcModelNode = (FcModelNode)fcModelNode.parent;
            }
            if ((reasonForInclusion = this.membersToBeReported.get(fcModelNode)) == null) {
                reasonForInclusion = new BdaReasonForInclusion(null);
                this.membersToBeReported.put(fcModelNode, reasonForInclusion);
            }
            if (dchg) {
                reasonForInclusion.setDataChange(true);
            }
            if (dupd) {
                reasonForInclusion.setDataUpdate(true);
            } else if (qchg) {
                reasonForInclusion.setQualityChange(true);
            }
            if (this.bufTmFuture == null) {
                this.bufTmFuture = this.reserved.executor.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Urcb urcb = Urcb.this;
                        synchronized (urcb) {
                            if (!Urcb.this.enabled) {
                                return;
                            }
                            Urcb.this.reserved.sendAnMmsPdu(Urcb.this.getMmsReport(false, false));
                        }
                    }
                }, this.getBufTm().getValue(), TimeUnit.MILLISECONDS);
            }
        }
    }
}

