/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.Array;
import com.beanit.iec61850bean.Brcb;
import com.beanit.iec61850bean.DataSet;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.FcModelNode;
import com.beanit.iec61850bean.LogicalDevice;
import com.beanit.iec61850bean.LogicalNode;
import com.beanit.iec61850bean.ModelNode;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.Urcb;
import com.beanit.iec61850bean.internal.mms.asn1.AlternateAccessSelection;
import com.beanit.iec61850bean.internal.mms.asn1.ObjectName;
import com.beanit.iec61850bean.internal.mms.asn1.VariableDefs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ServerModel
extends ModelNode {
    private final Map<String, DataSet> dataSets = new LinkedHashMap<String, DataSet>();
    private final Map<String, Urcb> urcbs = new HashMap<String, Urcb>();
    private final Map<String, Brcb> brcbs = new HashMap<String, Brcb>();

    public ServerModel(List<LogicalDevice> logicalDevices, Collection<DataSet> dataSets) {
        this.children = new LinkedHashMap();
        this.objectReference = null;
        for (LogicalDevice logicalDevice : logicalDevices) {
            this.children.put(logicalDevice.getReference().getName(), logicalDevice);
            logicalDevice.setParent(this);
        }
        if (dataSets != null) {
            this.addDataSets(dataSets);
        }
        for (LogicalDevice ld : logicalDevices) {
            for (ModelNode ln : ld.getChildren()) {
                for (Urcb urcb : ((LogicalNode)ln).getUrcbs()) {
                    this.urcbs.put(urcb.getReference().toString(), urcb);
                    urcb.dataSet = this.getDataSet(urcb.getDatSet().getStringValue().replace('$', '.'));
                }
                for (Brcb brcb : ((LogicalNode)ln).getBrcbs()) {
                    this.brcbs.put(brcb.getReference().toString(), brcb);
                    brcb.dataSet = this.getDataSet(brcb.getDatSet().getStringValue().replace('$', '.'));
                }
            }
        }
    }

    @Override
    public ServerModel copy() {
        ArrayList<LogicalDevice> childCopies = new ArrayList<LogicalDevice>(this.children.size());
        for (ModelNode childNode : this.children.values()) {
            childCopies.add((LogicalDevice)childNode.copy());
        }
        ArrayList<DataSet> dataSetCopies = new ArrayList<DataSet>(this.dataSets.size());
        for (DataSet dataSet : this.dataSets.values()) {
            dataSetCopies.add(dataSet);
        }
        return new ServerModel(childCopies, dataSetCopies);
    }

    public DataSet getDataSet(String reference) {
        return this.dataSets.get(reference);
    }

    void addDataSet(DataSet dataSet) {
        this.dataSets.put(dataSet.getReferenceStr().replace('$', '.'), dataSet);
        for (ModelNode ld : this.children.values()) {
            for (ModelNode ln : ld.getChildren()) {
                for (Urcb urcb : ((LogicalNode)ln).getUrcbs()) {
                    urcb.dataSet = this.getDataSet(urcb.getDatSet().getStringValue().replace('$', '.'));
                }
                for (Brcb brcb : ((LogicalNode)ln).getBrcbs()) {
                    brcb.dataSet = this.getDataSet(brcb.getDatSet().getStringValue().replace('$', '.'));
                }
            }
        }
    }

    void addDataSets(Collection<DataSet> dataSets) {
        for (DataSet dataSet : dataSets) {
            this.addDataSet(dataSet);
        }
        for (ModelNode ld : this.children.values()) {
            for (ModelNode ln : ld.getChildren()) {
                for (Urcb urcb : ((LogicalNode)ln).getUrcbs()) {
                    urcb.dataSet = this.getDataSet(urcb.getDatSet().getStringValue().replace('$', '.'));
                }
                for (Brcb brcb : ((LogicalNode)ln).getBrcbs()) {
                    brcb.dataSet = this.getDataSet(brcb.getDatSet().getStringValue().replace('$', '.'));
                }
            }
        }
    }

    List<String> getDataSetNames(String ldName) {
        ArrayList<String> dataSetNames = new ArrayList<String>();
        for (String dataSetRef : this.dataSets.keySet()) {
            if (!dataSetRef.startsWith(ldName)) continue;
            dataSetNames.add(dataSetRef.substring(dataSetRef.indexOf(47) + 1).replace('.', '$'));
        }
        return dataSetNames;
    }

    public Collection<DataSet> getDataSets() {
        return this.dataSets.values();
    }

    DataSet removeDataSet(String dataSetReference) {
        DataSet dataSet = this.dataSets.get(dataSetReference);
        if (dataSet == null || !dataSet.isDeletable()) {
            return null;
        }
        DataSet removedDataSet = this.dataSets.remove(dataSetReference);
        for (ModelNode ld : this.children.values()) {
            for (ModelNode ln : ld.getChildren()) {
                for (Urcb urcb : ((LogicalNode)ln).getUrcbs()) {
                    urcb.dataSet = this.getDataSet(urcb.getDatSet().getStringValue().replace('$', '.'));
                }
                for (Brcb brcb : ((LogicalNode)ln).getBrcbs()) {
                    brcb.dataSet = this.getDataSet(brcb.getDatSet().getStringValue().replace('$', '.'));
                }
            }
        }
        return removedDataSet;
    }

    void addUrcb(Urcb urcb) {
        this.urcbs.put(urcb.getReference().getName(), urcb);
    }

    public Urcb getUrcb(String reference) {
        return this.urcbs.get(reference);
    }

    public Collection<Urcb> getUrcbs() {
        return this.urcbs.values();
    }

    public Brcb getBrcb(String reference) {
        return this.brcbs.get(reference);
    }

    public Collection<Brcb> getBrcbs() {
        return this.brcbs.values();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ModelNode logicalDevice : this.children.values()) {
            sb.append(logicalDevice.toString());
        }
        sb.append("\n\n\n---------------------\nURCBs:");
        for (Urcb urcb : this.getUrcbs()) {
            sb.append("\n\n").append(urcb);
        }
        sb.append("\n\n\n---------------------\nBRCBs:");
        for (Brcb brcb : this.getBrcbs()) {
            sb.append("\n\n").append(brcb);
        }
        sb.append("\n\n\n---------------------\nData sets:");
        for (DataSet dataSet : this.getDataSets()) {
            sb.append("\n\n").append(dataSet);
        }
        return sb.toString();
    }

    public ModelNode findModelNode(ObjectReference objectReference, Fc fc) {
        ModelNode currentNode = this;
        Iterator<String> searchedNodeReferenceIterator = objectReference.iterator();
        while (searchedNodeReferenceIterator.hasNext()) {
            if ((currentNode = currentNode.getChild(searchedNodeReferenceIterator.next(), fc)) != null) continue;
            return null;
        }
        return currentNode;
    }

    public ModelNode findModelNode(String objectReference, Fc fc) {
        return this.findModelNode(new ObjectReference(objectReference), fc);
    }

    FcModelNode getNodeFromVariableDef(VariableDefs.SEQUENCE variableDef) throws ServiceError {
        ObjectName objectName = variableDef.getVariableSpecification().getName();
        if (objectName == null) {
            throw new ServiceError(11, "name in objectName is not selected");
        }
        ObjectName.DomainSpecific domainSpecific = objectName.getDomainSpecific();
        if (domainSpecific == null) {
            throw new ServiceError(11, "domain_specific in name is not selected");
        }
        ModelNode modelNode = this.getChild(domainSpecific.getDomainID().toString());
        if (modelNode == null) {
            return null;
        }
        String mmsItemId = domainSpecific.getItemID().toString();
        int index1 = mmsItemId.indexOf(36);
        if (index1 == -1) {
            throw new ServiceError(11, "invalid mms item id: " + (Object)((Object)domainSpecific.getItemID()));
        }
        LogicalNode ln = (LogicalNode)modelNode.getChild(mmsItemId.substring(0, index1));
        if (ln == null) {
            return null;
        }
        int index2 = mmsItemId.indexOf(36, index1 + 1);
        if (index2 == -1) {
            throw new ServiceError(11, "invalid mms item id");
        }
        Fc fc = Fc.fromString(mmsItemId.substring(index1 + 1, index2));
        if (fc == null) {
            throw new ServiceError(11, "unknown functional constraint: " + mmsItemId.substring(index1 + 1, index2));
        }
        index1 = index2;
        if ((index2 = mmsItemId.indexOf(36, index1 + 1)) == -1) {
            if (fc == Fc.RP) {
                return ln.getUrcb(mmsItemId.substring(index1 + 1));
            }
            if (fc == Fc.BR) {
                return ln.getBrcb(mmsItemId.substring(index1 + 1));
            }
            return (FcModelNode)ln.getChild(mmsItemId.substring(index1 + 1), fc);
        }
        modelNode = fc == Fc.RP ? ln.getUrcb(mmsItemId.substring(index1 + 1, index2)) : (fc == Fc.BR ? ln.getBrcb(mmsItemId.substring(index1 + 1, index2)) : ln.getChild(mmsItemId.substring(index1 + 1, index2), fc));
        index1 = index2;
        index2 = mmsItemId.indexOf(36, index1 + 1);
        while (index2 != -1) {
            modelNode = modelNode.getChild(mmsItemId.substring(index1 + 1, index2));
            index1 = index2;
            index2 = mmsItemId.indexOf(36, index1 + 1);
        }
        modelNode = modelNode.getChild(mmsItemId.substring(index1 + 1));
        if (variableDef.getAlternateAccess() == null) {
            return (FcModelNode)modelNode;
        }
        AlternateAccessSelection altAccIt = variableDef.getAlternateAccess().getCHOICE().get(0).getUnnamed();
        if (altAccIt.getSelectAlternateAccess() != null) {
            modelNode = ((Array)modelNode).getChild(altAccIt.getSelectAlternateAccess().getAccessSelection().getIndex().intValue());
            String mmsSubArrayItemId = altAccIt.getSelectAlternateAccess().getAlternateAccess().getCHOICE().get(0).getUnnamed().getSelectAccess().getComponent().getBasic().toString();
            index1 = -1;
            index2 = mmsSubArrayItemId.indexOf(36);
            while (index2 != -1) {
                modelNode = modelNode.getChild(mmsSubArrayItemId.substring(index1 + 1, index2));
                index1 = index2;
                index2 = mmsItemId.indexOf(36, index1 + 1);
            }
            return (FcModelNode)modelNode.getChild(mmsSubArrayItemId.substring(index1 + 1));
        }
        return (FcModelNode)((Array)modelNode).getChild(altAccIt.getSelectAccess().getIndex().intValue());
    }
}

