/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.BdaEntryTime;
import com.beanit.iec61850bean.BdaOctetString;
import com.beanit.iec61850bean.BdaReasonForInclusion;
import com.beanit.iec61850bean.FcModelNode;
import com.beanit.iec61850bean.internal.HexString;
import java.util.List;

public class Report {
    private final String rptId;
    private final Integer sqNum;
    private final Integer subSqNum;
    private final boolean moreSegmentsFollow;
    private final String dataSetRef;
    private final Boolean bufOvfl;
    private final Long confRev;
    private final BdaEntryTime timeOfEntry;
    private final BdaOctetString entryId;
    private final boolean[] inclusionBitString;
    private final List<FcModelNode> values;
    private final List<BdaReasonForInclusion> reasonCodes;

    public Report(String rptId, Integer sqNum, Integer subSqNum, boolean moreSegmentsFollow, String dataSetRef, Boolean bufOvfl, Long confRev, BdaEntryTime timeOfEntry, BdaOctetString entryId, boolean[] inclusionBitString, List<FcModelNode> values, List<BdaReasonForInclusion> reasonCodes) {
        this.rptId = rptId;
        this.sqNum = sqNum;
        this.subSqNum = subSqNum;
        this.moreSegmentsFollow = moreSegmentsFollow;
        this.dataSetRef = dataSetRef;
        this.bufOvfl = bufOvfl;
        this.confRev = confRev;
        this.timeOfEntry = timeOfEntry;
        this.entryId = entryId;
        this.inclusionBitString = inclusionBitString;
        this.values = values;
        this.reasonCodes = reasonCodes;
    }

    public String getRptId() {
        return this.rptId;
    }

    public Integer getSqNum() {
        return this.sqNum;
    }

    public Integer getSubSqNum() {
        return this.subSqNum;
    }

    public boolean isMoreSegmentsFollow() {
        return this.moreSegmentsFollow;
    }

    public String getDataSetRef() {
        return this.dataSetRef;
    }

    public Boolean getBufOvfl() {
        return this.bufOvfl;
    }

    public Long getConfRev() {
        return this.confRev;
    }

    public BdaEntryTime getTimeOfEntry() {
        return this.timeOfEntry;
    }

    public BdaOctetString getEntryId() {
        return this.entryId;
    }

    public boolean[] getInclusionBitString() {
        return this.inclusionBitString;
    }

    public List<BdaReasonForInclusion> getReasonCodes() {
        return this.reasonCodes;
    }

    public List<FcModelNode> getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Report ID: ").append(this.rptId);
        sb.append("\nData set reference: ").append(this.dataSetRef);
        if (this.sqNum != null) {
            sb.append("\nSequence number: ").append(this.sqNum);
        }
        if (this.subSqNum != null) {
            sb.append("\nSubsequence number: ").append(this.subSqNum);
            if (this.moreSegmentsFollow) {
                sb.append(" (more segments follow)");
            }
        }
        if (this.timeOfEntry != null) {
            sb.append("\nTime of entry (unix timestamp): ").append(this.timeOfEntry.getTimestampValue());
        }
        if (this.bufOvfl != null) {
            sb.append("\nBuffer overflow: ").append(this.bufOvfl);
        }
        if (this.entryId != null) {
            sb.append("\nEntry ID: ").append(HexString.fromBytes(this.entryId.getValue()));
        }
        if (this.confRev != null) {
            sb.append("\nConfiguration revision: ").append(this.confRev.toString());
        }
        sb.append("\nReported data set members:");
        int index = 0;
        for (FcModelNode reportedDataSetMember : this.values) {
            sb.append("\n").append(reportedDataSetMember.toString());
            if (this.reasonCodes != null) {
                sb.append(", reason: ").append(this.reasonCodes.get(index));
            }
            ++index;
        }
        return sb.toString();
    }
}

