/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.Brcb;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.FcDataObject;
import com.beanit.iec61850bean.ModelNode;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServerModel;
import com.beanit.iec61850bean.Urcb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class LogicalNode
extends ModelNode {
    private final Map<Fc, Map<String, FcDataObject>> fcDataObjects = new EnumMap<Fc, Map<String, FcDataObject>>(Fc.class);
    private final Map<String, Urcb> urcbs = new HashMap<String, Urcb>();
    private final Map<String, Brcb> brcbs = new HashMap<String, Brcb>();

    public LogicalNode(ObjectReference objectReference, List<FcDataObject> fcDataObjects) {
        this.children = new LinkedHashMap();
        for (Fc fc : Fc.values()) {
            this.fcDataObjects.put(fc, new LinkedHashMap());
        }
        this.objectReference = objectReference;
        for (FcDataObject fcDataObject : fcDataObjects) {
            this.children.put(fcDataObject.getReference().getName() + fcDataObject.fc.toString(), fcDataObject);
            this.fcDataObjects.get((Object)fcDataObject.getFc()).put(fcDataObject.getReference().getName(), fcDataObject);
            fcDataObject.setParent(this);
            if (fcDataObject.getFc() == Fc.RP) {
                this.addUrcb((Urcb)fcDataObject, false);
                continue;
            }
            if (fcDataObject.getFc() != Fc.BR) continue;
            this.addBrcb((Brcb)fcDataObject);
        }
    }

    @Override
    public LogicalNode copy() {
        ArrayList<FcDataObject> dataObjectsCopy = new ArrayList<FcDataObject>();
        for (ModelNode obj : this.children.values()) {
            dataObjectsCopy.add((FcDataObject)obj.copy());
        }
        LogicalNode copy = new LogicalNode(this.objectReference, dataObjectsCopy);
        return copy;
    }

    public List<FcDataObject> getChildren(Fc fc) {
        Map<String, FcDataObject> requestedDataObjectsMap = this.fcDataObjects.get((Object)fc);
        if (requestedDataObjectsMap == null) {
            return null;
        }
        Collection<FcDataObject> fcChildren = requestedDataObjectsMap.values();
        if (fcChildren.size() == 0) {
            return null;
        }
        return new ArrayList<FcDataObject>(fcChildren);
    }

    void addUrcb(Urcb urcb, boolean addDataSet) {
        String dataSetRef;
        this.urcbs.put(urcb.getReference().getName(), urcb);
        if (addDataSet && (dataSetRef = urcb.getDatSet().getStringValue()) != null) {
            urcb.dataSet = ((ServerModel)this.getParent().getParent()).getDataSet(dataSetRef.replace('$', '.'));
        }
    }

    public Collection<Urcb> getUrcbs() {
        return this.urcbs.values();
    }

    public Urcb getUrcb(String urcbName) {
        return this.urcbs.get(urcbName);
    }

    void addBrcb(Brcb brcb) {
        this.brcbs.put(brcb.getReference().getName(), brcb);
    }

    public Brcb getBrcb(String brcbName) {
        return this.brcbs.get(brcbName);
    }

    public Collection<Brcb> getBrcbs() {
        return this.brcbs.values();
    }

    @Override
    public ModelNode getChild(String childName, Fc fc) {
        if (fc != null) {
            return this.fcDataObjects.get((Object)fc).get(childName);
        }
        for (Map<String, FcDataObject> map : this.fcDataObjects.values()) {
            FcDataObject fcDataObject = map.get(childName);
            if (fcDataObject == null) continue;
            return fcDataObject;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReference().toString());
        for (Map<String, FcDataObject> fcChildNodes : this.fcDataObjects.values()) {
            for (ModelNode modelNode : fcChildNodes.values()) {
                sb.append("\n");
                sb.append(modelNode.toString());
            }
        }
        return sb.toString();
    }
}

