/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.FcModelNode;
import com.beanit.iec61850bean.ModelNode;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.internal.mms.asn1.Identifier;
import com.beanit.iec61850bean.internal.mms.asn1.ObjectName;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DataSet
implements Iterable<FcModelNode> {
    private final String dataSetReference;
    private final List<FcModelNode> members;
    private final Map<Fc, Map<String, FcModelNode>> membersMap = new EnumMap<Fc, Map<String, FcModelNode>>(Fc.class);
    private final boolean deletable;
    private ObjectName mmsObjectName = null;

    public DataSet(String dataSetReference, List<FcModelNode> members) {
        this(dataSetReference, members, true);
    }

    public DataSet(String dataSetReference, List<FcModelNode> members, boolean deletable) {
        if (!dataSetReference.startsWith("@") && dataSetReference.indexOf(47) == -1) {
            throw new IllegalArgumentException("DataSet reference " + dataSetReference + " is invalid. Must either start with @ or contain a slash.");
        }
        this.members = new ArrayList<FcModelNode>();
        this.dataSetReference = dataSetReference;
        this.deletable = deletable;
        for (Fc myfc : Fc.values()) {
            this.membersMap.put(myfc, new LinkedHashMap());
        }
        for (FcModelNode member : members) {
            this.members.add(member);
            this.membersMap.get((Object)member.getFc()).put(member.getReference().toString(), member);
        }
    }

    public String getReferenceStr() {
        return this.dataSetReference;
    }

    public DataSet copy() {
        ArrayList<FcModelNode> membersCopy = new ArrayList<FcModelNode>(this.members.size());
        for (FcModelNode node : this.members) {
            membersCopy.add((FcModelNode)node.copy());
        }
        return new DataSet(this.dataSetReference, membersCopy, this.deletable);
    }

    public FcModelNode getMember(ObjectReference memberReference, Fc fc) {
        if (fc != null) {
            return this.membersMap.get((Object)fc).get(memberReference.toString());
        }
        for (FcModelNode member : this.members) {
            if (!member.getReference().toString().equals(memberReference.toString())) continue;
            return member;
        }
        return null;
    }

    public FcModelNode getMember(int index) {
        return this.members.get(index);
    }

    public List<FcModelNode> getMembers() {
        return this.members;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    @Override
    public Iterator<FcModelNode> iterator() {
        return this.members.iterator();
    }

    public List<BasicDataAttribute> getBasicDataAttributes() {
        ArrayList<BasicDataAttribute> subBasicDataAttributes = new ArrayList<BasicDataAttribute>();
        for (ModelNode modelNode : this.members) {
            subBasicDataAttributes.addAll(modelNode.getBasicDataAttributes());
        }
        return subBasicDataAttributes;
    }

    ObjectName getMmsObjectName() {
        if (this.mmsObjectName != null) {
            return this.mmsObjectName;
        }
        if (this.dataSetReference.charAt(0) == '@') {
            this.mmsObjectName = new ObjectName();
            this.mmsObjectName.setAaSpecific(new Identifier(this.dataSetReference.getBytes(StandardCharsets.UTF_8)));
            return this.mmsObjectName;
        }
        int slash = this.dataSetReference.indexOf(47);
        String domainID = this.dataSetReference.substring(0, slash);
        String itemID = this.dataSetReference.substring(slash + 1).replace('.', '$');
        ObjectName.DomainSpecific domainSpecificObjectName = new ObjectName.DomainSpecific();
        domainSpecificObjectName.setDomainID(new Identifier(domainID.getBytes(StandardCharsets.UTF_8)));
        domainSpecificObjectName.setItemID(new Identifier(itemID.getBytes(StandardCharsets.UTF_8)));
        this.mmsObjectName = new ObjectName();
        this.mmsObjectName.setDomainSpecific(domainSpecificObjectName);
        return this.mmsObjectName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReferenceStr());
        for (FcModelNode member : this.members) {
            sb.append("\n");
            sb.append(member.toString());
        }
        return sb.toString();
    }
}

