/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.Array;
import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaBoolean;
import com.beanit.iec61850bean.BdaCheck;
import com.beanit.iec61850bean.BdaDoubleBitPos;
import com.beanit.iec61850bean.BdaEntryTime;
import com.beanit.iec61850bean.BdaFloat32;
import com.beanit.iec61850bean.BdaFloat64;
import com.beanit.iec61850bean.BdaInt128;
import com.beanit.iec61850bean.BdaInt16;
import com.beanit.iec61850bean.BdaInt16U;
import com.beanit.iec61850bean.BdaInt32;
import com.beanit.iec61850bean.BdaInt32U;
import com.beanit.iec61850bean.BdaInt64;
import com.beanit.iec61850bean.BdaInt8;
import com.beanit.iec61850bean.BdaInt8U;
import com.beanit.iec61850bean.BdaOctetString;
import com.beanit.iec61850bean.BdaOptFlds;
import com.beanit.iec61850bean.BdaQuality;
import com.beanit.iec61850bean.BdaTapCommand;
import com.beanit.iec61850bean.BdaTimestamp;
import com.beanit.iec61850bean.BdaTriggerConditions;
import com.beanit.iec61850bean.BdaUnicodeString;
import com.beanit.iec61850bean.BdaVisibleString;
import com.beanit.iec61850bean.Brcb;
import com.beanit.iec61850bean.ConstructedDataAttribute;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.FcDataObject;
import com.beanit.iec61850bean.FcModelNode;
import com.beanit.iec61850bean.LogicalNode;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.Urcb;
import com.beanit.iec61850bean.internal.mms.asn1.ConfirmedServiceResponse;
import com.beanit.iec61850bean.internal.mms.asn1.GetVariableAccessAttributesResponse;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;
import com.beanit.iec61850bean.internal.mms.asn1.TypeSpecification;
import java.util.ArrayList;
import java.util.List;

final class DataDefinitionResParser {
    DataDefinitionResParser() {
    }

    static LogicalNode parseGetDataDefinitionResponse(ConfirmedServiceResponse confirmedServiceResponse, ObjectReference lnRef) throws ServiceError {
        if (confirmedServiceResponse.getGetVariableAccessAttributes() == null) {
            throw new ServiceError(11, "decodeGetDataDefinitionResponse: Error decoding GetDataDefinitionResponsePdu");
        }
        GetVariableAccessAttributesResponse varAccAttrs = confirmedServiceResponse.getGetVariableAccessAttributes();
        TypeDescription typeSpec = varAccAttrs.getTypeDescription();
        if (typeSpec.getStructure() == null) {
            throw new ServiceError(11, "decodeGetDataDefinitionResponse: Error decoding GetDataDefinitionResponsePdu");
        }
        TypeDescription.Structure.Components structure = typeSpec.getStructure().getComponents();
        ArrayList<FcDataObject> fcDataObjects = new ArrayList<FcDataObject>();
        for (TypeDescription.Structure.Components.SEQUENCE fcComponent : structure.getSEQUENCE()) {
            if (fcComponent.getComponentName() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            if (fcComponent.getComponentType().getTypeDescription().getStructure() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            String fcString = fcComponent.getComponentName().toString();
            if (fcString.equals("LG") || fcString.equals("GO") || fcString.equals("GS") || fcString.equals("MS") || fcString.equals("US")) continue;
            Fc fc = Fc.fromString(fcComponent.getComponentName().toString());
            TypeDescription.Structure.Components subStructure = fcComponent.getComponentType().getTypeDescription().getStructure().getComponents();
            fcDataObjects.addAll(DataDefinitionResParser.getFcDataObjectsFromSubStructure(lnRef, fc, subStructure));
        }
        LogicalNode ln = new LogicalNode(lnRef, fcDataObjects);
        return ln;
    }

    private static List<FcDataObject> getFcDataObjectsFromSubStructure(ObjectReference lnRef, Fc fc, TypeDescription.Structure.Components components) throws ServiceError {
        List<TypeDescription.Structure.Components.SEQUENCE> structComponents = components.getSEQUENCE();
        ArrayList<FcDataObject> dataObjects = new ArrayList<FcDataObject>(structComponents.size());
        for (TypeDescription.Structure.Components.SEQUENCE doComp : structComponents) {
            if (doComp.getComponentName() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            if (doComp.getComponentType().getTypeDescription() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            ObjectReference doRef = new ObjectReference(lnRef + "." + doComp.getComponentName().toString());
            List<FcModelNode> children = DataDefinitionResParser.getDoSubModelNodesFromSubStructure(doRef, fc, doComp.getComponentType().getTypeDescription().getStructure().getComponents());
            if (fc == Fc.RP) {
                dataObjects.add(new Urcb(doRef, children));
                continue;
            }
            if (fc == Fc.BR) {
                dataObjects.add(new Brcb(doRef, children));
                continue;
            }
            dataObjects.add(new FcDataObject(doRef, fc, children));
        }
        return dataObjects;
    }

    private static List<FcModelNode> getDoSubModelNodesFromSubStructure(ObjectReference parentRef, Fc fc, TypeDescription.Structure.Components structure) throws ServiceError {
        List<TypeDescription.Structure.Components.SEQUENCE> structComponents = structure.getSEQUENCE();
        ArrayList<FcModelNode> dataObjects = new ArrayList<FcModelNode>(structComponents.size());
        for (TypeDescription.Structure.Components.SEQUENCE component : structComponents) {
            if (component.getComponentName() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            String childName = component.getComponentName().toString();
            dataObjects.add(DataDefinitionResParser.getModelNodesFromTypeSpecification(new ObjectReference(parentRef + "." + childName), fc, component.getComponentType()));
        }
        return dataObjects;
    }

    private static FcModelNode getModelNodesFromTypeSpecification(ObjectReference ref, Fc fc, TypeSpecification mmsTypeSpec) throws ServiceError {
        if (mmsTypeSpec.getTypeDescription().getArray() != null) {
            int numArrayElements = mmsTypeSpec.getTypeDescription().getArray().getNumberOfElements().intValue();
            ArrayList<FcModelNode> arrayChildren = new ArrayList<FcModelNode>(numArrayElements);
            for (int i = 0; i < numArrayElements; ++i) {
                arrayChildren.add(DataDefinitionResParser.getModelNodesFromTypeSpecification(new ObjectReference(ref + "(" + i + ")"), fc, mmsTypeSpec.getTypeDescription().getArray().getElementType()));
            }
            return new Array(ref, fc, arrayChildren);
        }
        if (mmsTypeSpec.getTypeDescription().getStructure() != null) {
            List<FcModelNode> children = DataDefinitionResParser.getDoSubModelNodesFromSubStructure(ref, fc, mmsTypeSpec.getTypeDescription().getStructure().getComponents());
            return new ConstructedDataAttribute(ref, fc, children);
        }
        BasicDataAttribute bt = DataDefinitionResParser.convertMmsBasicTypeSpec(ref, fc, mmsTypeSpec.getTypeDescription());
        if (bt == null) {
            throw new ServiceError(5, "decodeGetDataDefinitionResponse: Unknown data type received " + ref);
        }
        return bt;
    }

    private static BasicDataAttribute convertMmsBasicTypeSpec(ObjectReference ref, Fc fc, TypeDescription mmsTypeSpec) throws ServiceError {
        if (mmsTypeSpec.getBool() != null) {
            return new BdaBoolean(ref, fc, null, false, false);
        }
        if (mmsTypeSpec.getBitString() != null) {
            int bitStringMaxLength = Math.abs(mmsTypeSpec.getBitString().intValue());
            if (bitStringMaxLength == 13) {
                return new BdaQuality(ref, fc, null, false);
            }
            if (bitStringMaxLength == 10) {
                return new BdaOptFlds(ref, fc);
            }
            if (bitStringMaxLength == 6) {
                return new BdaTriggerConditions(ref, fc);
            }
            if (bitStringMaxLength == 2) {
                if (fc == Fc.CO) {
                    if (ref.getName().charAt(1) == 't') {
                        return new BdaTapCommand(ref, fc, null, false, false);
                    }
                    return new BdaCheck(ref);
                }
                return new BdaDoubleBitPos(ref, fc, null, false, false);
            }
            return null;
        }
        if (mmsTypeSpec.getInteger() != null) {
            switch (mmsTypeSpec.getInteger().intValue()) {
                case 8: {
                    return new BdaInt8(ref, fc, null, false, false);
                }
                case 16: {
                    return new BdaInt16(ref, fc, null, false, false);
                }
                case 32: {
                    return new BdaInt32(ref, fc, null, false, false);
                }
                case 64: {
                    return new BdaInt64(ref, fc, null, false, false);
                }
                case 128: {
                    return new BdaInt128(ref, fc, null, false, false);
                }
            }
        } else if (mmsTypeSpec.getUnsigned() != null) {
            switch (mmsTypeSpec.getUnsigned().intValue()) {
                case 8: {
                    return new BdaInt8U(ref, fc, null, false, false);
                }
                case 16: {
                    return new BdaInt16U(ref, fc, null, false, false);
                }
                case 32: {
                    return new BdaInt32U(ref, fc, null, false, false);
                }
            }
        } else {
            if (mmsTypeSpec.getFloatingPoint() != null) {
                int floatSize = mmsTypeSpec.getFloatingPoint().getFormatWidth().intValue();
                if (floatSize == 32) {
                    return new BdaFloat32(ref, fc, null, false, false);
                }
                if (floatSize == 64) {
                    return new BdaFloat64(ref, fc, null, false, false);
                }
                throw new ServiceError(5, "FLOAT of size: " + floatSize + " is not supported.");
            }
            if (mmsTypeSpec.getOctetString() != null) {
                int stringSize = mmsTypeSpec.getOctetString().intValue();
                if (stringSize > 255 || stringSize < -255) {
                    throw new ServiceError(5, "OCTET_STRING of size: " + stringSize + " is not supported.");
                }
                return new BdaOctetString(ref, fc, null, Math.abs(stringSize), false, false);
            }
            if (mmsTypeSpec.getVisibleString() != null) {
                int stringSize = mmsTypeSpec.getVisibleString().intValue();
                if (stringSize > 255 || stringSize < -255) {
                    throw new ServiceError(5, "VISIBLE_STRING of size: " + stringSize + " is not supported.");
                }
                return new BdaVisibleString(ref, fc, null, Math.abs(stringSize), false, false);
            }
            if (mmsTypeSpec.getMMSString() != null) {
                int stringSize = mmsTypeSpec.getMMSString().intValue();
                if (stringSize > 255 || stringSize < -255) {
                    throw new ServiceError(5, "UNICODE_STRING of size: " + stringSize + " is not supported.");
                }
                return new BdaUnicodeString(ref, fc, null, Math.abs(stringSize), false, false);
            }
            if (mmsTypeSpec.getUtcTime() != null) {
                return new BdaTimestamp(ref, fc, null, false, false);
            }
            if (mmsTypeSpec.getBinaryTime() != null) {
                return new BdaEntryTime(ref, fc, null, false, false);
            }
        }
        return null;
    }
}

