/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerInteger;
import com.beanit.asn1bean.ber.types.BerNull;
import com.beanit.asn1bean.ber.types.string.BerGraphicString;
import com.beanit.asn1bean.ber.types.string.BerVisibleString;
import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaBoolean;
import com.beanit.iec61850bean.BdaEntryTime;
import com.beanit.iec61850bean.BdaInt16;
import com.beanit.iec61850bean.BdaInt8U;
import com.beanit.iec61850bean.BdaOctetString;
import com.beanit.iec61850bean.BdaOptFlds;
import com.beanit.iec61850bean.BdaReasonForInclusion;
import com.beanit.iec61850bean.BdaTimestamp;
import com.beanit.iec61850bean.BdaVisibleString;
import com.beanit.iec61850bean.Brcb;
import com.beanit.iec61850bean.ClientEventListener;
import com.beanit.iec61850bean.ConstructedDataAttribute;
import com.beanit.iec61850bean.DataDefinitionResParser;
import com.beanit.iec61850bean.DataSet;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.FcModelNode;
import com.beanit.iec61850bean.FileInformation;
import com.beanit.iec61850bean.GetFileListener;
import com.beanit.iec61850bean.LogicalDevice;
import com.beanit.iec61850bean.LogicalNode;
import com.beanit.iec61850bean.ModelNode;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.Rcb;
import com.beanit.iec61850bean.Report;
import com.beanit.iec61850bean.ServerModel;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.Urcb;
import com.beanit.iec61850bean.internal.BerBoolean;
import com.beanit.iec61850bean.internal.mms.asn1.AccessResult;
import com.beanit.iec61850bean.internal.mms.asn1.ConfirmedRequestPDU;
import com.beanit.iec61850bean.internal.mms.asn1.ConfirmedResponsePDU;
import com.beanit.iec61850bean.internal.mms.asn1.ConfirmedServiceRequest;
import com.beanit.iec61850bean.internal.mms.asn1.ConfirmedServiceResponse;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.DefineNamedVariableListRequest;
import com.beanit.iec61850bean.internal.mms.asn1.DeleteNamedVariableListRequest;
import com.beanit.iec61850bean.internal.mms.asn1.DeleteNamedVariableListResponse;
import com.beanit.iec61850bean.internal.mms.asn1.DirectoryEntry;
import com.beanit.iec61850bean.internal.mms.asn1.FileCloseRequest;
import com.beanit.iec61850bean.internal.mms.asn1.FileDeleteRequest;
import com.beanit.iec61850bean.internal.mms.asn1.FileDirectoryRequest;
import com.beanit.iec61850bean.internal.mms.asn1.FileDirectoryResponse;
import com.beanit.iec61850bean.internal.mms.asn1.FileName;
import com.beanit.iec61850bean.internal.mms.asn1.FileOpenRequest;
import com.beanit.iec61850bean.internal.mms.asn1.FileReadRequest;
import com.beanit.iec61850bean.internal.mms.asn1.GetNameListRequest;
import com.beanit.iec61850bean.internal.mms.asn1.GetNameListResponse;
import com.beanit.iec61850bean.internal.mms.asn1.GetNamedVariableListAttributesRequest;
import com.beanit.iec61850bean.internal.mms.asn1.GetNamedVariableListAttributesResponse;
import com.beanit.iec61850bean.internal.mms.asn1.GetVariableAccessAttributesRequest;
import com.beanit.iec61850bean.internal.mms.asn1.Identifier;
import com.beanit.iec61850bean.internal.mms.asn1.InitiateRequestPDU;
import com.beanit.iec61850bean.internal.mms.asn1.InitiateResponsePDU;
import com.beanit.iec61850bean.internal.mms.asn1.Integer16;
import com.beanit.iec61850bean.internal.mms.asn1.Integer32;
import com.beanit.iec61850bean.internal.mms.asn1.Integer8;
import com.beanit.iec61850bean.internal.mms.asn1.MMSpdu;
import com.beanit.iec61850bean.internal.mms.asn1.ObjectClass;
import com.beanit.iec61850bean.internal.mms.asn1.ObjectName;
import com.beanit.iec61850bean.internal.mms.asn1.ParameterSupportOptions;
import com.beanit.iec61850bean.internal.mms.asn1.ReadRequest;
import com.beanit.iec61850bean.internal.mms.asn1.ReadResponse;
import com.beanit.iec61850bean.internal.mms.asn1.RejectPDU;
import com.beanit.iec61850bean.internal.mms.asn1.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.ServiceSupportOptions;
import com.beanit.iec61850bean.internal.mms.asn1.UnconfirmedPDU;
import com.beanit.iec61850bean.internal.mms.asn1.UnconfirmedService;
import com.beanit.iec61850bean.internal.mms.asn1.Unsigned32;
import com.beanit.iec61850bean.internal.mms.asn1.VariableAccessSpecification;
import com.beanit.iec61850bean.internal.mms.asn1.VariableDefs;
import com.beanit.iec61850bean.internal.mms.asn1.WriteRequest;
import com.beanit.iec61850bean.internal.mms.asn1.WriteResponse;
import com.beanit.josistack.AcseAssociation;
import com.beanit.josistack.ByteBufferInputStream;
import com.beanit.josistack.ClientAcseSap;
import com.beanit.josistack.DecodingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ClientAssociation {
    private static final Integer16 version = new Integer16(new byte[]{1, 1});
    private static final ParameterSupportOptions proposedParameterCbbBitString = new ParameterSupportOptions(new byte[]{3, 5, -15, 0});
    private final ClientReceiver clientReceiver;
    private final BlockingQueue<MMSpdu> incomingResponses = new LinkedBlockingQueue<MMSpdu>();
    private final ReverseByteArrayOutputStream reverseOStream = new ReverseByteArrayOutputStream(500, true);
    ServerModel serverModel;
    private AcseAssociation acseAssociation = null;
    private int responseTimeout;
    private int invokeId = 0;
    private int negotiatedMaxPduSize;
    private ClientEventListener reportListener = null;
    private boolean closed = false;

    ClientAssociation(InetAddress address, int port, InetAddress localAddr, int localPort, String authenticationParameter, ClientAcseSap acseSap, int proposedMaxMmsPduSize, int proposedMaxServOutstandingCalling, int proposedMaxServOutstandingCalled, int proposedDataStructureNestingLevel, byte[] servicesSupportedCalling, int responseTimeout, int messageFragmentTimeout, ClientEventListener reportListener) throws IOException {
        this.responseTimeout = responseTimeout;
        acseSap.tSap.setMessageFragmentTimeout(messageFragmentTimeout);
        acseSap.tSap.setMessageTimeout(responseTimeout);
        this.negotiatedMaxPduSize = proposedMaxMmsPduSize;
        this.reportListener = reportListener;
        this.associate(address, port, localAddr, localPort, authenticationParameter, acseSap, proposedMaxMmsPduSize, proposedMaxServOutstandingCalling, proposedMaxServOutstandingCalled, proposedDataStructureNestingLevel, servicesSupportedCalling);
        this.acseAssociation.setMessageTimeout(0);
        this.clientReceiver = new ClientReceiver(this.negotiatedMaxPduSize);
        this.clientReceiver.start();
    }

    private static ServiceError mmsDataAccessErrorToServiceError(BerInteger dataAccessError) {
        switch (dataAccessError.value.intValue()) {
            case 1: {
                return new ServiceError(12, "MMS DataAccessError: hardware-fault");
            }
            case 2: {
                return new ServiceError(8, "MMS DataAccessError: temporarily-unavailable");
            }
            case 3: {
                return new ServiceError(3, "MMS DataAccessError: object-access-denied");
            }
            case 5: {
                return new ServiceError(6, "MMS DataAccessError: invalid-address");
            }
            case 7: {
                return new ServiceError(10, "MMS DataAccessError: type-inconsistent");
            }
            case 10: {
                return new ServiceError(1, "MMS DataAccessError: object-non-existent");
            }
            case 11: {
                return new ServiceError(6, "MMS DataAccessError: object-value-invalid");
            }
        }
        return new ServiceError(11, "MMS DataAccessError: " + dataAccessError.value);
    }

    private static void testForErrorResponse(MMSpdu mmsResponsePdu) throws ServiceError {
        if (mmsResponsePdu.getConfirmedErrorPDU() == null) {
            return;
        }
        ServiceError.ErrorClass errClass = mmsResponsePdu.getConfirmedErrorPDU().getServiceError().getErrorClass();
        if (errClass != null) {
            if (errClass.getAccess() != null) {
                if (errClass.getAccess().value.intValue() == 3) {
                    throw new ServiceError(3, "MMS confirmed error: class: \"access\", error code: \"object-access-denied\"");
                }
                if (errClass.getAccess().value.intValue() == 2) {
                    throw new ServiceError(1, "MMS confirmed error: class: \"access\", error code: \"object-non-existent\"");
                }
            } else if (errClass.getFile() != null && errClass.getFile().value.intValue() == 7) {
                throw new ServiceError(17, "MMS confirmed error: class: \"file\", error code: \"file-non-existent\"");
            }
        }
        if (mmsResponsePdu.getConfirmedErrorPDU().getServiceError().getAdditionalDescription() != null) {
            throw new ServiceError(23, "MMS confirmed error. Description: " + mmsResponsePdu.getConfirmedErrorPDU().getServiceError().getAdditionalDescription().toString());
        }
        throw new ServiceError(23, "MMS confirmed error.");
    }

    private static void testForRejectResponse(MMSpdu mmsResponsePdu) throws ServiceError {
        if (mmsResponsePdu.getRejectPDU() == null) {
            return;
        }
        RejectPDU.RejectReason rejectReason = mmsResponsePdu.getRejectPDU().getRejectReason();
        if (rejectReason != null && rejectReason.getPduError() != null && rejectReason.getPduError().value.intValue() == 1) {
            throw new ServiceError(6, "MMS reject: type: \"pdu-error\", reject code: \"invalid-pdu\"");
        }
        throw new ServiceError(23, "MMS confirmed error.");
    }

    private static void testForInitiateErrorResponse(MMSpdu mmsResponsePdu) throws ServiceError {
        if (mmsResponsePdu.getInitiateErrorPDU() != null) {
            ServiceError.ErrorClass errClass = mmsResponsePdu.getInitiateErrorPDU().getErrorClass();
            if (errClass != null) {
                if (errClass.getVmdState() != null) {
                    throw new ServiceError(11, "error class \"vmd_state\" with val: " + errClass.getVmdState().value);
                }
                if (errClass.getApplicationReference() != null) {
                    throw new ServiceError(11, "error class \"application_reference\" with val: " + errClass.getApplicationReference().value);
                }
                if (errClass.getDefinition() != null) {
                    throw new ServiceError(11, "error class \"definition\" with val: " + errClass.getDefinition().value);
                }
                if (errClass.getResource() != null) {
                    throw new ServiceError(11, "error class \"resource\" with val: " + errClass.getResource().value);
                }
                if (errClass.getService() != null) {
                    throw new ServiceError(11, "error class \"service\" with val: " + errClass.getService().value);
                }
                if (errClass.getServicePreempt() != null) {
                    throw new ServiceError(11, "error class \"service_preempt\" with val: " + errClass.getServicePreempt().value);
                }
                if (errClass.getTimeResolution() != null) {
                    throw new ServiceError(11, "error class \"time_resolution\" with val: " + errClass.getTimeResolution().value);
                }
                if (errClass.getAccess() != null) {
                    throw new ServiceError(11, "error class \"access\" with val: " + errClass.getAccess().value);
                }
                if (errClass.getInitiate() != null) {
                    throw new ServiceError(11, "error class \"initiate\" with val: " + errClass.getInitiate().value);
                }
                if (errClass.getConclude() != null) {
                    throw new ServiceError(11, "error class \"conclude\" with val: " + errClass.getConclude());
                }
                if (errClass.getCancel() != null) {
                    throw new ServiceError(11, "error class \"cancel\" with val: " + errClass.getCancel().value);
                }
                if (errClass.getFile() != null) {
                    throw new ServiceError(11, "error class \"file\" with val: " + errClass.getFile().value);
                }
                if (errClass.getOthers() != null) {
                    throw new ServiceError(11, "error class \"others\" with val: " + errClass.getOthers().value);
                }
            }
            throw new ServiceError(11, "unknown error class");
        }
    }

    private static MMSpdu constructInitRequestPdu(int proposedMaxPduSize, int proposedMaxServOutstandingCalling, int proposedMaxServOutstandingCalled, int proposedDataStructureNestingLevel, byte[] servicesSupportedCalling) {
        InitiateRequestPDU.InitRequestDetail initRequestDetail = new InitiateRequestPDU.InitRequestDetail();
        initRequestDetail.setProposedVersionNumber(version);
        initRequestDetail.setProposedParameterCBB(proposedParameterCbbBitString);
        initRequestDetail.setServicesSupportedCalling(new ServiceSupportOptions(servicesSupportedCalling, 85));
        InitiateRequestPDU initiateRequestPdu = new InitiateRequestPDU();
        initiateRequestPdu.setLocalDetailCalling(new Integer32(proposedMaxPduSize));
        initiateRequestPdu.setProposedMaxServOutstandingCalling(new Integer16(proposedMaxServOutstandingCalling));
        initiateRequestPdu.setProposedMaxServOutstandingCalled(new Integer16(proposedMaxServOutstandingCalled));
        initiateRequestPdu.setProposedDataStructureNestingLevel(new Integer8(proposedDataStructureNestingLevel));
        initiateRequestPdu.setInitRequestDetail(initRequestDetail);
        MMSpdu initiateRequestMMSpdu = new MMSpdu();
        initiateRequestMMSpdu.setInitiateRequestPDU(initiateRequestPdu);
        return initiateRequestMMSpdu;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int timeout) {
        this.responseTimeout = timeout;
    }

    private int getInvokeId() {
        this.invokeId = (this.invokeId + 1) % Integer.MAX_VALUE;
        return this.invokeId;
    }

    private ConfirmedServiceResponse encodeWriteReadDecode(ConfirmedServiceRequest serviceRequest) throws ServiceError, IOException {
        int currentInvokeId = this.getInvokeId();
        ConfirmedRequestPDU confirmedRequestPdu = new ConfirmedRequestPDU();
        confirmedRequestPdu.setInvokeID(new Unsigned32(currentInvokeId));
        confirmedRequestPdu.setService(serviceRequest);
        MMSpdu requestPdu = new MMSpdu();
        requestPdu.setConfirmedRequestPDU(confirmedRequestPdu);
        this.reverseOStream.reset();
        try {
            requestPdu.encode((OutputStream)this.reverseOStream);
        }
        catch (Exception e) {
            IOException e2 = new IOException("Error encoding MmsPdu.", e);
            this.clientReceiver.close(e2);
            throw e2;
        }
        this.clientReceiver.setResponseExpected(currentInvokeId);
        try {
            this.acseAssociation.send(this.reverseOStream.getByteBuffer());
        }
        catch (IOException e) {
            IOException e2 = new IOException("Error sending packet.", e);
            this.clientReceiver.close(e2);
            throw e2;
        }
        MMSpdu decodedResponsePdu = null;
        try {
            decodedResponsePdu = this.responseTimeout == 0 ? this.incomingResponses.take() : this.incomingResponses.poll(this.responseTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        if (decodedResponsePdu == null && (decodedResponsePdu = this.clientReceiver.removeExpectedResponse()) == null) {
            throw new ServiceError(22);
        }
        if (decodedResponsePdu.getConfirmedRequestPDU() != null) {
            this.incomingResponses.add(decodedResponsePdu);
            throw new IOException("connection was closed", this.clientReceiver.getLastIOException());
        }
        ClientAssociation.testForInitiateErrorResponse(decodedResponsePdu);
        ClientAssociation.testForErrorResponse(decodedResponsePdu);
        ClientAssociation.testForRejectResponse(decodedResponsePdu);
        ConfirmedResponsePDU confirmedResponsePdu = decodedResponsePdu.getConfirmedResponsePDU();
        if (confirmedResponsePdu == null) {
            throw new IllegalStateException("Response PDU is not a confirmed response pdu");
        }
        return confirmedResponsePdu.getService();
    }

    private void associate(InetAddress address, int port, InetAddress localAddr, int localPort, String authenticationParameter, ClientAcseSap acseSap, int proposedMaxPduSize, int proposedMaxServOutstandingCalling, int proposedMaxServOutstandingCalled, int proposedDataStructureNestingLevel, byte[] servicesSupportedCalling) throws IOException {
        MMSpdu initiateRequestMMSpdu = ClientAssociation.constructInitRequestPdu(proposedMaxPduSize, proposedMaxServOutstandingCalling, proposedMaxServOutstandingCalled, proposedDataStructureNestingLevel, servicesSupportedCalling);
        ReverseByteArrayOutputStream reverseOStream = new ReverseByteArrayOutputStream(500, true);
        initiateRequestMMSpdu.encode((OutputStream)reverseOStream);
        try {
            this.acseAssociation = acseSap.associate(address, port, localAddr, localPort, authenticationParameter, reverseOStream.getByteBuffer());
            ByteBuffer initResponse = this.acseAssociation.getAssociateResponseAPdu();
            MMSpdu initiateResponseMmsPdu = new MMSpdu();
            initiateResponseMmsPdu.decode(new ByteBufferInputStream(initResponse), null);
            this.handleInitiateResponse(initiateResponseMmsPdu, proposedMaxPduSize, proposedMaxServOutstandingCalling, proposedMaxServOutstandingCalled, proposedDataStructureNestingLevel);
        }
        catch (IOException e) {
            if (this.acseAssociation != null) {
                this.acseAssociation.close();
            }
            throw e;
        }
    }

    private void handleInitiateResponse(MMSpdu responsePdu, int proposedMaxPduSize, int proposedMaxServOutstandingCalling, int proposedMaxServOutstandingCalled, int proposedDataStructureNestingLevel) throws IOException {
        if (responsePdu.getInitiateErrorPDU() != null) {
            throw new IOException("Got response error of class: " + responsePdu.getInitiateErrorPDU().getErrorClass());
        }
        if (responsePdu.getInitiateResponsePDU() == null) {
            this.acseAssociation.disconnect();
            throw new IOException("Error decoding InitiateResponse Pdu");
        }
        InitiateResponsePDU initiateResponsePdu = responsePdu.getInitiateResponsePDU();
        if (initiateResponsePdu.getLocalDetailCalled() != null) {
            this.negotiatedMaxPduSize = initiateResponsePdu.getLocalDetailCalled().intValue();
        }
        int negotiatedMaxServOutstandingCalling = initiateResponsePdu.getNegotiatedMaxServOutstandingCalling().intValue();
        int negotiatedMaxServOutstandingCalled = initiateResponsePdu.getNegotiatedMaxServOutstandingCalled().intValue();
        int negotiatedDataStructureNestingLevel = initiateResponsePdu.getNegotiatedDataStructureNestingLevel() != null ? initiateResponsePdu.getNegotiatedDataStructureNestingLevel().intValue() : proposedDataStructureNestingLevel;
        if (this.negotiatedMaxPduSize < 64 || this.negotiatedMaxPduSize > proposedMaxPduSize || negotiatedMaxServOutstandingCalling > proposedMaxServOutstandingCalling || negotiatedMaxServOutstandingCalling < 0 || negotiatedMaxServOutstandingCalled > proposedMaxServOutstandingCalled || negotiatedMaxServOutstandingCalled < 0 || negotiatedDataStructureNestingLevel > proposedDataStructureNestingLevel || negotiatedDataStructureNestingLevel < 0) {
            this.acseAssociation.disconnect();
            throw new IOException("Error negotiating parameters");
        }
        int version = initiateResponsePdu.getInitResponseDetail().getNegotiatedVersionNumber().intValue();
        if (version != 1) {
            throw new IOException("Unsupported version number was negotiated.");
        }
        byte[] servicesSupported = initiateResponsePdu.getInitResponseDetail().getServicesSupportedCalled().value;
        if ((servicesSupported[0] & 0x40) != 64) {
            throw new IOException("Obligatory services are not supported by the server.");
        }
    }

    public void setServerModel(ServerModel model) {
        this.serverModel = model;
    }

    public ServerModel retrieveModel() throws ServiceError, IOException {
        List<String> ldNames = this.retrieveLogicalDevices();
        ArrayList<List<String>> lnNames = new ArrayList<List<String>>(ldNames.size());
        for (int i = 0; i < ldNames.size(); ++i) {
            lnNames.add(this.retrieveLogicalNodeNames(ldNames.get(i)));
        }
        ArrayList<LogicalDevice> lds = new ArrayList<LogicalDevice>();
        for (int i = 0; i < ldNames.size(); ++i) {
            ArrayList<LogicalNode> lns = new ArrayList<LogicalNode>();
            for (int j = 0; j < ((List)lnNames.get(i)).size(); ++j) {
                lns.add(this.retrieveDataDefinitions(new ObjectReference(ldNames.get(i) + "/" + (String)((List)lnNames.get(i)).get(j))));
            }
            lds.add(new LogicalDevice(new ObjectReference(ldNames.get(i)), lns));
        }
        this.serverModel = new ServerModel(lds, null);
        this.updateDataSets();
        return this.serverModel;
    }

    private List<String> retrieveLogicalDevices() throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest = this.constructGetServerDirectoryRequest();
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
        return this.decodeGetServerDirectoryResponse(confirmedServiceResponse);
    }

    private ConfirmedServiceRequest constructGetServerDirectoryRequest() {
        ObjectClass objectClass = new ObjectClass();
        objectClass.setBasicObjectClass(new BerInteger(9L));
        GetNameListRequest.ObjectScope objectScope = new GetNameListRequest.ObjectScope();
        objectScope.setVmdSpecific(new BerNull());
        GetNameListRequest getNameListRequest = new GetNameListRequest();
        getNameListRequest.setObjectClass(objectClass);
        getNameListRequest.setObjectScope(objectScope);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setGetNameList(getNameListRequest);
        return confirmedServiceRequest;
    }

    private List<String> decodeGetServerDirectoryResponse(ConfirmedServiceResponse confirmedServiceResponse) throws ServiceError {
        if (confirmedServiceResponse.getGetNameList() == null) {
            throw new ServiceError(11, "Error decoding Get Server Directory Response Pdu");
        }
        List<Identifier> identifiers = confirmedServiceResponse.getGetNameList().getListOfIdentifier().getIdentifier();
        ArrayList<String> objectRefs = new ArrayList<String>();
        for (BerVisibleString berVisibleString : identifiers) {
            objectRefs.add(berVisibleString.toString());
        }
        return objectRefs;
    }

    private List<String> retrieveLogicalNodeNames(String ld) throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest;
        ConfirmedServiceResponse confirmedServiceResponse;
        ArrayList<String> lns = new ArrayList<String>();
        String continueAfterRef = "";
        while (!(continueAfterRef = this.decodeGetDirectoryResponse(confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest = this.constructGetDirectoryRequest(ld, continueAfterRef, true)), lns)).isEmpty()) {
        }
        return lns;
    }

    private ConfirmedServiceRequest constructGetDirectoryRequest(String ldRef, String continueAfter, boolean logicalDevice) {
        ObjectClass objectClass = new ObjectClass();
        if (logicalDevice) {
            objectClass.setBasicObjectClass(new BerInteger(0L));
        } else {
            objectClass.setBasicObjectClass(new BerInteger(2L));
        }
        GetNameListRequest.ObjectScope objectScopeChoiceType = new GetNameListRequest.ObjectScope();
        objectScopeChoiceType.setDomainSpecific(new Identifier(ldRef.getBytes(StandardCharsets.UTF_8)));
        GetNameListRequest getNameListRequest = new GetNameListRequest();
        getNameListRequest.setObjectClass(objectClass);
        getNameListRequest.setObjectScope(objectScopeChoiceType);
        if (!continueAfter.isEmpty()) {
            getNameListRequest.setContinueAfter(new Identifier(continueAfter.getBytes(StandardCharsets.UTF_8)));
        }
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setGetNameList(getNameListRequest);
        return confirmedServiceRequest;
    }

    /*
     * WARNING - void declaration
     */
    private String decodeGetDirectoryResponse(ConfirmedServiceResponse confirmedServiceResponse, List<String> lns) throws ServiceError {
        void var5_6;
        if (confirmedServiceResponse.getGetNameList() == null) {
            throw new ServiceError(11, "decodeGetLDDirectoryResponse: Error decoding server response");
        }
        GetNameListResponse getNameListResponse = confirmedServiceResponse.getGetNameList();
        List<Identifier> identifiers = getNameListResponse.getListOfIdentifier().getIdentifier();
        if (identifiers.size() == 0) {
            throw new ServiceError(1, "decodeGetLDDirectoryResponse: Instance not available");
        }
        Object var5_5 = null;
        for (BerVisibleString berVisibleString : identifiers) {
            String idString = berVisibleString.toString();
            if (idString.indexOf(36) != -1) continue;
            lns.add(idString);
        }
        if (getNameListResponse.getMoreFollows() != null && !getNameListResponse.getMoreFollows().value) {
            return "";
        }
        return var5_6.toString();
    }

    private LogicalNode retrieveDataDefinitions(ObjectReference lnRef) throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest = this.constructGetDataDefinitionRequest(lnRef);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
        return this.decodeGetDataDefinitionResponse(confirmedServiceResponse, lnRef);
    }

    private ConfirmedServiceRequest constructGetDataDefinitionRequest(ObjectReference lnRef) {
        ObjectName.DomainSpecific domainSpec = new ObjectName.DomainSpecific();
        domainSpec.setDomainID(new Identifier(lnRef.get(0).getBytes(StandardCharsets.UTF_8)));
        domainSpec.setItemID(new Identifier(lnRef.get(1).getBytes(StandardCharsets.UTF_8)));
        ObjectName objectName = new ObjectName();
        objectName.setDomainSpecific(domainSpec);
        GetVariableAccessAttributesRequest getVariableAccessAttributesRequest = new GetVariableAccessAttributesRequest();
        getVariableAccessAttributesRequest.setName(objectName);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setGetVariableAccessAttributes(getVariableAccessAttributesRequest);
        return confirmedServiceRequest;
    }

    private LogicalNode decodeGetDataDefinitionResponse(ConfirmedServiceResponse confirmedServiceResponse, ObjectReference lnRef) throws ServiceError {
        return DataDefinitionResParser.parseGetDataDefinitionResponse(confirmedServiceResponse, lnRef);
    }

    public void getDataValues(FcModelNode modelNode) throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest = this.constructGetDataValuesRequest(modelNode);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
        this.decodeGetDataValuesResponse(confirmedServiceResponse, modelNode);
    }

    private boolean decodeGetFileDirectoryResponse(ConfirmedServiceResponse confirmedServiceResponse, List<FileInformation> files) throws ServiceError {
        if (confirmedServiceResponse.getFileDirectory() == null) {
            throw new ServiceError(11, "Error decoding GetFileDirectoryResponsePdu");
        }
        FileDirectoryResponse fileDirectoryRes = confirmedServiceResponse.getFileDirectory();
        List<DirectoryEntry> entries = fileDirectoryRes.getListOfDirectoryEntry().getDirectoryEntry();
        for (DirectoryEntry entry : entries) {
            List<BerGraphicString> graphicStrings = entry.getFileName().getBerGraphicString();
            StringBuilder filename = new StringBuilder();
            for (BerGraphicString bgs : graphicStrings) {
                filename.append(bgs.toString());
            }
            long fileSize = entry.getFileAttributes().getSizeOfFile().longValue();
            Calendar lastModified = null;
            try {
                if (entry.getFileAttributes().getLastModified() != null) {
                    lastModified = entry.getFileAttributes().getLastModified().asCalendar();
                }
            }
            catch (ParseException e) {
                throw new ServiceError(11, "Error decoding GetFileDirectoryResponsePdu");
            }
            FileInformation fileInfo = new FileInformation(filename.toString(), fileSize, lastModified);
            files.add(fileInfo);
        }
        boolean moreFollows = fileDirectoryRes.getMoreFollows() != null && fileDirectoryRes.getMoreFollows().value;
        return moreFollows;
    }

    public List<FileInformation> getFileDirectory(String directoryName) throws ServiceError, IOException {
        ArrayList<FileInformation> files = new ArrayList<FileInformation>();
        boolean moreFollows = true;
        String continueAfter = null;
        while (moreFollows) {
            FileDirectoryRequest fileDirectoryRequest = new FileDirectoryRequest();
            BerGraphicString berGraphicString = new BerGraphicString(directoryName.getBytes(StandardCharsets.UTF_8));
            FileName fileSpecification = new FileName();
            fileSpecification.getBerGraphicString().add(berGraphicString);
            fileDirectoryRequest.setFileSpecification(fileSpecification);
            if (continueAfter != null) {
                FileName continueAfterSpecification = new FileName();
                continueAfterSpecification.getBerGraphicString().add(new BerGraphicString(continueAfter.getBytes(StandardCharsets.UTF_8)));
                fileDirectoryRequest.setContinueAfter(continueAfterSpecification);
            }
            ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
            confirmedServiceRequest.setFileDirectory(fileDirectoryRequest);
            ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(confirmedServiceRequest);
            moreFollows = this.decodeGetFileDirectoryResponse(confirmedServiceResponse, files);
            if (!moreFollows) continue;
            continueAfter = ((FileInformation)files.get(files.size() - 1)).getFilename();
        }
        return files;
    }

    public void deleteFile(String filename) throws ServiceError, IOException {
        FileDeleteRequest fileDeleteRequest = new FileDeleteRequest();
        fileDeleteRequest.getBerGraphicString().add(new BerGraphicString(filename.getBytes(StandardCharsets.UTF_8)));
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setFileDelete(fileDeleteRequest);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(confirmedServiceRequest);
        if (confirmedServiceResponse.getFileDelete() == null) {
            throw new ServiceError(11, "Error decoding DeleteFileResponsePdu");
        }
    }

    private Integer32 openFile(String filename) throws ServiceError, IOException {
        FileOpenRequest fileOpenRequest = new FileOpenRequest();
        FileName fileSpecification = new FileName();
        fileSpecification.getBerGraphicString().add(new BerGraphicString(filename.getBytes(StandardCharsets.UTF_8)));
        fileOpenRequest.setFileName(fileSpecification);
        fileOpenRequest.setInitialPosition(new Unsigned32(0L));
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setFileOpen(fileOpenRequest);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(confirmedServiceRequest);
        if (confirmedServiceResponse.getFileOpen() == null) {
            throw new ServiceError(11, "Error decoding FileOpenResponsePdu");
        }
        Integer32 frsmId = confirmedServiceResponse.getFileOpen().getFrsmID();
        return frsmId;
    }

    private boolean readNextFileDataBlock(Integer32 frsmId, GetFileListener listener) throws ServiceError, IOException {
        FileReadRequest fileReadRequest = new FileReadRequest(frsmId.longValue());
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setFileRead(fileReadRequest);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(confirmedServiceRequest);
        if (confirmedServiceResponse.getFileRead() == null) {
            throw new ServiceError(11, "Error decoding FileReadResponsePdu");
        }
        byte[] fileData = confirmedServiceResponse.getFileRead().getFileData().value;
        boolean moreFollows = true;
        if (confirmedServiceResponse.getFileRead().getMoreFollows() != null) {
            moreFollows = confirmedServiceResponse.getFileRead().getMoreFollows().value;
        }
        if (listener != null) {
            boolean continueRead = listener.dataReceived(fileData, moreFollows);
            if (moreFollows) {
                moreFollows = continueRead;
            }
        }
        return moreFollows;
    }

    private void closeFile(Integer32 frsmId) throws ServiceError, IOException {
        FileCloseRequest fileCloseRequest = new FileCloseRequest(frsmId.longValue());
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setFileClose(fileCloseRequest);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(confirmedServiceRequest);
        if (confirmedServiceResponse.getFileClose() == null) {
            throw new ServiceError(11, "Error decoding FileCloseResponsePdu");
        }
    }

    public void getFile(String filename, GetFileListener listener) throws ServiceError, IOException {
        Integer32 frsmId = this.openFile(filename);
        boolean moreFollows = true;
        while (moreFollows) {
            moreFollows = this.readNextFileDataBlock(frsmId, listener);
        }
        this.closeFile(frsmId);
    }

    public void getAllDataValues() throws ServiceError, IOException {
        for (ModelNode logicalDevice : this.serverModel.getChildren()) {
            for (ModelNode logicalNode : logicalDevice.getChildren()) {
                for (ModelNode dataObject : logicalNode.getChildren()) {
                    FcModelNode fcdo = (FcModelNode)dataObject;
                    if (fcdo.getFc() == Fc.CO || fcdo.getFc() == Fc.SE) continue;
                    try {
                        this.getDataValues(fcdo);
                    }
                    catch (ServiceError e) {
                        throw new ServiceError(e.getErrorCode(), "service error retrieving " + fcdo.getReference() + "[" + (Object)((Object)fcdo.getFc()) + "], " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    private ConfirmedServiceRequest constructGetDataValuesRequest(FcModelNode modelNode) {
        VariableAccessSpecification varAccessSpec = this.constructVariableAccessSpecification(modelNode);
        ReadRequest readRequest = new ReadRequest();
        readRequest.setVariableAccessSpecification(varAccessSpec);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setRead(readRequest);
        return confirmedServiceRequest;
    }

    private void decodeGetDataValuesResponse(ConfirmedServiceResponse confirmedServiceResponse, ModelNode modelNode) throws ServiceError {
        if (confirmedServiceResponse.getRead() == null) {
            throw new ServiceError(11, "Error decoding GetDataValuesReponsePdu");
        }
        List<AccessResult> listOfAccessResults = confirmedServiceResponse.getRead().getListOfAccessResult().getAccessResult();
        if (listOfAccessResults.size() != 1) {
            throw new ServiceError(5, "Multiple results received.");
        }
        AccessResult accRes = listOfAccessResults.get(0);
        if (accRes.getFailure() != null) {
            throw ClientAssociation.mmsDataAccessErrorToServiceError(accRes.getFailure());
        }
        modelNode.setValueFromMmsDataObj(accRes.getSuccess());
    }

    public void setDataValues(FcModelNode modelNode) throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest = this.constructSetDataValuesRequest(modelNode);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
        this.decodeSetDataValuesResponse(confirmedServiceResponse);
    }

    private ConfirmedServiceRequest constructSetDataValuesRequest(FcModelNode modelNode) throws ServiceError {
        VariableAccessSpecification variableAccessSpecification = this.constructVariableAccessSpecification(modelNode);
        WriteRequest.ListOfData listOfData = new WriteRequest.ListOfData();
        List<Data> dataList = listOfData.getData();
        dataList.add(modelNode.getMmsDataObj());
        WriteRequest writeRequest = new WriteRequest();
        writeRequest.setListOfData(listOfData);
        writeRequest.setVariableAccessSpecification(variableAccessSpecification);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setWrite(writeRequest);
        return confirmedServiceRequest;
    }

    private VariableAccessSpecification constructVariableAccessSpecification(FcModelNode modelNode) {
        VariableDefs listOfVariable = new VariableDefs();
        List<VariableDefs.SEQUENCE> variableDefsSeqOf = listOfVariable.getSEQUENCE();
        variableDefsSeqOf.add(modelNode.getMmsVariableDef());
        VariableAccessSpecification variableAccessSpecification = new VariableAccessSpecification();
        variableAccessSpecification.setListOfVariable(listOfVariable);
        return variableAccessSpecification;
    }

    private void decodeSetDataValuesResponse(ConfirmedServiceResponse confirmedServiceResponse) throws ServiceError {
        WriteResponse writeResponse = confirmedServiceResponse.getWrite();
        if (writeResponse == null) {
            throw new ServiceError(11, "SetDataValuesResponse: improper response");
        }
        WriteResponse.CHOICE subChoice = writeResponse.getCHOICE().get(0);
        if (subChoice.getFailure() != null) {
            throw ClientAssociation.mmsDataAccessErrorToServiceError(subChoice.getFailure());
        }
    }

    public void updateDataSets() throws ServiceError, IOException {
        if (this.serverModel == null) {
            throw new IllegalStateException("Before calling this function you have to get the ServerModel using the retrieveModel() function");
        }
        Collection<ModelNode> lds = this.serverModel.getChildren();
        for (ModelNode ld : lds) {
            ConfirmedServiceRequest serviceRequest = this.constructGetDirectoryRequest(ld.getName(), "", false);
            ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
            this.decodeAndRetrieveDsNamesAndDefinitions(confirmedServiceResponse, (LogicalDevice)ld);
        }
    }

    private void decodeAndRetrieveDsNamesAndDefinitions(ConfirmedServiceResponse confirmedServiceResponse, LogicalDevice ld) throws ServiceError, IOException {
        if (confirmedServiceResponse.getGetNameList() == null) {
            throw new ServiceError(11, "decodeGetDataSetResponse: Error decoding server response");
        }
        GetNameListResponse getNameListResponse = confirmedServiceResponse.getGetNameList();
        List<Identifier> identifiers = getNameListResponse.getListOfIdentifier().getIdentifier();
        if (identifiers.size() == 0) {
            return;
        }
        for (Identifier identifier : identifiers) {
            this.getDataSetDirectory(identifier, ld);
        }
        if (getNameListResponse.getMoreFollows() != null && getNameListResponse.getMoreFollows().value) {
            throw new ServiceError(11);
        }
    }

    private void getDataSetDirectory(Identifier dsId, LogicalDevice ld) throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest = this.constructGetDataSetDirectoryRequest(dsId, ld);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
        this.decodeGetDataSetDirectoryResponse(confirmedServiceResponse, dsId, ld);
    }

    private ConfirmedServiceRequest constructGetDataSetDirectoryRequest(Identifier dsId, LogicalDevice ld) throws ServiceError {
        ObjectName.DomainSpecific domainSpecificObjectName = new ObjectName.DomainSpecific();
        domainSpecificObjectName.setDomainID(new Identifier(ld.getName().getBytes(StandardCharsets.UTF_8)));
        domainSpecificObjectName.setItemID(dsId);
        GetNamedVariableListAttributesRequest dataSetObj = new GetNamedVariableListAttributesRequest();
        dataSetObj.setDomainSpecific(domainSpecificObjectName);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setGetNamedVariableListAttributes(dataSetObj);
        return confirmedServiceRequest;
    }

    private void decodeGetDataSetDirectoryResponse(ConfirmedServiceResponse confirmedServiceResponse, BerVisibleString dsId, LogicalDevice ld) throws ServiceError {
        if (confirmedServiceResponse.getGetNamedVariableListAttributes() == null) {
            throw new ServiceError(11, "decodeGetDataSetDirectoryResponse: Error decoding server response");
        }
        GetNamedVariableListAttributesResponse getNamedVariableListAttResponse = confirmedServiceResponse.getGetNamedVariableListAttributes();
        boolean deletable = getNamedVariableListAttResponse.getMmsDeletable().value;
        List<VariableDefs.SEQUENCE> variables = getNamedVariableListAttResponse.getListOfVariable().getSEQUENCE();
        if (variables.size() == 0) {
            throw new ServiceError(1, "decodeGetDataSetDirectoryResponse: Instance not available");
        }
        ArrayList<FcModelNode> dsMems = new ArrayList<FcModelNode>();
        for (VariableDefs.SEQUENCE variableDef : variables) {
            FcModelNode member;
            try {
                member = this.serverModel.getNodeFromVariableDef(variableDef);
            }
            catch (ServiceError e) {
                return;
            }
            if (member == null) {
                throw new ServiceError(1, "decodeGetDataSetDirectoryResponse: data set memeber does not exist, you might have to call retrieveModel first");
            }
            dsMems.add(member);
        }
        String dsObjRef = ld.getName() + "/" + dsId.toString().replace('$', '.');
        DataSet dataSet = new DataSet(dsObjRef, dsMems, deletable);
        if (ld.getChild(dsId.toString().substring(0, dsId.toString().indexOf(36))) == null) {
            throw new ServiceError(1, "decodeGetDataSetDirectoryResponse: LN for returned DataSet is not available");
        }
        DataSet existingDs = this.serverModel.getDataSet(dsObjRef);
        if (existingDs == null) {
            this.serverModel.addDataSet(dataSet);
        } else {
            if (!existingDs.isDeletable()) {
                return;
            }
            this.serverModel.removeDataSet(dsObjRef);
            this.serverModel.addDataSet(dataSet);
        }
    }

    public void createDataSet(DataSet dataSet) throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest = this.constructCreateDataSetRequest(dataSet);
        this.encodeWriteReadDecode(serviceRequest);
        this.handleCreateDataSetResponse(dataSet);
    }

    private ConfirmedServiceRequest constructCreateDataSetRequest(DataSet dataSet) throws ServiceError {
        VariableDefs listOfVariable = new VariableDefs();
        List<VariableDefs.SEQUENCE> variableDefs = listOfVariable.getSEQUENCE();
        for (FcModelNode dsMember : dataSet) {
            variableDefs.add(dsMember.getMmsVariableDef());
        }
        DefineNamedVariableListRequest createDSRequest = new DefineNamedVariableListRequest();
        createDSRequest.setVariableListName(dataSet.getMmsObjectName());
        createDSRequest.setListOfVariable(listOfVariable);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setDefineNamedVariableList(createDSRequest);
        return confirmedServiceRequest;
    }

    private void handleCreateDataSetResponse(DataSet dataSet) throws ServiceError {
        this.serverModel.addDataSet(dataSet);
    }

    public void deleteDataSet(DataSet dataSet) throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest = this.constructDeleteDataSetRequest(dataSet);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
        this.decodeDeleteDataSetResponse(confirmedServiceResponse, dataSet);
    }

    private ConfirmedServiceRequest constructDeleteDataSetRequest(DataSet dataSet) throws ServiceError {
        DeleteNamedVariableListRequest.ListOfVariableListName listOfVariableListName = new DeleteNamedVariableListRequest.ListOfVariableListName();
        List<ObjectName> objectList = listOfVariableListName.getObjectName();
        objectList.add(dataSet.getMmsObjectName());
        DeleteNamedVariableListRequest requestDeleteDS = new DeleteNamedVariableListRequest();
        requestDeleteDS.setListOfVariableListName(listOfVariableListName);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setDeleteNamedVariableList(requestDeleteDS);
        return confirmedServiceRequest;
    }

    private void decodeDeleteDataSetResponse(ConfirmedServiceResponse confirmedServiceResponse, DataSet dataSet) throws ServiceError {
        if (confirmedServiceResponse.getDeleteNamedVariableList() == null) {
            throw new ServiceError(11, "decodeDeleteDataSetResponse: Error decoding server response");
        }
        DeleteNamedVariableListResponse deleteNamedVariableListResponse = confirmedServiceResponse.getDeleteNamedVariableList();
        if (deleteNamedVariableListResponse.getNumberDeleted().intValue() != 1) {
            throw new ServiceError(11, "number deleted not 1");
        }
        if (this.serverModel.removeDataSet(dataSet.getReferenceStr()) == null) {
            throw new ServiceError(23, "unable to delete dataset locally");
        }
    }

    public List<ServiceError> getDataSetValues(DataSet dataSet) throws IOException {
        ConfirmedServiceResponse confirmedServiceResponse;
        try {
            ConfirmedServiceRequest serviceRequest = this.constructGetDataSetValuesRequest(dataSet);
            confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
        }
        catch (ServiceError e) {
            int dataSetSize = dataSet.getMembers().size();
            ArrayList<ServiceError> serviceErrors = new ArrayList<ServiceError>(dataSetSize);
            for (int i = 0; i < dataSetSize; ++i) {
                serviceErrors.add(e);
            }
            return serviceErrors;
        }
        return this.decodeGetDataSetValuesResponse(confirmedServiceResponse, dataSet);
    }

    private ConfirmedServiceRequest constructGetDataSetValuesRequest(DataSet dataSet) throws ServiceError {
        VariableAccessSpecification varAccSpec = new VariableAccessSpecification();
        varAccSpec.setVariableListName(dataSet.getMmsObjectName());
        ReadRequest getDataSetValuesRequest = new ReadRequest();
        getDataSetValuesRequest.setSpecificationWithResult(new BerBoolean(true));
        getDataSetValuesRequest.setVariableAccessSpecification(varAccSpec);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setRead(getDataSetValuesRequest);
        return confirmedServiceRequest;
    }

    private List<ServiceError> decodeGetDataSetValuesResponse(ConfirmedServiceResponse confirmedServiceResponse, DataSet ds) {
        int dataSetSize = ds.getMembers().size();
        ArrayList<ServiceError> serviceErrors = new ArrayList<ServiceError>(dataSetSize);
        if (confirmedServiceResponse.getRead() == null) {
            ServiceError serviceError = new ServiceError(11, "Error decoding GetDataValuesReponsePdu");
            for (int i = 0; i < dataSetSize; ++i) {
                serviceErrors.add(serviceError);
            }
            return serviceErrors;
        }
        ReadResponse readResponse = confirmedServiceResponse.getRead();
        List<AccessResult> listOfAccessResults = readResponse.getListOfAccessResult().getAccessResult();
        if (listOfAccessResults.size() != ds.getMembers().size()) {
            ServiceError serviceError = new ServiceError(5, "Number of AccessResults does not match the number of DataSet members.");
            for (int i = 0; i < dataSetSize; ++i) {
                serviceErrors.add(serviceError);
            }
            return serviceErrors;
        }
        Iterator<AccessResult> accessResultIterator = listOfAccessResults.iterator();
        for (FcModelNode dsMember : ds) {
            AccessResult accessResult = accessResultIterator.next();
            if (accessResult.getSuccess() != null) {
                try {
                    dsMember.setValueFromMmsDataObj(accessResult.getSuccess());
                }
                catch (ServiceError e) {
                    serviceErrors.add(e);
                }
                serviceErrors.add(null);
                continue;
            }
            serviceErrors.add(ClientAssociation.mmsDataAccessErrorToServiceError(accessResult.getFailure()));
        }
        return serviceErrors;
    }

    public List<ServiceError> setDataSetValues(DataSet dataSet) throws ServiceError, IOException {
        ConfirmedServiceRequest serviceRequest = this.constructSetDataSetValues(dataSet);
        ConfirmedServiceResponse confirmedServiceResponse = this.encodeWriteReadDecode(serviceRequest);
        return this.decodeSetDataSetValuesResponse(confirmedServiceResponse);
    }

    private ConfirmedServiceRequest constructSetDataSetValues(DataSet dataSet) throws ServiceError {
        VariableAccessSpecification varAccessSpec = new VariableAccessSpecification();
        varAccessSpec.setVariableListName(dataSet.getMmsObjectName());
        WriteRequest.ListOfData listOfData = new WriteRequest.ListOfData();
        List<Data> dataList = listOfData.getData();
        for (ModelNode member : dataSet) {
            dataList.add(member.getMmsDataObj());
        }
        WriteRequest writeRequest = new WriteRequest();
        writeRequest.setVariableAccessSpecification(varAccessSpec);
        writeRequest.setListOfData(listOfData);
        ConfirmedServiceRequest confirmedServiceRequest = new ConfirmedServiceRequest();
        confirmedServiceRequest.setWrite(writeRequest);
        return confirmedServiceRequest;
    }

    private List<ServiceError> decodeSetDataSetValuesResponse(ConfirmedServiceResponse confirmedServiceResponse) throws ServiceError {
        if (confirmedServiceResponse.getWrite() == null) {
            throw new ServiceError(11, "Error decoding SetDataSetValuesReponsePdu");
        }
        WriteResponse writeResponse = confirmedServiceResponse.getWrite();
        List<WriteResponse.CHOICE> writeResChoiceType = writeResponse.getCHOICE();
        ArrayList<ServiceError> serviceErrors = new ArrayList<ServiceError>(writeResChoiceType.size());
        for (WriteResponse.CHOICE accessResult : writeResChoiceType) {
            if (accessResult.getSuccess() != null) {
                serviceErrors.add(null);
                continue;
            }
            serviceErrors.add(ClientAssociation.mmsDataAccessErrorToServiceError(accessResult.getFailure()));
        }
        return serviceErrors;
    }

    public void getRcbValues(Rcb rcb) throws ServiceError, IOException {
        this.getDataValues(rcb);
    }

    public void reserveUrcb(Urcb urcb) throws ServiceError, IOException {
        BdaBoolean resvBda = urcb.getResv();
        resvBda.setValue(true);
        this.setDataValues(resvBda);
    }

    public void reserveBrcb(Brcb brcb, short resvTime) throws ServiceError, IOException {
        BdaInt16 resvTmsBda = brcb.getResvTms();
        resvTmsBda.setValue(resvTime);
        this.setDataValues(resvTmsBda);
    }

    public void cancelUrcbReservation(Urcb urcb) throws ServiceError, IOException {
        BdaBoolean resvBda = urcb.getResv();
        resvBda.setValue(false);
        this.setDataValues(resvBda);
    }

    public void enableReporting(Rcb rcb) throws ServiceError, IOException {
        BdaBoolean rptEnaBda = rcb.getRptEna();
        rptEnaBda.setValue(true);
        this.setDataValues(rptEnaBda);
    }

    public void disableReporting(Rcb rcb) throws ServiceError, IOException {
        BdaBoolean rptEnaBda = rcb.getRptEna();
        rptEnaBda.setValue(false);
        this.setDataValues(rptEnaBda);
    }

    public void startGi(Rcb rcb) throws ServiceError, IOException {
        BdaBoolean rptGiBda = (BdaBoolean)rcb.getChild("GI");
        rptGiBda.setValue(true);
        this.setDataValues(rptGiBda);
    }

    public List<ServiceError> setRcbValues(Rcb rcb, boolean setRptId, boolean setDatSet, boolean setOptFlds, boolean setBufTm, boolean setTrgOps, boolean setIntgPd, boolean setPurgeBuf, boolean setEntryId) throws IOException {
        ArrayList<BasicDataAttribute> parametersToSet = new ArrayList<BasicDataAttribute>(6);
        if (setRptId) {
            parametersToSet.add(rcb.getRptId());
        }
        if (setDatSet) {
            rcb.getDatSet().setValue(rcb.getDatSet().getStringValue().replace('.', '$'));
            parametersToSet.add(rcb.getDatSet());
        }
        if (setOptFlds) {
            parametersToSet.add(rcb.getOptFlds());
        }
        if (setBufTm) {
            parametersToSet.add(rcb.getBufTm());
        }
        if (setTrgOps) {
            parametersToSet.add(rcb.getTrgOps());
        }
        if (setIntgPd) {
            parametersToSet.add(rcb.getIntgPd());
        }
        if (rcb instanceof Brcb) {
            Brcb brcb = (Brcb)rcb;
            if (setPurgeBuf) {
                parametersToSet.add(brcb.getPurgeBuf());
            }
            if (setEntryId) {
                parametersToSet.add(brcb.getEntryId());
            }
        }
        ArrayList<ServiceError> serviceErrors = new ArrayList<ServiceError>(parametersToSet.size());
        for (FcModelNode fcModelNode : parametersToSet) {
            try {
                this.setDataValues(fcModelNode);
                serviceErrors.add(null);
            }
            catch (ServiceError e) {
                serviceErrors.add(e);
            }
        }
        return serviceErrors;
    }

    private Report processReport(MMSpdu mmsPdu) throws ServiceError {
        int index;
        if (mmsPdu.getUnconfirmedPDU() == null) {
            throw new ServiceError(11, "getReport: Error decoding server response");
        }
        UnconfirmedPDU unconfirmedRes = mmsPdu.getUnconfirmedPDU();
        if (unconfirmedRes.getService() == null) {
            throw new ServiceError(11, "getReport: Error decoding server response");
        }
        UnconfirmedService unconfirmedServ = unconfirmedRes.getService();
        if (unconfirmedServ.getInformationReport() == null) {
            throw new ServiceError(11, "getReport: Error decoding server response");
        }
        List<AccessResult> listRes = unconfirmedServ.getInformationReport().getListOfAccessResult().getAccessResult();
        if (listRes.get(index = 0).getSuccess().getVisibleString() == null) {
            throw new ServiceError(11, "processReport: report does not contain RptID");
        }
        String rptId = listRes.get(index++).getSuccess().getVisibleString().toString();
        if (listRes.get(index).getSuccess().getBitString() == null) {
            throw new ServiceError(11, "processReport: report does not contain OptFlds");
        }
        BdaOptFlds optFlds = new BdaOptFlds(new ObjectReference("none"), null);
        optFlds.setValue(listRes.get((int)index++).getSuccess().getBitString().value);
        Integer sqNum = null;
        if (optFlds.isSequenceNumber()) {
            sqNum = listRes.get(index++).getSuccess().getUnsigned().intValue();
        }
        BdaEntryTime timeOfEntry = null;
        if (optFlds.isReportTimestamp()) {
            timeOfEntry = new BdaEntryTime(new ObjectReference("none"), null, "", false, false);
            timeOfEntry.setValueFromMmsDataObj(listRes.get(index++).getSuccess());
        }
        String dataSetRef = null;
        if (optFlds.isDataSetName()) {
            dataSetRef = listRes.get(index++).getSuccess().getVisibleString().toString();
        } else {
            for (Urcb urcb : this.serverModel.getUrcbs()) {
                if ((urcb.getRptId() == null || !urcb.getRptId().getStringValue().equals(rptId)) && !urcb.getReference().toString().equals(rptId)) continue;
                dataSetRef = urcb.getDatSet().getStringValue();
                break;
            }
            if (dataSetRef == null) {
                for (Brcb brcb : this.serverModel.getBrcbs()) {
                    if ((brcb.getRptId() == null || !brcb.getRptId().getStringValue().equals(rptId)) && !brcb.getReference().toString().equals(rptId)) continue;
                    dataSetRef = brcb.getDatSet().getStringValue();
                    break;
                }
            }
        }
        if (dataSetRef == null) {
            throw new ServiceError(11, "unable to find RCB that matches the given RptID in the report.");
        }
        DataSet dataSet = this.serverModel.getDataSet(dataSetRef = dataSetRef.replace('$', '.'));
        if (dataSet == null) {
            throw new ServiceError(11, "unable to find data set that matches the given data set reference of the report.");
        }
        Boolean bufOvfl = null;
        if (optFlds.isBufferOverflow()) {
            bufOvfl = listRes.get((int)index++).getSuccess().getBool().value;
        }
        BdaOctetString entryId = null;
        if (optFlds.isEntryId()) {
            entryId = new BdaOctetString(new ObjectReference("none"), null, "", 8, false, false);
            entryId.setValue(listRes.get((int)index++).getSuccess().getOctetString().value);
        }
        Long confRev = null;
        if (optFlds.isConfigRevision()) {
            confRev = listRes.get(index++).getSuccess().getUnsigned().longValue();
        }
        Integer subSqNum = null;
        boolean moreSegmentsFollow = false;
        if (optFlds.isSegmentation()) {
            subSqNum = listRes.get(index++).getSuccess().getUnsigned().intValue();
            moreSegmentsFollow = listRes.get((int)index++).getSuccess().getBool().value;
        }
        boolean[] inclusionBitString = listRes.get(index++).getSuccess().getBitString().getValueAsBooleans();
        int numMembersReported = 0;
        for (boolean bit : inclusionBitString) {
            if (!bit) continue;
            ++numMembersReported;
        }
        if (optFlds.isDataReference()) {
            index += numMembersReported;
        }
        ArrayList<FcModelNode> reportedDataSetMembers = new ArrayList<FcModelNode>(numMembersReported);
        int dataSetIndex = 0;
        for (FcModelNode dataSetMember : dataSet.getMembers()) {
            if (inclusionBitString[dataSetIndex]) {
                AccessResult accessRes = listRes.get(index++);
                FcModelNode dataSetMemberCopy = (FcModelNode)dataSetMember.copy();
                dataSetMemberCopy.setValueFromMmsDataObj(accessRes.getSuccess());
                reportedDataSetMembers.add(dataSetMemberCopy);
            }
            ++dataSetIndex;
        }
        ArrayList<BdaReasonForInclusion> reasonCodes = null;
        if (optFlds.isReasonForInclusion()) {
            reasonCodes = new ArrayList<BdaReasonForInclusion>(dataSet.getMembers().size());
            for (int i = 0; i < dataSet.getMembers().size(); ++i) {
                if (!inclusionBitString[i]) continue;
                BdaReasonForInclusion reasonForInclusion = new BdaReasonForInclusion(null);
                reasonCodes.add(reasonForInclusion);
                byte[] reason = listRes.get((int)index++).getSuccess().getBitString().value;
                reasonForInclusion.setValue(reason);
            }
        }
        return new Report(rptId, sqNum, subSqNum, moreSegmentsFollow, dataSetRef, bufOvfl, confRev, timeOfEntry, entryId, inclusionBitString, reportedDataSetMembers, reasonCodes);
    }

    public boolean select(FcModelNode controlDataObject) throws ServiceError, IOException {
        BdaVisibleString sbo;
        try {
            sbo = (BdaVisibleString)controlDataObject.getChild("SBO");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ModelNode needs to conain a child node named SBO in order to select");
        }
        this.getDataValues(sbo);
        return sbo.getValue().length != 0;
    }

    public void operate(FcModelNode controlDataObject) throws ServiceError, IOException {
        ConstructedDataAttribute oper;
        try {
            oper = (ConstructedDataAttribute)controlDataObject.getChild("Oper");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ModelNode needs to conain a child node named \"Oper\".");
        }
        ((BdaInt8U)oper.getChild("ctlNum")).setValue((short)1);
        ((BdaTimestamp)oper.getChild("T")).setInstant(Instant.now());
        this.setDataValues(oper);
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() {
        this.clientReceiver.close(new IOException("Connection closed by client"));
    }

    public void disconnect() {
        this.clientReceiver.disconnect();
    }

    final class ClientReceiver
    extends Thread {
        private final ByteBuffer pduBuffer;
        private Integer expectedResponseId;
        private IOException lastIOException = null;

        public ClientReceiver(int maxMmsPduSize) {
            this.pduBuffer = ByteBuffer.allocate(maxMmsPduSize + 400);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    BlockingQueue blockingQueue;
                    byte[] buffer;
                    this.pduBuffer.clear();
                    try {
                        buffer = ClientAssociation.this.acseAssociation.receive(this.pduBuffer);
                    }
                    catch (TimeoutException e) {
                        throw new IllegalStateException();
                    }
                    catch (DecodingException e) {
                        continue;
                    }
                    MMSpdu decodedResponsePdu = new MMSpdu();
                    try {
                        decodedResponsePdu.decode(new ByteArrayInputStream(buffer), null);
                    }
                    catch (IOException e) {
                        continue;
                    }
                    if (decodedResponsePdu.getUnconfirmedPDU() != null) {
                        if (decodedResponsePdu.getUnconfirmedPDU().getService().getInformationReport().getVariableAccessSpecification().getListOfVariable() != null || ClientAssociation.this.reportListener == null) continue;
                        final Report report = ClientAssociation.this.processReport(decodedResponsePdu);
                        Thread t1 = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ClientAssociation.this.reportListener.newReport(report);
                            }
                        });
                        t1.start();
                        continue;
                    }
                    if (decodedResponsePdu.getRejectPDU() != null) {
                        blockingQueue = ClientAssociation.this.incomingResponses;
                        synchronized (blockingQueue) {
                            if (this.expectedResponseId == null) {
                                continue;
                            }
                            if (decodedResponsePdu.getRejectPDU().getOriginalInvokeID().value.intValue() != this.expectedResponseId.intValue()) {
                                continue;
                            }
                            try {
                                ClientAssociation.this.incomingResponses.put(decodedResponsePdu);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (decodedResponsePdu.getConfirmedErrorPDU() != null) {
                        blockingQueue = ClientAssociation.this.incomingResponses;
                        synchronized (blockingQueue) {
                            if (this.expectedResponseId == null) {
                                continue;
                            }
                            if (decodedResponsePdu.getConfirmedErrorPDU().getInvokeID().value.intValue() != this.expectedResponseId.intValue()) {
                                continue;
                            }
                            try {
                                ClientAssociation.this.incomingResponses.put(decodedResponsePdu);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    blockingQueue = ClientAssociation.this.incomingResponses;
                    synchronized (blockingQueue) {
                        if (this.expectedResponseId == null) {
                            continue;
                        }
                        if (decodedResponsePdu.getConfirmedResponsePDU().getInvokeID().value.intValue() != this.expectedResponseId.intValue()) {
                            continue;
                        }
                        try {
                            ClientAssociation.this.incomingResponses.put(decodedResponsePdu);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (IOException e) {
                this.close(e);
                return;
            }
            catch (Exception e) {
                this.close(new IOException("unexpected exception while receiving", e));
            }
        }

        public void setResponseExpected(int invokeId) {
            this.expectedResponseId = invokeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disconnect() {
            ClientReceiver clientReceiver = this;
            synchronized (clientReceiver) {
                if (!ClientAssociation.this.closed) {
                    ClientAssociation.this.closed = true;
                    ClientAssociation.this.acseAssociation.disconnect();
                    this.lastIOException = new IOException("Connection disconnected by client");
                    if (ClientAssociation.this.reportListener != null) {
                        Thread t1 = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ClientAssociation.this.reportListener.associationClosed(ClientReceiver.this.lastIOException);
                            }
                        });
                        t1.start();
                    }
                    MMSpdu mmsPdu = new MMSpdu();
                    mmsPdu.setConfirmedRequestPDU(new ConfirmedRequestPDU());
                    try {
                        ClientAssociation.this.incomingResponses.put(mmsPdu);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(IOException e) {
            ClientReceiver clientReceiver = this;
            synchronized (clientReceiver) {
                if (!ClientAssociation.this.closed) {
                    ClientAssociation.this.closed = true;
                    ClientAssociation.this.acseAssociation.close();
                    this.lastIOException = e;
                    Thread t1 = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ClientAssociation.this.reportListener.associationClosed(ClientReceiver.this.lastIOException);
                        }
                    });
                    t1.start();
                    MMSpdu mmsPdu = new MMSpdu();
                    mmsPdu.setConfirmedRequestPDU(new ConfirmedRequestPDU());
                    try {
                        ClientAssociation.this.incomingResponses.put(mmsPdu);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        IOException getLastIOException() {
            return this.lastIOException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MMSpdu removeExpectedResponse() {
            BlockingQueue blockingQueue = ClientAssociation.this.incomingResponses;
            synchronized (blockingQueue) {
                this.expectedResponseId = null;
                return (MMSpdu)ClientAssociation.this.incomingResponses.poll();
            }
        }
    }
}

