/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.asn1bean.ber.types.string.BerVisibleString;
import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.Integer32;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;
import java.nio.charset.StandardCharsets;

public final class BdaVisibleString
extends BasicDataAttribute {
    private final int maxLength;
    private byte[] value;

    public BdaVisibleString(ObjectReference objectReference, Fc fc, String sAddr, int maxLength, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.VISIBLE_STRING;
        this.maxLength = maxLength;
        this.setDefault();
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value == null || value.length > this.maxLength) {
            throw new IllegalArgumentException("value was null or VISIBLE_STRING value size exceeds maxLength of " + this.maxLength);
        }
        this.value = value;
    }

    public void setValue(String value) {
        this.setValue(value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaVisibleString)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getStringValue() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    @Override
    public void setDefault() {
        this.value = new byte[0];
    }

    @Override
    public BdaVisibleString copy() {
        BdaVisibleString copy = new BdaVisibleString(this.objectReference, this.fc, this.sAddr, this.maxLength, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setVisibleString(new BerVisibleString(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getVisibleString() == null) {
            throw new ServiceError(10, "expected type: visible_string");
        }
        this.value = data.getVisibleString().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setVisibleString(new Integer32(this.maxLength * -1));
        return typeDescription;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return this.getReference().toString() + ": null";
        }
        if (this.value.length == 0 || this.value[0] == 0) {
            return this.getReference().toString() + ": ''";
        }
        return this.getReference().toString() + ": " + new String(this.value, StandardCharsets.UTF_8);
    }

    @Override
    public String getValueString() {
        return new String(this.value, StandardCharsets.UTF_8);
    }
}

