/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.asn1bean.ber.types.BerNull;
import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;
import com.beanit.iec61850bean.internal.mms.asn1.UtcTime;
import java.time.Instant;

public final class BdaTimestamp
extends BasicDataAttribute {
    private volatile byte[] value;

    public BdaTimestamp(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.TIMESTAMP;
        this.setDefault();
    }

    private long getSecondsSinceEpoch() {
        return (0xFFL & (long)this.value[0]) << 24 | (0xFFL & (long)this.value[1]) << 16 | (0xFFL & (long)this.value[2]) << 8 | 0xFFL & (long)this.value[3];
    }

    private int getFractionOfSecond() {
        return (0xFF & this.value[4]) << 16 | (0xFF & this.value[5]) << 8 | 0xFF & this.value[6];
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaTimestamp)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public Instant getInstant() {
        if (this.value == null || this.value.length == 0) {
            return null;
        }
        long time = this.getSecondsSinceEpoch() * 1000L + (long)((double)((float)this.getFractionOfSecond() / 1.6777216E7f * 1000.0f) + 0.5);
        return Instant.ofEpochMilli(time);
    }

    public void setInstant(Instant instant) {
        this.setInstant(instant, true, false, false, 10);
    }

    public void setInstant(Instant instant, boolean leapSecondsKnown, boolean clockFailure, boolean clockNotSynchronized, int timeAccuracy) {
        if (this.value == null) {
            this.value = new byte[8];
        }
        int secondsSinceEpoch = (int)(instant.toEpochMilli() / 1000L);
        int fractionOfSecond = (int)((double)(instant.toEpochMilli() % 1000L) / 1000.0 * 1.6777216E7);
        int timeQuality = timeAccuracy & 0x1F;
        if (leapSecondsKnown) {
            timeQuality |= 0x80;
        }
        if (clockFailure) {
            timeQuality |= 0x40;
        }
        if (clockNotSynchronized) {
            timeQuality |= 0x20;
        }
        this.value = new byte[]{(byte)(secondsSinceEpoch >> 24 & 0xFF), (byte)(secondsSinceEpoch >> 16 & 0xFF), (byte)(secondsSinceEpoch >> 8 & 0xFF), (byte)(secondsSinceEpoch & 0xFF), (byte)(fractionOfSecond >> 16 & 0xFF), (byte)(fractionOfSecond >> 8 & 0xFF), (byte)(fractionOfSecond & 0xFF), (byte)timeQuality};
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value == null) {
            this.value = new byte[8];
        }
        this.value = value;
    }

    public boolean getLeapSecondsKnown() {
        return (this.value[7] & 0x80) != 0;
    }

    public boolean getClockFailure() {
        return (this.value[7] & 0x40) != 0;
    }

    public boolean getClockNotSynchronized() {
        return (this.value[7] & 0x20) != 0;
    }

    public int getTimeAccuracy() {
        return this.value[7] & 0x1F;
    }

    @Override
    public void setDefault() {
        this.value = new byte[8];
    }

    public void setCurrentTime() {
        this.setInstant(Instant.now());
    }

    @Override
    public BdaTimestamp copy() {
        BdaTimestamp copy = new BdaTimestamp(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setUtcTime(new UtcTime(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getUtcTime() == null) {
            throw new ServiceError(10, "expected type: utc_time/timestamp");
        }
        this.value = data.getUtcTime().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setUtcTime(new BerNull());
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + this.getInstant();
    }

    @Override
    public String getValueString() {
        return this.getInstant().toString();
    }
}

